/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.ls.core.internal.StatusFactory;

public final class ResourceUtils {
    public static final String FILE_UNC_PREFIX = "file:////";

    private ResourceUtils() {
    }

    public static List<IMarker> findMarkers(IResource resource, Integer ... severities) throws CoreException {
        if (resource == null) {
            return null;
        }
        HashSet<Integer> targetSeverities = severities == null ? Collections.emptySet() : new HashSet<Integer>(Arrays.asList(severities));
        IMarker[] allmarkers = resource.findMarkers(null, true, 2);
        List<IMarker> markers = Stream.of(allmarkers).filter(m -> targetSeverities.isEmpty() || targetSeverities.contains(m.getAttribute("severity", 0))).collect(Collectors.toList());
        return markers;
    }

    public static List<IMarker> getErrorMarkers(IResource resource) throws CoreException {
        return ResourceUtils.findMarkers(resource, 2);
    }

    public static String toString(List<IMarker> markers) {
        if (markers == null || markers.isEmpty()) {
            return "";
        }
        String s = markers.stream().map(m -> ResourceUtils.toString(m)).collect(Collectors.joining(", "));
        return s;
    }

    public static String toString(IMarker marker) {
        if (marker == null) {
            return null;
        }
        try {
            StringBuilder sb = new StringBuilder("Type=").append(marker.getType()).append(":Message=").append(marker.getAttribute("message")).append(":LineNumber=").append(marker.getAttribute("lineNumber"));
            return sb.toString();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return "Unknown marker";
        }
    }

    public static String getContent(URI fileURI) throws CoreException {
        String content;
        if (fileURI == null) {
            return null;
        }
        try {
            content = Files.toString((File)ResourceUtils.toFile(fileURI), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new CoreException(StatusFactory.newErrorStatus("Can not get " + fileURI + " content", e));
        }
        return content;
    }

    public static void setContent(URI fileURI, String content) throws CoreException {
        if (content == null) {
            content = "";
        }
        try {
            Files.write((CharSequence)content, (File)ResourceUtils.toFile(fileURI), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new CoreException(StatusFactory.newErrorStatus("Can not write to " + fileURI, e));
        }
    }

    public static String fixURI(URI uri) {
        if ("win32".equals(Platform.getOS())) {
            uri = URIUtil.toFile((URI)uri).toURI();
        }
        String uriString = uri.toString();
        return uriString.replaceFirst("file:/([^/])", "file:///$1");
    }

    public static File toFile(URI uri) {
        if ("win32".equals(Platform.getOS())) {
            return URIUtil.toFile((URI)uri);
        }
        return new File(uri);
    }

    public static String toClientUri(String uri) {
        if (uri != null && "win32".equals(Platform.getOS()) && uri.startsWith(FILE_UNC_PREFIX)) {
            uri = uri.replace(FILE_UNC_PREFIX, "file://");
        }
        return uri;
    }

    public static IPath filePathFromURI(String uriStr) {
        URI uri = URI.create(uriStr);
        if ("file".equals(uri.getScheme())) {
            return Path.fromOSString((String)Paths.get(uri).toString());
        }
        return null;
    }

    public static boolean isContainedIn(IPath location, Collection<IPath> paths) {
        for (IPath path : paths) {
            if (!path.isPrefixOf(location)) continue;
            return true;
        }
        return false;
    }
}

