/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.fix;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.ls.core.internal.corext.fix.AbstractFix;
import org.eclipse.jdt.ls.core.internal.corext.fix.FixMessages;
import org.eclipse.jdt.ls.core.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.text.edits.TextEditGroup;

public class CompilationUnitRewriteOperationsFix
extends AbstractFix {
    private final CompilationUnitRewriteOperation[] fOperations;
    private final CompilationUnit fCompilationUnit;
    private final LinkedProposalModel fLinkedProposalModel;

    public CompilationUnitRewriteOperationsFix(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperation operation) {
        this(name, compilationUnit, new CompilationUnitRewriteOperation[]{operation});
        Assert.isNotNull((Object)operation);
    }

    public CompilationUnitRewriteOperationsFix(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperation[] operations) {
        super(name);
        Assert.isNotNull((Object)operations);
        Assert.isLegal((operations.length > 0 ? 1 : 0) != 0);
        this.fCompilationUnit = compilationUnit;
        this.fOperations = operations;
        this.fLinkedProposalModel = new LinkedProposalModel();
    }

    @Override
    public LinkedProposalModel getLinkedPositions() {
        if (!this.fLinkedProposalModel.hasLinkedPositions()) {
            return null;
        }
        return this.fLinkedProposalModel;
    }

    @Override
    public CompilationUnitChange createChange(IProgressMonitor progressMonitor) throws CoreException {
        CompilationUnitRewrite cuRewrite = new CompilationUnitRewrite((ICompilationUnit)this.fCompilationUnit.getJavaElement(), this.fCompilationUnit);
        this.fLinkedProposalModel.clear();
        int i = 0;
        while (i < this.fOperations.length) {
            CompilationUnitRewriteOperation operation = this.fOperations[i];
            operation.rewriteAST(cuRewrite, this.fLinkedProposalModel);
            ++i;
        }
        CompilationUnitChange result = cuRewrite.createChange(this.getDisplayString(), true, null);
        if (result == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", Messages.format(FixMessages.CompilationUnitRewriteOperationsFix_nullChangeError, this.getDisplayString())));
        }
        return result;
    }

    @Override
    public String getAdditionalProposalInfo() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.fOperations.length) {
            CompilationUnitRewriteOperation operation = this.fOperations[i];
            String info = operation.getAdditionalInfo();
            if (info != null) {
                sb.append(info);
            }
            ++i;
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    public static abstract class CompilationUnitRewriteOperation {
        public abstract void rewriteAST(CompilationUnitRewrite var1, LinkedProposalModel var2) throws CoreException;

        protected Type importType(ITypeBinding toImport, ASTNode accessor, ImportRewrite imports, CompilationUnit compilationUnit) {
            ContextSensitiveImportRewriteContext importContext = new ContextSensitiveImportRewriteContext(compilationUnit, accessor.getStartPosition(), imports);
            return imports.addImport(toImport, compilationUnit.getAST(), (ImportRewrite.ImportRewriteContext)importContext);
        }

        protected TextEditGroup createTextEditGroup(String label, CompilationUnitRewrite rewrite) {
            if (label.length() > 0) {
                return rewrite.createCategorizedGroupDescription(label, new GroupCategorySet(new GroupCategory(label, label, label)));
            }
            return rewrite.createGroupDescription(label);
        }

        public String getAdditionalInfo() {
            return null;
        }
    }
}

