/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.CopyTargetEdit;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MoveSourceEdit;
import org.eclipse.text.edits.MoveTargetEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditVisitor;

public class EditAnnotator
extends TextEditVisitor {
    private int fWrittenToPos = 0;
    private final StringBuffer fBuf;
    private final IDocument fPreviewDocument;

    public EditAnnotator(StringBuffer buffer, IDocument previewDoc) {
        this.fBuf = buffer;
        this.fPreviewDocument = previewDoc;
    }

    public void unchangedUntil(int pos) {
        if (pos > this.fWrittenToPos) {
            this.appendContent(this.fPreviewDocument, this.fWrittenToPos, pos, true);
            this.fWrittenToPos = pos;
        }
    }

    public boolean visit(MoveTargetEdit edit) {
        return true;
    }

    public boolean visit(CopyTargetEdit edit) {
        return true;
    }

    public boolean visit(InsertEdit edit) {
        return this.rangeAdded((TextEdit)edit);
    }

    public boolean visit(ReplaceEdit edit) {
        if (edit.getLength() > 0) {
            return this.rangeAdded((TextEdit)edit);
        }
        return this.rangeRemoved((TextEdit)edit);
    }

    public boolean visit(MoveSourceEdit edit) {
        return this.rangeRemoved((TextEdit)edit);
    }

    public boolean visit(DeleteEdit edit) {
        return this.rangeRemoved((TextEdit)edit);
    }

    protected boolean rangeRemoved(TextEdit edit) {
        this.unchangedUntil(edit.getOffset());
        return false;
    }

    private boolean rangeAdded(TextEdit edit) {
        return this.annotateEdit(edit, "<b>", "</b>");
    }

    protected boolean annotateEdit(TextEdit edit, String startTag, String endTag) {
        this.unchangedUntil(edit.getOffset());
        this.fBuf.append(startTag);
        this.appendContent(this.fPreviewDocument, edit.getOffset(), edit.getExclusiveEnd(), false);
        this.fBuf.append(endTag);
        this.fWrittenToPos = edit.getExclusiveEnd();
        return false;
    }

    private void appendContent(IDocument text, int startOffset, int endOffset, boolean surroundLinesOnly) {
        boolean surroundLines = true;
        try {
            int startLine = text.getLineOfOffset(startOffset);
            int endLine = text.getLineOfOffset(endOffset);
            boolean dotsAdded = false;
            if (surroundLinesOnly && startOffset == 0) {
                startLine = Math.max(endLine - 1, 0);
                this.fBuf.append("...<br>");
                dotsAdded = true;
            }
            int i = startLine;
            while (i <= endLine) {
                if (surroundLinesOnly && i - startLine > 1 && endLine - i > 1) {
                    if (!dotsAdded) {
                        this.fBuf.append("...<br>");
                        dotsAdded = true;
                    } else if (endOffset == text.getLength()) {
                        return;
                    }
                } else {
                    IRegion lineInfo = text.getLineInformation(i);
                    int start = lineInfo.getOffset();
                    int end = start + lineInfo.getLength();
                    int from = Math.max(start, startOffset);
                    int to = Math.min(end, endOffset);
                    String content = text.get(from, to - from);
                    if (!surroundLinesOnly || from != start || !this.containsOnlyWhitespaces(content)) {
                        int k = 0;
                        while (k < content.length()) {
                            char ch = content.charAt(k);
                            if (ch == '<') {
                                this.fBuf.append("&lt;");
                            } else if (ch == '>') {
                                this.fBuf.append("&gt;");
                            } else {
                                this.fBuf.append(ch);
                            }
                            ++k;
                        }
                        if (to == end && to != endOffset) {
                            this.fBuf.append("<br>");
                        }
                    }
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private boolean containsOnlyWhitespaces(String s) {
        int size = s.length();
        int i = 0;
        while (i < size) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

