/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corext.codemanipulation.CodeGeneration;
import org.eclipse.jdt.ls.core.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.ls.core.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.ls.core.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.ls.core.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.ls.core.internal.corrections.ASTResolving;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ASTRewriteCorrectionProposal;

public class SelfEncapsulateFieldProposal
extends ASTRewriteCorrectionProposal {
    private static final String[] EMPTY = new String[0];
    private boolean isGetter;
    private IField fField;
    private IVariableBinding fVariableBinding;
    private ASTNode fNode;
    private ITypeBinding fSenderBinding;

    public SelfEncapsulateFieldProposal(String label, ICompilationUnit targetCU, ASTNode invocationNode, IVariableBinding binding, IField field, int relevance) {
        super(label, targetCU, (ASTRewrite)null, relevance);
        this.fField = field;
        this.fVariableBinding = binding;
        this.fSenderBinding = binding.getDeclaringClass();
        this.fNode = invocationNode;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit astRoot = ASTResolving.findParentCompilationUnit((ASTNode)this.fNode);
        ASTNode typeDecl = astRoot.findDeclaringNode((IBinding)this.fSenderBinding);
        ASTNode newTypeDecl = null;
        if (typeDecl != null) {
            newTypeDecl = typeDecl;
        } else {
            astRoot = ASTResolving.createQuickFixAST((ICompilationUnit)this.getCompilationUnit(), null);
            newTypeDecl = astRoot.findDeclaringNode(this.fSenderBinding.getKey());
        }
        this.createImportRewrite(astRoot);
        if (newTypeDecl != null) {
            ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
            ChildListPropertyDescriptor property = ASTNodes.getBodyDeclarationsProperty(newTypeDecl);
            List<BodyDeclaration> members = ASTNodes.getBodyDeclarations(newTypeDecl);
            int insertIndex = members.size();
            ListRewrite listRewriter = rewrite.getListRewrite(newTypeDecl, property);
            this.isGetter = true;
            MethodDeclaration newStub = this.getStub(rewrite, newTypeDecl);
            listRewriter.insertAt((ASTNode)newStub, insertIndex, null);
            this.isGetter = false;
            newStub = this.getStub(rewrite, newTypeDecl);
            listRewriter.insertAt((ASTNode)newStub, insertIndex + 1, null);
            return rewrite;
        }
        return null;
    }

    protected MethodDeclaration getStub(ASTRewrite rewrite, ASTNode targetTypeDecl) throws CoreException {
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(targetTypeDecl, this.getImportRewrite());
        AST ast = targetTypeDecl.getAST();
        MethodDeclaration decl = ast.newMethodDeclaration();
        SimpleName newNameNode = this.getNewName(rewrite);
        decl.setName(newNameNode);
        this.addNewModifiers(rewrite, targetTypeDecl, decl.modifiers());
        String bodyStatement = "";
        boolean isAbstractMethod = Modifier.isAbstract((int)decl.getModifiers()) || this.fSenderBinding.isInterface() && !Modifier.isStatic((int)decl.getModifiers()) && !Modifier.isDefault((int)decl.getModifiers());
        Type returnType = this.getNewMethodType(rewrite, context);
        decl.setReturnType2(returnType);
        this.addNewParameters(rewrite, decl.parameters(), context);
        String lineDelim = "\n";
        String name = this.getFunctionName();
        if (!isAbstractMethod) {
            if (this.isGetter) {
                bodyStatement = CodeGeneration.getGetterMethodBodyContent(this.fField.getCompilationUnit(), this.fField.getDeclaringType().getTypeQualifiedName('.'), name, this.fField.getElementName(), lineDelim);
            } else {
                String fieldName = this.fField.getElementName();
                boolean isStatic = Flags.isStatic((int)decl.getModifiers());
                String argname = this.getArgumentName();
                if (argname.equals(fieldName) || !isStatic) {
                    fieldName = isStatic ? String.valueOf(this.fField.getDeclaringType().getElementName()) + '.' + fieldName : "this." + fieldName;
                }
                bodyStatement = CodeGeneration.getSetterMethodBodyContent(this.fField.getCompilationUnit(), this.fField.getDeclaringType().getTypeQualifiedName('.'), name, fieldName, argname, lineDelim);
            }
        }
        bodyStatement = bodyStatement.substring(0, bodyStatement.lastIndexOf(lineDelim));
        Block body = null;
        if (!isAbstractMethod && !Flags.isAbstract((int)decl.getModifiers())) {
            body = ast.newBlock();
            if (bodyStatement.length() > 0) {
                ASTNode bodyNode = rewrite.createStringPlaceholder(bodyStatement, 41);
                body.statements().add(bodyNode);
            }
        }
        decl.setBody(body);
        this.addNewJavadoc(rewrite, decl, context);
        return decl;
    }

    private void addNewJavadoc(ASTRewrite rewrite, MethodDeclaration decl, ImportRewrite.ImportRewriteContext context) throws CoreException {
        IType parentType = this.fField.getDeclaringType();
        String typeName = Signature.toString((String)this.fField.getTypeSignature());
        String accessorName = StubUtility.getBaseName(this.fField);
        String lineDelim = "\n";
        String comment = null;
        String name = this.getFunctionName();
        if (this.isGetter) {
            comment = CodeGeneration.getGetterComment(this.fField.getCompilationUnit(), parentType.getTypeQualifiedName('.'), name, this.fField.getElementName(), typeName, accessorName, lineDelim);
        } else {
            String argname = this.getArgumentName();
            comment = CodeGeneration.getSetterComment(this.fField.getCompilationUnit(), parentType.getTypeQualifiedName('.'), name, this.fField.getElementName(), typeName, argname, accessorName, lineDelim);
        }
        comment = comment.substring(0, comment.lastIndexOf(lineDelim));
        if (comment != null) {
            Javadoc javadoc = (Javadoc)rewrite.createStringPlaceholder(comment, 29);
            decl.setJavadoc(javadoc);
        }
    }

    private int getFlags() {
        int flags = 1;
        try {
            flags = 1 | this.fField.getFlags() & 8;
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Get flags for getter/setter ", e);
        }
        return flags;
    }

    private void addNewModifiers(ASTRewrite rewrite, ASTNode targetTypeDecl, List<IExtendedModifier> modifiers) {
        modifiers.addAll(rewrite.getAST().newModifiers(this.getFlags()));
    }

    private void addNewParameters(ASTRewrite rewrite, List<SingleVariableDeclaration> params, ImportRewrite.ImportRewriteContext context) throws CoreException {
        if (!this.isGetter) {
            AST ast = rewrite.getAST();
            SingleVariableDeclaration param = ast.newSingleVariableDeclaration();
            Type type = this.getImportRewrite().addImport(this.fVariableBinding.getType(), ast, context, ImportRewrite.TypeLocation.PARAMETER);
            param.setType(type);
            param.setName(ast.newSimpleName(this.getArgumentName()));
            params.add(param);
        }
    }

    private String getFunctionName() throws CoreException {
        return this.isGetter ? GetterSetterUtil.getGetterName(this.fField, null) : GetterSetterUtil.getSetterName(this.fField, null);
    }

    private String getArgumentName() throws CoreException {
        String accessorName = StubUtility.getBaseName(this.fField);
        return StubUtility.suggestArgumentName(this.fField.getJavaProject(), accessorName, EMPTY);
    }

    private SimpleName getNewName(ASTRewrite rewrite) {
        try {
            AST ast = rewrite.getAST();
            SimpleName newNameNode = ast.newSimpleName(this.getFunctionName());
            return newNameNode;
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Get newname for getter/setter ", e);
            return null;
        }
    }

    private Type getNewMethodType(ASTRewrite rewrite, ImportRewrite.ImportRewriteContext context) throws CoreException {
        AST ast = rewrite.getAST();
        Object newTypeNode = null;
        newTypeNode = this.isGetter ? this.getImportRewrite().addImport(this.fVariableBinding.getType(), ast, context, ImportRewrite.TypeLocation.RETURN_TYPE) : ast.newPrimitiveType(PrimitiveType.VOID);
        return newTypeNode;
    }
}

