/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.jdt.ls.core.internal.handlers.MapFlattener;
import org.eclipse.jdt.ls.core.internal.preferences.MemberSortOrder;
import org.eclipse.lsp4j.MessageType;

public class Preferences {
    public static final String JAVA_HOME = "java.home";
    public static final String IMPORT_GRADLE_ENABLED = "java.import.gradle.enabled";
    public static final String IMPORT_MAVEN_ENABLED = "java.import.maven.enabled";
    public static final String REFERENCES_CODE_LENS_ENABLED_KEY = "java.referencesCodeLens.enabled";
    public static final String IMPLEMENTATIONS_CODE_LENS_ENABLED_KEY = "java.implementationsCodeLens.enabled";
    public static final String JAVA_FORMAT_ENABLED_KEY = "java.format.enabled";
    public static final String JAVA_SAVE_ACTIONS_ORGANIZE_IMPORTS_KEY = "java.saveActions.organizeImports";
    public static final String SIGNATURE_HELP_ENABLED_KEY = "java.signatureHelp.enabled";
    public static final String RENAME_ENABLED_KEY = "java.rename.enabled";
    public static final String EXECUTE_COMMAND_ENABLED_KEY = "java.executeCommand.enabled";
    public static final String AUTOBUILD_ENABLED_KEY = "java.autobuild.enabled";
    public static final String JAVA_IMPORT_EXCLUSIONS_KEY = "java.import.exclusions";
    public static final List<String> JAVA_IMPORT_EXCLUSIONS_DEFAULT;
    public static final String CONFIGURATION_UPDATE_BUILD_CONFIGURATION_KEY = "java.configuration.updateBuildConfiguration";
    public static final String ERRORS_INCOMPLETE_CLASSPATH_SEVERITY_KEY = "java.errors.incompleteClasspath.severity";
    public static final String MAVEN_USER_SETTINGS_KEY = "java.configuration.maven.userSettings";
    public static final String JAVA_COMPLETION_FAVORITE_MEMBERS_KEY = "java.completion.favoriteStaticMembers";
    public static final List<String> JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT;
    public static final String MEMBER_SORT_ORDER = "java.memberSortOrder";
    public static final String PREFERRED_CONTENT_PROVIDER_KEY = "java.contentProvider.preferred";
    public static final String JAVA_IMPORT_ORDER_KEY = "java.completion.importOrder";
    public static final List<String> JAVA_IMPORT_ORDER_DEFAULT;
    public static final String TEXT_DOCUMENT_FORMATTING = "textDocument/formatting";
    public static final String TEXT_DOCUMENT_RANGE_FORMATTING = "textDocument/rangeFormatting";
    public static final String TEXT_DOCUMENT_CODE_LENS = "textDocument/codeLens";
    public static final String TEXT_DOCUMENT_SIGNATURE_HELP = "textDocument/signatureHelp";
    public static final String TEXT_DOCUMENT_RENAME = "textDocument/rename";
    public static final String WORKSPACE_EXECUTE_COMMAND = "workspace/executeCommand";
    public static final String WORKSPACE_SYMBOL = "workspace/symbol";
    public static final String DOCUMENT_SYMBOL = "textDocument/documentSymbol";
    public static final String CODE_ACTION = "textDocument/codeAction";
    public static final String DEFINITION = "textDocument/definition";
    public static final String HOVER = "textDocument/hover";
    public static final String REFERENCES = "textDocument/references";
    public static final String DOCUMENT_HIGHLIGHT = "textDocument/documentHighlight";
    public static final String FORMATTING_ID;
    public static final String FORMATTING_RANGE_ID;
    public static final String CODE_LENS_ID;
    public static final String SIGNATURE_HELP_ID;
    public static final String RENAME_ID;
    public static final String EXECUTE_COMMAND_ID;
    public static final String WORKSPACE_SYMBOL_ID;
    public static final String DOCUMENT_SYMBOL_ID;
    public static final String CODE_ACTION_ID;
    public static final String DEFINITION_ID;
    public static final String HOVER_ID;
    public static final String REFERENCES_ID;
    public static final String DOCUMENT_HIGHLIGHT_ID;
    private Map<String, Object> configuration = null;
    private Severity incompleteClasspathSeverity;
    private FeatureStatus updateBuildConfigurationStatus;
    private boolean referencesCodeLensEnabled = true;
    private boolean importGradleEnabled = true;
    private boolean importMavenEnabled = true;
    private boolean implementationsCodeLensEnabled = false;
    private boolean javaFormatEnabled = true;
    private boolean javaSaveActionsOrganizeImportsEnabled = false;
    private boolean signatureHelpEnabled = false;
    private boolean renameEnabled = true;
    private boolean executeCommandEnabled = true;
    private boolean autobuildEnabled = true;
    private MemberSortOrder memberOrders;
    private List<String> preferredContentProviderIds = null;
    private String mavenUserSettings;
    private List<String> javaCompletionFavoriteMembers;
    private List<String> javaImportExclusions = new ArrayList<String>();
    private String javaHome = null;
    private List<String> importOrder;

    static {
        FORMATTING_ID = UUID.randomUUID().toString();
        FORMATTING_RANGE_ID = UUID.randomUUID().toString();
        CODE_LENS_ID = UUID.randomUUID().toString();
        SIGNATURE_HELP_ID = UUID.randomUUID().toString();
        RENAME_ID = UUID.randomUUID().toString();
        EXECUTE_COMMAND_ID = UUID.randomUUID().toString();
        WORKSPACE_SYMBOL_ID = UUID.randomUUID().toString();
        DOCUMENT_SYMBOL_ID = UUID.randomUUID().toString();
        CODE_ACTION_ID = UUID.randomUUID().toString();
        DEFINITION_ID = UUID.randomUUID().toString();
        HOVER_ID = UUID.randomUUID().toString();
        REFERENCES_ID = UUID.randomUUID().toString();
        DOCUMENT_HIGHLIGHT_ID = UUID.randomUUID().toString();
        JAVA_IMPORT_EXCLUSIONS_DEFAULT = new ArrayList<String>();
        JAVA_IMPORT_EXCLUSIONS_DEFAULT.add("**/node_modules/**");
        JAVA_IMPORT_EXCLUSIONS_DEFAULT.add("**/.metadata/**");
        JAVA_IMPORT_EXCLUSIONS_DEFAULT.add("**/archetype-resources/**");
        JAVA_IMPORT_EXCLUSIONS_DEFAULT.add("**/META-INF/maven/**");
        JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT = new ArrayList<String>();
        JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT.add("org.junit.Assert.*:");
        JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT.add("org.junit.Assume.*:");
        JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT.add("org.junit.jupiter.api.Assertions.*:");
        JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT.add("org.junit.jupiter.api.Assumptions.*:");
        JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT.add("org.junit.jupiter.api.DynamicContainer.*:");
        JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT.add("org.junit.jupiter.api.DynamicTest.*");
        JAVA_IMPORT_ORDER_DEFAULT = new ArrayList<String>();
        JAVA_IMPORT_ORDER_DEFAULT.add("java");
        JAVA_IMPORT_ORDER_DEFAULT.add("javax");
        JAVA_IMPORT_ORDER_DEFAULT.add("com");
        JAVA_IMPORT_ORDER_DEFAULT.add("org");
    }

    public Preferences() {
        this.incompleteClasspathSeverity = Severity.warning;
        this.updateBuildConfigurationStatus = FeatureStatus.interactive;
        this.memberOrders = new MemberSortOrder(null);
        this.javaImportExclusions = JAVA_IMPORT_EXCLUSIONS_DEFAULT;
        this.javaCompletionFavoriteMembers = JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT;
        this.importOrder = JAVA_IMPORT_ORDER_DEFAULT;
    }

    public static Preferences createFrom(Map<String, Object> configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration can not be null");
        }
        Preferences prefs = new Preferences();
        prefs.configuration = configuration;
        String incompleteClasspathSeverity = MapFlattener.getString(configuration, ERRORS_INCOMPLETE_CLASSPATH_SEVERITY_KEY, null);
        prefs.setIncompleteClasspathSeverity(Severity.fromString(incompleteClasspathSeverity, Severity.warning));
        String updateBuildConfiguration = MapFlattener.getString(configuration, CONFIGURATION_UPDATE_BUILD_CONFIGURATION_KEY, null);
        prefs.setUpdateBuildConfigurationStatus(FeatureStatus.fromString(updateBuildConfiguration, FeatureStatus.interactive));
        boolean importGradleEnabled = MapFlattener.getBoolean(configuration, IMPORT_GRADLE_ENABLED, true);
        prefs.setImportGradleEnabled(importGradleEnabled);
        boolean importMavenEnabled = MapFlattener.getBoolean(configuration, IMPORT_MAVEN_ENABLED, true);
        prefs.setImportMavenEnabled(importMavenEnabled);
        boolean referenceCodelensEnabled = MapFlattener.getBoolean(configuration, REFERENCES_CODE_LENS_ENABLED_KEY, true);
        prefs.setReferencesCodelensEnabled(referenceCodelensEnabled);
        boolean implementationCodeLensEnabled = MapFlattener.getBoolean(configuration, IMPLEMENTATIONS_CODE_LENS_ENABLED_KEY, false);
        prefs.setImplementationCodelensEnabled(implementationCodeLensEnabled);
        boolean javaFormatEnabled = MapFlattener.getBoolean(configuration, JAVA_FORMAT_ENABLED_KEY, true);
        prefs.setJavaFormatEnabled(javaFormatEnabled);
        boolean javaSaveActionAutoOrganizeImportsEnabled = MapFlattener.getBoolean(configuration, JAVA_SAVE_ACTIONS_ORGANIZE_IMPORTS_KEY, false);
        prefs.setJavaSaveActionAutoOrganizeImportsEnabled(javaSaveActionAutoOrganizeImportsEnabled);
        boolean signatureHelpEnabled = MapFlattener.getBoolean(configuration, SIGNATURE_HELP_ENABLED_KEY, true);
        prefs.setSignatureHelpEnabled(signatureHelpEnabled);
        boolean renameEnabled = MapFlattener.getBoolean(configuration, RENAME_ENABLED_KEY, true);
        prefs.setRenameEnabled(renameEnabled);
        boolean executeCommandEnable = MapFlattener.getBoolean(configuration, EXECUTE_COMMAND_ENABLED_KEY, true);
        prefs.setExecuteCommandEnabled(executeCommandEnable);
        boolean autobuildEnable = MapFlattener.getBoolean(configuration, AUTOBUILD_ENABLED_KEY, true);
        prefs.setAutobuildEnabled(autobuildEnable);
        List<String> javaImportExclusions = MapFlattener.getList(configuration, JAVA_IMPORT_EXCLUSIONS_KEY, JAVA_IMPORT_EXCLUSIONS_DEFAULT);
        prefs.setJavaImportExclusions(javaImportExclusions);
        List<String> javaCompletionFavoriteMembers = MapFlattener.getList(configuration, JAVA_COMPLETION_FAVORITE_MEMBERS_KEY, JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT);
        prefs.setJavaCompletionFavoriteMembers(javaCompletionFavoriteMembers);
        String mavenUserSettings = MapFlattener.getString(configuration, MAVEN_USER_SETTINGS_KEY, null);
        prefs.setMavenUserSettings(mavenUserSettings);
        String sortOrder = MapFlattener.getString(configuration, MEMBER_SORT_ORDER, null);
        prefs.setMembersSortOrder(sortOrder);
        List<String> preferredContentProviders = MapFlattener.getList(configuration, PREFERRED_CONTENT_PROVIDER_KEY);
        prefs.setPreferredContentProviderIds(preferredContentProviders);
        String javaHome = MapFlattener.getString(configuration, JAVA_HOME);
        prefs.setJavaHome(javaHome);
        List<String> javaImportOrder = MapFlattener.getList(configuration, JAVA_IMPORT_ORDER_KEY, JAVA_IMPORT_ORDER_DEFAULT);
        prefs.setImportOrder(javaImportOrder);
        return prefs;
    }

    public Preferences setJavaHome(String javaHome) {
        this.javaHome = javaHome;
        return this;
    }

    public Preferences setJavaImportExclusions(List<String> javaImportExclusions) {
        this.javaImportExclusions = javaImportExclusions;
        return this;
    }

    public Preferences setJavaCompletionFavoriteMembers(List<String> javaCompletionFavoriteMembers) {
        this.javaCompletionFavoriteMembers = javaCompletionFavoriteMembers == null || javaCompletionFavoriteMembers.isEmpty() ? JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT : javaCompletionFavoriteMembers;
        return this;
    }

    private Preferences setMembersSortOrder(String sortOrder) {
        this.memberOrders = new MemberSortOrder(sortOrder);
        return this;
    }

    private Preferences setPreferredContentProviderIds(List<String> preferredContentProviderIds) {
        this.preferredContentProviderIds = preferredContentProviderIds;
        return this;
    }

    private Preferences setReferencesCodelensEnabled(boolean enabled) {
        this.referencesCodeLensEnabled = enabled;
        return this;
    }

    public Preferences setImportGradleEnabled(boolean enabled) {
        this.importGradleEnabled = enabled;
        return this;
    }

    public Preferences setImportMavenEnabled(boolean enabled) {
        this.importMavenEnabled = enabled;
        return this;
    }

    private Preferences setSignatureHelpEnabled(boolean enabled) {
        this.signatureHelpEnabled = enabled;
        return this;
    }

    private Preferences setImplementationCodelensEnabled(boolean enabled) {
        this.implementationsCodeLensEnabled = enabled;
        return this;
    }

    private Preferences setRenameEnabled(boolean enabled) {
        this.renameEnabled = enabled;
        return this;
    }

    private Preferences setExecuteCommandEnabled(boolean enabled) {
        this.executeCommandEnabled = enabled;
        return this;
    }

    public Preferences setAutobuildEnabled(boolean enabled) {
        this.autobuildEnabled = enabled;
        return this;
    }

    public Preferences setJavaFormatEnabled(boolean enabled) {
        this.javaFormatEnabled = enabled;
        return this;
    }

    public Preferences setJavaSaveActionAutoOrganizeImportsEnabled(boolean javaSaveActionAutoOrganizeImportsEnabled) {
        this.javaSaveActionsOrganizeImportsEnabled = javaSaveActionAutoOrganizeImportsEnabled;
        return this;
    }

    public Preferences setUpdateBuildConfigurationStatus(FeatureStatus status) {
        this.updateBuildConfigurationStatus = status;
        return this;
    }

    private Preferences setIncompleteClasspathSeverity(Severity severity) {
        this.incompleteClasspathSeverity = severity;
        return this;
    }

    public Preferences setImportOrder(List<String> importOrder) {
        this.importOrder = importOrder == null || importOrder.size() == 0 ? JAVA_IMPORT_ORDER_DEFAULT : importOrder;
        return this;
    }

    public Severity getIncompleteClasspathSeverity() {
        return this.incompleteClasspathSeverity;
    }

    public FeatureStatus getUpdateBuildConfigurationStatus() {
        return this.updateBuildConfigurationStatus;
    }

    public List<String> getJavaImportExclusions() {
        return this.javaImportExclusions;
    }

    public String[] getJavaCompletionFavoriteMembers() {
        return this.javaCompletionFavoriteMembers.toArray(new String[0]);
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public MemberSortOrder getMemberSortOrder() {
        return this.memberOrders;
    }

    public List<String> getPreferredContentProviderIds() {
        return this.preferredContentProviderIds;
    }

    public boolean isReferencesCodeLensEnabled() {
        return this.referencesCodeLensEnabled;
    }

    public boolean isImportGradleEnabled() {
        return this.importGradleEnabled;
    }

    public boolean isImportMavenEnabled() {
        return this.importMavenEnabled;
    }

    public boolean isImplementationsCodeLensEnabled() {
        return this.implementationsCodeLensEnabled;
    }

    public boolean isCodeLensEnabled() {
        return this.referencesCodeLensEnabled || this.implementationsCodeLensEnabled;
    }

    public boolean isJavaFormatEnabled() {
        return this.javaFormatEnabled;
    }

    public boolean isJavaSaveActionsOrganizeImportsEnabled() {
        return this.javaSaveActionsOrganizeImportsEnabled;
    }

    public boolean isSignatureHelpEnabled() {
        return this.signatureHelpEnabled;
    }

    public boolean isRenameEnabled() {
        return this.renameEnabled;
    }

    public boolean isExecuteCommandEnabled() {
        return this.executeCommandEnabled;
    }

    public boolean isAutobuildEnabled() {
        return this.autobuildEnabled;
    }

    public Preferences setMavenUserSettings(String mavenUserSettings) {
        this.mavenUserSettings = mavenUserSettings;
        return this;
    }

    public String getMavenUserSettings() {
        return this.mavenUserSettings;
    }

    public String[] getImportOrder() {
        return this.importOrder == null ? new String[]{} : this.importOrder.toArray(new String[this.importOrder.size()]);
    }

    public Map<String, Object> asMap() {
        if (this.configuration == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.configuration);
    }

    public static enum FeatureStatus {
        disabled,
        interactive,
        automatic;


        static FeatureStatus fromString(String value, FeatureStatus defaultStatus) {
            if (value != null) {
                String val = value.toLowerCase();
                try {
                    return FeatureStatus.valueOf(val);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return defaultStatus;
        }
    }

    public static enum Severity {
        ignore,
        log,
        info,
        warning,
        error;


        static Severity fromString(String value, Severity defaultSeverity) {
            if (value != null) {
                String val = value.toLowerCase();
                try {
                    return Severity.valueOf(val);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return defaultSeverity;
        }

        public MessageType toMessageType() {
            MessageType[] messageTypeArray = MessageType.values();
            int n = messageTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MessageType type = messageTypeArray[n2];
                if (this.name().equalsIgnoreCase(type.name())) {
                    return type;
                }
                ++n2;
            }
            return null;
        }
    }
}

