/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.launching.AbstractVMInstallType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.TestVMInstall;
import org.osgi.framework.Bundle;

public class TestVMType
extends AbstractVMInstallType {
    public static final String VMTYPE_ID = "org.eclipse.jdt.ls.core.internal.TestVMType";
    private static final String FAKE_JDK = "/fakejdk";
    private static final String RTSTUBS_JAR = "rtstubs.jar";

    public static void setTestJREAsDefault() throws CoreException {
        IVMInstallType vmInstallType = JavaRuntime.getVMInstallType((String)VMTYPE_ID);
        IVMInstall testVMInstall = vmInstallType.findVMInstall("1.8");
        if (!testVMInstall.equals(JavaRuntime.getDefaultVMInstall())) {
            JavaRuntime.setDefaultVMInstall((IVMInstall)testVMInstall, (IProgressMonitor)new NullProgressMonitor());
        }
        JDTUtils.setCompatibleVMs((String)VMTYPE_ID);
    }

    public TestVMType() {
        this.createVMInstall("1.8");
        this.createVMInstall("9");
    }

    public String getName() {
        return "TestVMInstall-" + this.getId();
    }

    public IStatus validateInstallLocation(File installLocation) {
        return Status.OK_STATUS;
    }

    public File detectInstallLocation() {
        return null;
    }

    public static File getFakeJDKsLocation() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.jdt.ls.tests");
        try {
            URL url = FileLocator.toFileURL((URL)bundle.getEntry(FAKE_JDK));
            File file = URIUtil.toFile((URI)URIUtil.toURI((URL)url));
            return file;
        }
        catch (IOException | URISyntaxException e) {
            JavaLanguageServerPlugin.logException((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public LibraryLocation[] getDefaultLibraryLocations(File installLocation) {
        IPath path = Path.fromOSString((String)new File(installLocation, RTSTUBS_JAR).getAbsolutePath());
        return new LibraryLocation[]{new LibraryLocation(path, (IPath)Path.EMPTY, (IPath)Path.EMPTY)};
    }

    protected IVMInstall doCreateVMInstall(String id) {
        return new TestVMInstall((IVMInstallType)this, id);
    }
}

