/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.WorkspaceHelper;
import org.eclipse.jdt.ls.core.internal.managers.AbstractProjectsManagerBasedTest;
import org.junit.Assert;

public abstract class AbstractMavenBasedTest
extends AbstractProjectsManagerBasedTest {
    protected IProject importMavenProject(String name) throws Exception {
        this.importProjects("maven/" + name);
        IProject project = WorkspaceHelper.getProject(name);
        this.assertIsMavenProject(project);
        return project;
    }

    protected IProject importExistingMavenProject(String name) throws Exception {
        this.importExistingProjects("maven/" + name);
        IProject project = WorkspaceHelper.getProject(name);
        this.assertIsMavenProject(project);
        return project;
    }

    protected IProject importSimpleJavaProject() throws Exception {
        String name = "salut";
        IProject project = this.importMavenProject(name);
        this.assertIsJavaProject(project);
        Assert.assertEquals((Object)"1.7", (Object)ProjectUtils.getJavaSourceLevel((IProject)project));
        this.assertNoErrors(project);
        return project;
    }

    protected void assertIsMavenProject(IProject project) {
        Assert.assertNotNull((Object)project);
        Assert.assertTrue((String)(String.valueOf(project.getName()) + " is missing the Maven nature"), (boolean)ProjectUtils.isMavenProject((IProject)project));
    }

    protected String comment(String s, String from, String to) {
        String result = s.replace(from, "<!--" + from).replace(to, String.valueOf(to) + "-->");
        return result;
    }
}

