/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.pdt.modeler.utils.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.Cardinality;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.EclipseElement;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.Extension;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.ExtensionPoint;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.Feature;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.FeatureDependencies;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.FeatureDependency;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.FeatureInclusion;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.FeatureInclusions;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.FeaturePluginDependencies;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.FeatureToPluginDependency;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.IdentifiedVersionnedElement;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.IncludedPlugins;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.InclusionKind;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.PlatformPackage;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.Plugin;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.PluginDependencies;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.PluginDependency;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.PluginExtensionPoints;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.PluginExtensions;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.VersionnedElement;
import org.polarsys.kitalpha.pdt.modeler.utils.services.EclipseElementNameSwitch;

public class IntrospectionServices {
    private static final String SHORT_VERSION_LABEL_END = "[...]";
    private static final int MAX_VERSION_LABEL_LENGTH = 15;

    public List<Plugin> getAllPlugins(EObject any) {
        ArrayList<Plugin> result = new ArrayList<Plugin>();
        EObject modelRootElement = EcoreUtil.getRootContainer((EObject)any);
        TreeIterator allElements = modelRootElement.eAllContents();
        while (allElements.hasNext()) {
            EObject eObject = (EObject)allElements.next();
            if (!(eObject instanceof Plugin)) continue;
            result.add((Plugin)eObject);
        }
        Collections.sort(result, new Comparator<Plugin>(){

            @Override
            public int compare(Plugin arg0, Plugin arg1) {
                String id0 = arg0.getId();
                String id1 = arg1.getId();
                return id0.compareTo(id1);
            }
        });
        return result;
    }

    public List<Feature> getAllFeatures(EObject any) {
        ArrayList<Feature> result = new ArrayList<Feature>();
        EObject modelRootElement = EcoreUtil.getRootContainer((EObject)any);
        TreeIterator allElements = modelRootElement.eAllContents();
        while (allElements.hasNext()) {
            EObject eObject = (EObject)allElements.next();
            if (!(eObject instanceof Feature)) continue;
            result.add((Feature)eObject);
        }
        Collections.sort(result, new Comparator<Feature>(){

            @Override
            public int compare(Feature arg0, Feature arg1) {
                String id0 = arg0.getId();
                String id1 = arg1.getId();
                return id0.compareTo(id1);
            }
        });
        return result;
    }

    public List<IdentifiedVersionnedElement> getLinkedElement(IdentifiedVersionnedElement element, DSemanticDiagram diagram) {
        List<IdentifiedVersionnedElement> outgoingLinks;
        ArrayList<IdentifiedVersionnedElement> result = new ArrayList<IdentifiedVersionnedElement>();
        List<IdentifiedVersionnedElement> incomingLinks = IntrospectionServices.getDependenciesOrInclusionsForGivenElement((EclipseElement)element);
        if (incomingLinks != null && !incomingLinks.isEmpty()) {
            result.addAll(incomingLinks);
        }
        if ((outgoingLinks = this.getOutgoingDependenciesOrInclusionsForGivenElement(element)) != null && !outgoingLinks.isEmpty()) {
            result.addAll(outgoingLinks);
        }
        List<IdentifiedVersionnedElement> elementOnTheDiagram = this.getElementOnTheDiagram(diagram);
        result.removeAll(elementOnTheDiagram);
        return result;
    }

    private List<IdentifiedVersionnedElement> getElementOnTheDiagram(DSemanticDiagram diagram) {
        ArrayList<IdentifiedVersionnedElement> result = new ArrayList<IdentifiedVersionnedElement>();
        EList ownedRepresentationElements = diagram.getOwnedRepresentationElements();
        for (DRepresentationElement dRepresentationElement : ownedRepresentationElements) {
            EObject target = dRepresentationElement.getTarget();
            if (target == null || !(target instanceof IdentifiedVersionnedElement)) continue;
            result.add((IdentifiedVersionnedElement)target);
        }
        return result;
    }

    public List<IdentifiedVersionnedElement> getOutgoingDependenciesOrInclusionsForGivenElement(IdentifiedVersionnedElement element) {
        EList pluginDependencies2;
        Plugin plugin;
        PluginDependencies pluginDependencies;
        ArrayList<IdentifiedVersionnedElement> result = new ArrayList<IdentifiedVersionnedElement>();
        if (element instanceof Plugin && (pluginDependencies = (plugin = (Plugin)element).getPluginDependencies()) != null && (pluginDependencies2 = pluginDependencies.getPluginDependencies()) != null && !pluginDependencies2.isEmpty()) {
            for (PluginDependency pluginDependency : pluginDependencies2) {
                result.add((IdentifiedVersionnedElement)pluginDependency.getTarget());
            }
        }
        if (element instanceof Feature) {
            Plugin target;
            Feature feature = (Feature)element;
            IncludedPlugins includedPlugins = feature.getIncludedPlugins();
            FeaturePluginDependencies pluginDependencies3 = feature.getPluginDependencies();
            FeatureInclusions featureInclusions = feature.getFeatureInclusions();
            FeatureDependencies featureDependencies = feature.getFeatureDependencies();
            EList includedPlugins2 = includedPlugins.getIncludedPlugins();
            EList pluginDependencies22 = pluginDependencies3.getPluginDependencies();
            EList featureInclusions2 = featureInclusions.getFeatureInclusions();
            EList featureDependencies2 = featureDependencies.getFeatureDependencies();
            if (includedPlugins2 != null && !includedPlugins2.isEmpty()) {
                result.addAll((Collection<IdentifiedVersionnedElement>)includedPlugins2);
            }
            if (pluginDependencies22 != null && !pluginDependencies22.isEmpty()) {
                for (FeatureToPluginDependency featureToPluginDependency : pluginDependencies22) {
                    target = featureToPluginDependency.getTarget();
                    if (target == null) continue;
                    result.add((IdentifiedVersionnedElement)target);
                }
            }
            if (featureDependencies2 != null && !featureDependencies2.isEmpty()) {
                for (FeatureDependency featureDependency : featureDependencies2) {
                    target = featureDependency.getTarget();
                    if (target == null) continue;
                    result.add((IdentifiedVersionnedElement)target);
                }
            }
            if (featureInclusions2 != null && !featureInclusions2.isEmpty()) {
                for (FeatureInclusion featureInclusion : featureInclusions2) {
                    Feature includedFeature = featureInclusion.getIncludedFeature();
                    if (includedFeature == null) continue;
                    result.add((IdentifiedVersionnedElement)includedFeature);
                }
            }
        }
        return result;
    }

    public static void printEObject(EObject obj) {
        System.out.println(obj);
    }

    public static String printName(EclipseElement current) {
        System.out.println(current.toString());
        return current.toString();
    }

    public static Plugin getContributedPluginForGivenPlugin(EObject obj) {
        if (obj instanceof Plugin) {
            Plugin plugin = (Plugin)obj;
            return IntrospectionServices.getContributedPluginForGivenPlugin(plugin);
        }
        return null;
    }

    public static Plugin getContributedPluginForGivenPlugin(Plugin plugin) {
        Plugin contributedPlugin = null;
        EObject pluginContainer = null;
        PluginExtensions extensionFolder = null;
        EList extensions = null;
        ArrayList<EObject> containers = new ArrayList<EObject>();
        if (plugin.getExtensions() != null) {
            extensionFolder = plugin.getExtensions();
        }
        if (extensionFolder != null) {
            extensions = extensionFolder.getExtensions();
        }
        if (extensions != null) {
            for (Extension extension : extensions) {
                pluginContainer = extension.getExtensionPoint().eContainer().eContainer();
                containers.add(pluginContainer);
            }
        }
        if (containers != null) {
            for (EObject container : containers) {
                if (!(container instanceof Plugin)) continue;
                contributedPlugin = (Plugin)container;
            }
        }
        return contributedPlugin;
    }

    public static Plugin getContributedPluginForGivenExtension(Extension extension) {
        Plugin contributedPlugin = null;
        EObject pluginContributed = extension.getExtensionPoint().eContainer().eContainer();
        if (pluginContributed instanceof Plugin) {
            contributedPlugin = (Plugin)pluginContributed;
        }
        return contributedPlugin;
    }

    public static List<Plugin> getContributorsOfGivenPlugin(EObject obj) {
        if (obj instanceof Plugin) {
            Plugin plugin = (Plugin)obj;
            return IntrospectionServices.getContributorsOfGivenPlugin(plugin);
        }
        return null;
    }

    public static List<Plugin> getContributorsOfGivenPlugin(Plugin plugin) {
        ArrayList<Plugin> contributors = new ArrayList<Plugin>();
        PluginExtensionPoints extensionPointsFolder = null;
        EList extensionPoints = null;
        EList extensionContributors = null;
        EObject pluginContainer = null;
        Plugin contributorPlugin = null;
        if (plugin.getExtensionPoints() != null) {
            extensionPointsFolder = plugin.getExtensionPoints();
        }
        if (extensionPointsFolder != null) {
            extensionPoints = extensionPointsFolder.getExtensionPoints();
        }
        if (extensionPoints != null) {
            for (ExtensionPoint extensionPoint : extensionPoints) {
                extensionContributors = extensionPoint.getContributors();
                for (Extension extension : extensionContributors) {
                    pluginContainer = extension.eContainer().eContainer();
                    if (!(pluginContainer instanceof Plugin)) continue;
                    contributorPlugin = (Plugin)pluginContainer;
                    contributors.add(contributorPlugin);
                }
            }
        }
        return contributors;
    }

    public static List<Plugin> getContributorsForGivenEP(EObject obj) {
        if (obj instanceof ExtensionPoint) {
            ExtensionPoint ep = (ExtensionPoint)obj;
            return IntrospectionServices.getContributorsForGivenEP(ep);
        }
        return null;
    }

    public static List<Plugin> getContributorsForGivenEP(ExtensionPoint ep) {
        Plugin contributor = null;
        EObject pluginContributor = null;
        ArrayList<Plugin> contributors = new ArrayList<Plugin>();
        EList extensionContributors = ep.getContributors();
        for (Extension extension : extensionContributors) {
            pluginContributor = extension.eContainer().eContainer();
            if (!(pluginContributor instanceof Plugin)) continue;
            contributor = (Plugin)pluginContributor;
            contributors.add(contributor);
        }
        return contributors;
    }

    public static List<IdentifiedVersionnedElement> getDependenciesOrInclusionsForGivenElement(EObject element) {
        if (element instanceof EclipseElement) {
            EclipseElement ee = (EclipseElement)element;
            return IntrospectionServices.getDependenciesOrInclusionsForGivenElement(ee);
        }
        return null;
    }

    public static List<IdentifiedVersionnedElement> getContainingFeatures(Plugin plugin) {
        ArrayList<IdentifiedVersionnedElement> incomingFeatures = new ArrayList<IdentifiedVersionnedElement>();
        Collection crossReferences = EcoreUtil.UsageCrossReferencer.find((EObject)plugin, (Resource)plugin.eResource());
        Feature dependant = null;
        for (EStructuralFeature.Setting setting : crossReferences) {
            EReference feature_IncludedPlugins;
            EStructuralFeature settingStructuralFeature = setting.getEStructuralFeature();
            if (!settingStructuralFeature.equals(feature_IncludedPlugins = PlatformPackage.eINSTANCE.getIncludedPlugins_IncludedPlugins())) continue;
            EObject dependency = setting.getEObject();
            if (dependency instanceof IncludedPlugins) {
                dependant = (Feature)dependency.eContainer();
            }
            if (dependant == null) continue;
            incomingFeatures.add((IdentifiedVersionnedElement)dependant);
        }
        return incomingFeatures;
    }

    public static List<IdentifiedVersionnedElement> getDependenciesOrInclusionsForGivenElement(EclipseElement element) {
        ArrayList<IdentifiedVersionnedElement> incomingElements = new ArrayList<IdentifiedVersionnedElement>();
        Collection crossReferences = null;
        Feature dependant = null;
        if (element instanceof Plugin) {
            crossReferences = EcoreUtil.UsageCrossReferencer.find((EObject)element, (Resource)element.eResource());
            for (EStructuralFeature.Setting setting : crossReferences) {
                EStructuralFeature settingStructuralFeature;
                EReference pluginDependency_Target = PlatformPackage.eINSTANCE.getPluginDependency_Target();
                if (setting.getEStructuralFeature().equals(pluginDependency_Target)) {
                    EObject dependency = setting.getEObject();
                    if (dependency instanceof PluginDependency) {
                        dependant = (Plugin)dependency.eContainer().eContainer();
                    }
                    if (dependant != null) {
                        incomingElements.add((IdentifiedVersionnedElement)dependant);
                    }
                }
                if ((settingStructuralFeature = setting.getEStructuralFeature()).equals(PlatformPackage.eINSTANCE.getFeatureToPluginDependency_Target())) {
                    EObject dependency = setting.getEObject();
                    if (dependency instanceof FeatureToPluginDependency) {
                        dependant = (Feature)dependency.eContainer().eContainer();
                    }
                    if (dependant == null) continue;
                    incomingElements.add((IdentifiedVersionnedElement)dependant);
                    continue;
                }
                EReference feature_IncludedPlugins = PlatformPackage.eINSTANCE.getIncludedPlugins_IncludedPlugins();
                if (!settingStructuralFeature.equals(feature_IncludedPlugins)) continue;
                EObject dependency = setting.getEObject();
                if (dependency instanceof IncludedPlugins) {
                    dependant = (Feature)dependency.eContainer();
                }
                if (dependant == null) continue;
                incomingElements.add((IdentifiedVersionnedElement)dependant);
            }
        }
        if (element instanceof Feature) {
            crossReferences = EcoreUtil.UsageCrossReferencer.find((EObject)element, (Resource)element.eResource());
            for (EStructuralFeature.Setting setting : crossReferences) {
                FeatureInclusion inclusion;
                if (setting.getEStructuralFeature().equals(PlatformPackage.eINSTANCE.getFeatureDependency_Target())) {
                    FeatureDependency dependency = (FeatureDependency)setting.getEObject();
                    dependant = (Feature)dependency.eContainer().eContainer();
                    incomingElements.add((IdentifiedVersionnedElement)dependant);
                }
                if (!setting.getEStructuralFeature().equals(PlatformPackage.eINSTANCE.getFeatureInclusion_IncludedFeature()) || (dependant = (Feature)(inclusion = (FeatureInclusion)setting.getEObject()).eContainer().eContainer()) == null) continue;
                incomingElements.add((IdentifiedVersionnedElement)dependant);
            }
        }
        return incomingElements;
    }

    public static String getNameForEclipseElement(EObject obj) {
        if (obj instanceof EclipseElement) {
            EclipseElement elem = (EclipseElement)obj;
            return IntrospectionServices.getNameForEclipseElement(elem);
        }
        return null;
    }

    public static String getNameForEclipseElement(EclipseElement current) {
        String temp = (String)new EclipseElementNameSwitch().doSwitch((EObject)current);
        return temp;
    }

    public static String getVersionShortStringLabel(VersionnedElement current) {
        String versionLabel = "<<depends>>\n";
        if (current.getVersion() != null) {
            if (current.getVersion().length() > 15) {
                versionLabel = String.valueOf(versionLabel) + "v" + current.getVersion().substring(0, 15);
                if (current.getVersion().length() > 15) {
                    versionLabel = String.valueOf(versionLabel) + versionLabel.concat(SHORT_VERSION_LABEL_END);
                }
            } else {
                versionLabel = String.valueOf(versionLabel) + "v" + current.getVersion();
            }
        }
        return versionLabel;
    }

    public static String getLabelForGivenExtension(EObject obj) {
        if (obj instanceof Extension) {
            Extension ext = (Extension)obj;
            return IntrospectionServices.getLabelForGivenExtension(ext);
        }
        return null;
    }

    public static String getLabelForGivenExtension(Extension extension) {
        String result = "";
        EObject eContainer = extension.eContainer().eContainer();
        if (eContainer instanceof Plugin) {
            EList extensions = ((Plugin)eContainer).getExtensions().getExtensions();
            int i = 0;
            for (Extension currentExtension : extensions) {
                ++i;
                if (currentExtension != extension) continue;
                result = String.valueOf(extension.getId()) + "_" + ((Plugin)eContainer).getId() + "_" + i;
            }
        }
        return result;
    }

    public static String getVersionShortString(EObject obj) {
        if (obj instanceof VersionnedElement) {
            VersionnedElement ve = (VersionnedElement)obj;
            return IntrospectionServices.getVersionShortString(ve);
        }
        return null;
    }

    public static String getVersionShortString(VersionnedElement current) {
        String versionLabel = "";
        if (current.getVersion().length() > 15) {
            versionLabel = "v" + current.getVersion().substring(0, 15);
            if (current.getVersion().length() > 15) {
                versionLabel = "v" + versionLabel.concat(SHORT_VERSION_LABEL_END);
            }
        }
        return versionLabel;
    }

    public static String getVersionAndInclusionDependenciesString(EObject obj) {
        if (obj instanceof PluginDependency) {
            PluginDependency dep = (PluginDependency)obj;
            return IntrospectionServices.getVersionAndInclusionDependenciesString(dep);
        }
        return null;
    }

    public static String getVersionAndInclusionDependenciesString(PluginDependency current) {
        String label = "";
        InclusionKind minInclusion = current.getMinimumInclusion();
        InclusionKind maxInclusion = current.getMaximumInclusion();
        String minVersion = current.getMinimumVersion();
        String maxVersion = current.getMaximumVersion();
        label = minInclusion == InclusionKind.INCLUSIVE ? String.valueOf(label) + "[" : (minInclusion == InclusionKind.EXCLUSIVE ? String.valueOf(label) + "]" : String.valueOf(label) + "|");
        label = String.valueOf(label) + (minVersion != null ? minVersion : "?") + ";" + (maxVersion != null ? maxVersion : "?");
        label = maxInclusion == InclusionKind.INCLUSIVE ? String.valueOf(label) + "]" : (maxInclusion == InclusionKind.EXCLUSIVE ? String.valueOf(label) + "[" : String.valueOf(label) + "|");
        return label;
    }

    public static String getMaxCardofAComplexSchemaElement(Cardinality maxCard) {
        if (maxCard.isUnbounded()) {
            return "*";
        }
        int card = maxCard.getMaxCard();
        String cardinality = Integer.toString(card);
        return cardinality;
    }
}

