/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.pdt.introspector.core.services;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.pdt.introspector.core.IntrospectionContext;
import org.polarsys.kitalpha.pdt.introspector.core.comparators.FeatureComparator;
import org.polarsys.kitalpha.pdt.introspector.core.comparators.PackageComparator;
import org.polarsys.kitalpha.pdt.introspector.core.comparators.PluginComparator;
import org.polarsys.kitalpha.pdt.introspector.core.exceptions.IntrospectionExceptions;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.Feature;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.Package;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.PlatformFactory;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.Plugin;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.Repository;

public class PackageServices {
    private static void sortPackages(Repository myRepository) {
        EList containedPackages = myRepository.getPackages();
        Package[] containedPackagesArray = (Package[])containedPackages.toArray();
        PackageComparator packageComparator = new PackageComparator();
        Arrays.sort(containedPackagesArray, packageComparator);
        containedPackages.clear();
        Package[] packageArray = containedPackagesArray;
        int n = containedPackagesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Package currentPackage = packageArray[n2];
            containedPackages.add((Object)currentPackage);
            ++n2;
        }
        for (Package currentPackage : containedPackages) {
            PackageServices.sortPackages(currentPackage);
        }
    }

    private static void sortPackages(Package currentPackage) {
        EList containedPackages = currentPackage.getSubPackages();
        Package[] containedPackagesArray = (Package[])containedPackages.toArray();
        PackageComparator packageComparator = new PackageComparator();
        Arrays.sort(containedPackagesArray, packageComparator);
        containedPackages.clear();
        Package[] packageArray = containedPackagesArray;
        int n = containedPackagesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Package child = packageArray[n2];
            containedPackages.add((Object)child);
            ++n2;
        }
        for (Package child : containedPackages) {
            PackageServices.sortPackages(child);
            PackageServices.sortFeatures((EList<Feature>)child.getFeatures());
            PackageServices.sortPlugins((EList<Plugin>)child.getPlugins());
        }
    }

    public static void sortFeatures(EList<Feature> containedFeatures) {
        Feature[] containedFeatureArray = (Feature[])containedFeatures.toArray();
        FeatureComparator comparator = new FeatureComparator();
        Arrays.sort(containedFeatureArray, comparator);
        containedFeatures.clear();
        Feature[] featureArray = containedFeatureArray;
        int n = containedFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            Feature feature = featureArray[n2];
            containedFeatures.add((Object)feature);
            ++n2;
        }
    }

    public static void sortPlugins(EList<Plugin> containedPlugins) {
        Plugin[] containedPluginArray = (Plugin[])containedPlugins.toArray();
        PluginComparator PluginComparator2 = new PluginComparator();
        Arrays.sort(containedPluginArray, PluginComparator2);
        containedPlugins.clear();
        Plugin[] pluginArray = containedPluginArray;
        int n = containedPluginArray.length;
        int n2 = 0;
        while (n2 < n) {
            Plugin plugin = pluginArray[n2];
            containedPlugins.add((Object)plugin);
            ++n2;
        }
    }

    static void handlePackagesForPluginOrFeature(Repository myRepository, PlatformFactory factory, Map<String, Package> absoluteName2Package, String elementId, EObject element) {
        String currentPluginName = elementId;
        String[] names = currentPluginName.split("[.]");
        String currentAbsName = "";
        int i = 0;
        while (i < names.length) {
            Package currentPackage;
            String parentAbsName = currentAbsName;
            String currName = names[i];
            if (!absoluteName2Package.containsKey(currentAbsName = currentAbsName.length() > 0 ? String.valueOf(currentAbsName) + "." + currName : currName)) {
                currentPackage = factory.createPackage();
                currentPackage.setName(currName);
                absoluteName2Package.put(currentAbsName, currentPackage);
                if (parentAbsName.length() > 0) {
                    Package parentPackage = absoluteName2Package.get(parentAbsName);
                    parentPackage.getSubPackages().add((Object)currentPackage);
                } else {
                    myRepository.getPackages().add((Object)currentPackage);
                }
            } else {
                currentPackage = absoluteName2Package.get(currentAbsName);
            }
            if (i == names.length - 1) {
                if (element instanceof Plugin) {
                    currentPackage.getPlugins().add((Object)((Plugin)element));
                } else if (element instanceof Feature) {
                    currentPackage.getFeatures().add((Object)((Feature)element));
                } else {
                    System.out.println("cas non pr\ufffdvu");
                }
            }
            ++i;
        }
    }

    public static void createPackages(IntrospectionContext introContext, IProgressMonitor monitor, Repository myRepository) throws IntrospectionExceptions {
        monitor.subTask("Creating Packages...");
        Plugin[] plugins = (Plugin[])myRepository.getPlugins().toArray();
        Feature[] features = (Feature[])myRepository.getFeatures().toArray();
        PlatformFactory factory = PlatformFactory.eINSTANCE;
        HashMap<String, Package> absoluteName2Package = new HashMap<String, Package>();
        Plugin[] pluginArray = plugins;
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            Plugin currentPlugin = pluginArray[n2];
            if (monitor.isCanceled()) {
                throw new IntrospectionExceptions();
            }
            String pluginId = currentPlugin.getId();
            PackageServices.handlePackagesForPluginOrFeature(myRepository, factory, absoluteName2Package, pluginId, (EObject)currentPlugin);
            monitor.worked(1);
            ++n2;
        }
        pluginArray = features;
        n = features.length;
        n2 = 0;
        while (n2 < n) {
            Plugin currentFeature = pluginArray[n2];
            if (monitor.isCanceled()) {
                throw new IntrospectionExceptions();
            }
            String featureId = currentFeature.getId();
            PackageServices.handlePackagesForPluginOrFeature(myRepository, factory, absoluteName2Package, featureId, (EObject)currentFeature);
            monitor.worked(1);
            ++n2;
        }
        PackageServices.sortPackages(myRepository);
        boolean changed = true;
        while (changed) {
            Package[] rootPackages;
            changed = false;
            Package[] packageArray = rootPackages = (Package[])myRepository.getPackages().toArray();
            int n3 = rootPackages.length;
            int n4 = 0;
            while (n4 < n3) {
                Package currentPackage = packageArray[n4];
                changed = changed || PackageServices.removeUselessPackages(currentPackage);
                ++n4;
            }
        }
    }

    private static boolean removeUselessPackages(Package p) {
        boolean changed = false;
        Package[] subPackages = (Package[])p.getSubPackages().toArray();
        if (subPackages.length == 0) {
            Feature[] features;
            Plugin[] plugins = (Plugin[])p.getPlugins().toArray();
            if (plugins.length + (features = (Feature[])p.getFeatures().toArray()).length == 1) {
                Package father;
                int n;
                int n2;
                Plugin[] pluginArray;
                if (plugins.length == 1) {
                    pluginArray = plugins;
                    n2 = plugins.length;
                    n = 0;
                    while (n < n2) {
                        Plugin plugin = pluginArray[n];
                        if (p.eContainer() instanceof Package) {
                            father = (Package)p.eContainer();
                            father.getPlugins().add((Object)plugin);
                        } else {
                            father = (Repository)p.eContainer();
                            father.getPlugins().add((Object)plugin);
                        }
                        ++n;
                    }
                }
                if (features.length == 1) {
                    pluginArray = features;
                    n2 = features.length;
                    n = 0;
                    while (n < n2) {
                        Plugin feature = pluginArray[n];
                        if (p.eContainer() instanceof Package) {
                            father = (Package)p.eContainer();
                            father.getFeatures().add((Object)feature);
                        } else {
                            father = (Repository)p.eContainer();
                            father.getFeatures().add((Object)feature);
                        }
                        ++n;
                    }
                }
                EcoreUtil.remove((EObject)p);
                changed = true;
            }
        } else {
            Package[] packageArray = subPackages;
            int n = subPackages.length;
            int n3 = 0;
            while (n3 < n) {
                Package subPackage = packageArray[n3];
                changed = changed || PackageServices.removeUselessPackages(subPackage);
                ++n3;
            }
        }
        return changed;
    }
}

