/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.integration.rules;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Rule;
import org.polarsys.kitalpha.ad.viewpoint.integration.rules.ElementDescriptor;
import org.polarsys.kitalpha.ad.viewpoint.integration.rules.RuleProvider;

public class Rules {
    private static final String EXTENSION_POINT_ID = "org.polarsys.kitalpha.ad.viewpoint.rule.providers";

    public static String getProviderName(Rule rule) {
        if (rule.getImplementation() == null || "".equals(rule.getImplementation())) {
            return null;
        }
        RuleProvider provider = Rules.getProvider(rule.getType());
        if (provider == null) {
            return null;
        }
        ElementDescriptor[] elementDescriptorArray = provider.getAvailableImplementations();
        int n = elementDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ElementDescriptor elt = elementDescriptorArray[n2];
            if (elt.implementation.equals(rule.getImplementation())) {
                return elt.provider;
            }
            ++n2;
        }
        return "Cannot find the provider plugin";
    }

    public static String getName(Rule rule) {
        if (rule.getImplementation() == null || "".equals(rule.getImplementation())) {
            return null;
        }
        RuleProvider provider = Rules.getProvider(rule.getType());
        if (provider == null) {
            return null;
        }
        ElementDescriptor[] elementDescriptorArray = provider.getAvailableImplementations();
        int n = elementDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ElementDescriptor elt = elementDescriptorArray[n2];
            if (elt.implementation.equals(rule.getImplementation())) {
                return elt.name;
            }
            ++n2;
        }
        return "Missing - May be not loaded yet";
    }

    public static String[] getAvailableTypes() {
        Object[] types = Rules.getProviders().keySet().toArray(new String[Rules.getProviders().size()]);
        Arrays.sort(types);
        return types;
    }

    public static ElementDescriptor[] getAvailableImplementations(String type) {
        if (type == null) {
            return new ElementDescriptor[0];
        }
        RuleProvider ruleProvider = Rules.getProviders().get(type);
        if (ruleProvider != null) {
            return ruleProvider.getAvailableImplementations();
        }
        return new ElementDescriptor[0];
    }

    public static RuleProvider getProvider(String type) {
        return Rules.getProviders().get(type);
    }

    public static Map<String, RuleProvider> getProviders() {
        IConfigurationElement[] configurationElements;
        HashMap<String, RuleProvider> providers = new HashMap<String, RuleProvider>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elt = iConfigurationElementArray[n2];
            try {
                RuleProvider prov = (RuleProvider)elt.createExecutableExtension("class");
                providers.put(prov.getType(), prov);
            }
            catch (CoreException e) {
                AD_Log.getDefault().logError((Throwable)e);
            }
            ++n2;
        }
        return providers;
    }

    private Rules() {
    }
}

