/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.richtext.common.util;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.osgi.framework.Bundle;
import org.polarsys.kitalpha.richtext.common.internal.Activator;

public class MDERichTextHelper {
    private MDERichTextHelper() {
    }

    public static IProject getProject(EObject eObject) {
        IProject result = null;
        if (eObject == null) {
            return null;
        }
        IFile res = MDERichTextHelper.getFile(eObject);
        if (res != null) {
            result = res.getProject();
        }
        return result;
    }

    public static IFile getFile(EObject eObject) {
        if (eObject == null || eObject.eResource() == null) {
            return null;
        }
        return WorkspaceSynchronizer.getFile((Resource)eObject.eResource());
    }

    public static String getProjectPath(EObject eObject) {
        IPath path;
        IProject project = MDERichTextHelper.getProject(eObject);
        if (project != null && (path = project.getLocation()) != null) {
            return path.toPortableString();
        }
        return null;
    }

    public static URL getURL(String bundleId, String path) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        URL escapedURL = null;
        if (bundle != null) {
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
            try {
                URL resolvedUrl = FileLocator.toFileURL((URL)url);
                URI uri = new URI(resolvedUrl.getProtocol(), resolvedUrl.getPath(), null);
                escapedURL = uri.toURL();
            }
            catch (IOException e) {
                Status status = new Status(4, "org.polarsys.kitalpha.richtext.common", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
            catch (URISyntaxException e) {
                Status status = new Status(4, "org.polarsys.kitalpha.richtext.common", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return escapedURL;
    }
}

