/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.richtext.widget.tools.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.kitalpha.richtext.common.intf.MDERichTextWidget;
import org.polarsys.kitalpha.richtext.common.util.MDERichTextHelper;
import org.polarsys.kitalpha.richtext.widget.tools.internal.LinkHandlerExtension;
import org.polarsys.kitalpha.richtext.widget.tools.intf.LinkHandler;
import org.polarsys.kitalpha.richtext.widget.tools.manager.LinkManager;
import org.polarsys.kitalpha.richtext.widget.tools.utils.Tuple;

public class LinkManagerImpl
implements LinkManager {
    private MDERichTextWidget widget;
    protected final Map<String, String> label2type = new HashMap<String, String>();

    public LinkManagerImpl() {
        this(null);
    }

    public LinkManagerImpl(MDERichTextWidget richText) {
        this.widget = richText;
        this.label2type.put("URL", "http");
        this.label2type.put("File (absolute path) (not recommended)", "file");
        this.label2type.put("File (project relative path) (not recommended)", "local");
        this.label2type.put("Model Element", "modelElement");
        this.label2type.put("Diagram Element", "modelDiagram");
    }

    @Override
    public List<String> getAllLinkLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("URL");
        result.add("File (absolute path) (not recommended)");
        result.add("File (project relative path) (not recommended)");
        result.add("Model Element");
        result.add("Diagram Element");
        return result;
    }

    @Override
    public void openLink(String link) {
        Collection<LinkHandler> handlers = LinkHandlerExtension.getHandlers();
        for (LinkHandler linkHandler : handlers) {
            if (!linkHandler.canHandleLink(link)) continue;
            linkHandler.openLink(this.widget.getElement(), linkHandler.decode(link, MDERichTextHelper.getProjectPath((EObject)this.widget.getElement())));
            break;
        }
    }

    @Override
    public Tuple<String, String> getURI(String linkType, String basePath, Object object) {
        LinkHandler handlerFor = LinkHandlerExtension.getHandlerFor(this.label2type.get(linkType));
        if (handlerFor != null) {
            return handlerFor.getLink(this.label2type.get(linkType), basePath, object);
        }
        return null;
    }

    @Override
    public String encode(String linkType, String url, String urlDisplayName) {
        LinkHandler handlerFor = LinkHandlerExtension.getHandlerFor(this.label2type.get(linkType));
        if (handlerFor != null) {
            return handlerFor.encode(url, urlDisplayName);
        }
        return null;
    }
}

