/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.cloud.app.command;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.kura.cloud.app.command.InterruptTimerTask;
import org.eclipse.kura.cloud.app.command.StreamGobbler;

public class ProcessMonitorThread
extends Thread {
    private Process proc;
    private String stdin;
    private int procTout;
    private String stdout;
    private String stderr;
    private boolean timedOut;
    private Exception exception;
    private Integer exitValue;

    public ProcessMonitorThread(Process proc, String stdin, int procTout) {
        this.proc = proc;
        this.stdin = stdin;
        this.procTout = procTout;
        this.timedOut = false;
    }

    public String getStdout() {
        return this.stdout;
    }

    public String getStderr() {
        return this.stderr;
    }

    public Integer getExitValue() {
        return this.exitValue;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public void run() {
        block88: {
            Thread esg;
            BufferedWriter obw;
            OutputStream os;
            InputStream es;
            InputStream is;
            block90: {
                is = null;
                es = null;
                os = null;
                obw = null;
                Thread isg = null;
                esg = null;
                Timer timer = null;
                try {
                    if (this.procTout > 0) {
                        timer = new Timer(true);
                        InterruptTimerTask interrupter = new InterruptTimerTask(Thread.currentThread());
                        timer.schedule((TimerTask)interrupter, this.procTout * 1000);
                    }
                    is = this.proc.getInputStream();
                    es = this.proc.getErrorStream();
                    os = this.proc.getOutputStream();
                    OutputStreamWriter osw = new OutputStreamWriter(os);
                    obw = new BufferedWriter(osw);
                    isg = new StreamGobbler(is, "stdout");
                    esg = new StreamGobbler(es, "stderr");
                    isg.start();
                    esg.start();
                    if (this.stdin != null) {
                        obw.write(this.stdin);
                        obw.newLine();
                        obw.flush();
                    }
                    this.proc.waitFor();
                    isg.join(1000L);
                    esg.join(1000L);
                    this.exitValue = this.proc.exitValue();
                }
                catch (IOException e) {
                    this.exception = e;
                    if (timer != null) {
                        timer.cancel();
                    }
                    if (isg != null) {
                        isg.interrupt();
                        try {
                            isg.join(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        this.stdout = ((StreamGobbler)isg).getStreamAsString();
                    }
                    if (esg != null) {
                        esg.interrupt();
                        try {
                            esg.join(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        this.stderr = ((StreamGobbler)esg).getStreamAsString();
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (es != null) {
                        try {
                            es.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (obw != null) {
                        try {
                            obw.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (this.proc != null) {
                        this.proc.destroy();
                    }
                    Thread.interrupted();
                    break block88;
                }
                catch (InterruptedException interruptedException) {
                    block89: {
                        try {
                            this.timedOut = true;
                            if (timer != null) {
                                timer.cancel();
                            }
                            if (isg == null) break block89;
                        }
                        catch (Throwable throwable) {
                            if (timer != null) {
                                timer.cancel();
                            }
                            if (isg != null) {
                                isg.interrupt();
                                try {
                                    isg.join(1000L);
                                }
                                catch (InterruptedException interruptedException2) {}
                                this.stdout = ((StreamGobbler)isg).getStreamAsString();
                            }
                            if (esg != null) {
                                esg.interrupt();
                                try {
                                    esg.join(1000L);
                                }
                                catch (InterruptedException interruptedException3) {}
                                this.stderr = ((StreamGobbler)esg).getStreamAsString();
                            }
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (es != null) {
                                try {
                                    es.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (obw != null) {
                                try {
                                    obw.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (os != null) {
                                try {
                                    os.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (this.proc != null) {
                                this.proc.destroy();
                            }
                            Thread.interrupted();
                            throw throwable;
                        }
                        isg.interrupt();
                        try {
                            isg.join(1000L);
                        }
                        catch (InterruptedException interruptedException4) {}
                        this.stdout = ((StreamGobbler)isg).getStreamAsString();
                    }
                    if (esg != null) {
                        esg.interrupt();
                        try {
                            esg.join(1000L);
                        }
                        catch (InterruptedException interruptedException5) {}
                        this.stderr = ((StreamGobbler)esg).getStreamAsString();
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (es != null) {
                        try {
                            es.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (obw != null) {
                        try {
                            obw.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (this.proc != null) {
                        this.proc.destroy();
                    }
                    Thread.interrupted();
                    break block88;
                }
                if (timer != null) {
                    timer.cancel();
                }
                if (isg == null) break block90;
                isg.interrupt();
                try {
                    isg.join(1000L);
                }
                catch (InterruptedException interruptedException) {}
                this.stdout = ((StreamGobbler)isg).getStreamAsString();
            }
            if (esg != null) {
                esg.interrupt();
                try {
                    esg.join(1000L);
                }
                catch (InterruptedException interruptedException) {}
                this.stderr = ((StreamGobbler)esg).getStreamAsString();
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (es != null) {
                try {
                    es.close();
                }
                catch (IOException iOException) {}
            }
            if (obw != null) {
                try {
                    obw.close();
                }
                catch (IOException iOException) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
            if (this.proc != null) {
                this.proc.destroy();
            }
            Thread.interrupted();
        }
    }
}

