/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.net.modem;

import java.util.List;
import org.eclipse.kura.core.net.modem.ModemInterfaceAddressImpl;
import org.eclipse.kura.net.NetConfig;
import org.eclipse.kura.net.modem.ModemInterfaceAddress;
import org.eclipse.kura.net.modem.ModemInterfaceAddressConfig;

public class ModemInterfaceAddressConfigImpl
extends ModemInterfaceAddressImpl
implements ModemInterfaceAddressConfig {
    private List<NetConfig> m_configs;

    public ModemInterfaceAddressConfigImpl() {
    }

    public ModemInterfaceAddressConfigImpl(ModemInterfaceAddress other) {
        super(other);
    }

    public List<NetConfig> getConfigs() {
        return this.m_configs;
    }

    public void setNetConfigs(List<NetConfig> configs) {
        this.m_configs = configs;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ModemInterfaceAddressConfig)) {
            return false;
        }
        ModemInterfaceAddressConfig other = (ModemInterfaceAddressConfig)obj;
        if (!this.compare(this.getSignalStrength(), other.getSignalStrength())) {
            return false;
        }
        if (!this.compare(this.isRoaming(), other.isRoaming())) {
            return false;
        }
        if (!this.compare(this.getConnectionStatus(), other.getConnectionStatus())) {
            return false;
        }
        if (this.getBytesTransmitted() != other.getBytesTransmitted()) {
            return false;
        }
        if (this.getBytesReceived() != other.getBytesReceived()) {
            return false;
        }
        if (!this.compare(this.getConnectionType(), other.getConnectionType())) {
            return false;
        }
        List<NetConfig> thisNetConfigs = this.getConfigs();
        List otherNetConfigs = other.getConfigs();
        if (thisNetConfigs.size() != otherNetConfigs.size()) {
            return false;
        }
        if (!thisNetConfigs.containsAll(otherNetConfigs)) {
            return false;
        }
        return otherNetConfigs.containsAll(thisNetConfigs);
    }

    public String toString() {
        if (this.m_configs != null) {
            StringBuffer sb = new StringBuffer();
            for (NetConfig netConfig : this.m_configs) {
                sb.append("NetConfig: ");
                if (netConfig != null) {
                    sb.append(netConfig.toString());
                } else {
                    sb.append("null");
                }
                sb.append(" - ");
            }
            return sb.toString();
        }
        return "NetConfig: no configurations";
    }
}

