/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb;

import com.ibm.jusb.UsbDescriptorImp;
import java.io.UnsupportedEncodingException;
import javax.usb.UsbStringDescriptor;

public class UsbStringDescriptorImp
extends UsbDescriptorImp
implements UsbStringDescriptor {
    private byte[] bString = null;
    private String string = null;
    public static final String[] ENCODING = new String[]{"UnicodeLittleUnmarked", "UnicodeLittle", "UTF-16LE"};
    public static final String ENCODING_8BIT = "ASCII";

    public UsbStringDescriptorImp(byte bLength, byte bDescriptorType, byte[] bString) {
        super(bLength, bDescriptorType);
        this.bString = bString;
    }

    public byte[] bString() {
        try {
            byte[] bStringCopy = new byte[this.bString.length];
            System.arraycopy(this.bString, 0, bStringCopy, 0, this.bString.length);
            return bStringCopy;
        }
        catch (NullPointerException npE) {
            return null;
        }
    }

    public String getString() throws UnsupportedEncodingException {
        if (null == this.string) {
            this.string = this.createString();
        }
        return this.string;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        UsbStringDescriptorImp desc = null;
        try {
            desc = (UsbStringDescriptorImp)object;
        }
        catch (ClassCastException ccE) {
            return false;
        }
        try {
            if (this.getString() != desc.getString()) {
                return false;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.bString() == desc.bString();
    }

    private String createString() throws UnsupportedEncodingException {
        if (null == this.bString()) {
            return null;
        }
        byte[] s16 = this.bString();
        for (int i = 0; i < ENCODING.length; ++i) {
            try {
                return new String(s16, 0, s16.length, ENCODING[i]);
            }
            catch (UnsupportedEncodingException ueE) {
                continue;
            }
        }
        byte[] s8 = new byte[s16.length / 2];
        int i8 = 0;
        int i16 = 0;
        while (i8 < s8.length && i16 + 1 < s16.length) {
            s8[i8] = s16[i16];
            if (0 != s16[i16 + 1]) {
                throw new UnsupportedEncodingException("No 16-bit encoding available for 16-bit string");
            }
            ++i8;
            ++i16;
            ++i16;
        }
        return new String(s8, ENCODING_8BIT);
    }
}

