/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.data;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class DataServiceOptions {
    private static final String AUTOCONNECT_PROP_NAME = "connect.auto-on-startup";
    private static final String CONNECT_DELAY_PROP_NAME = "connect.retry-interval";
    private static final String DISCONNECT_DELAY_PROP_NAME = "disconnect.quiesce-timeout";
    private static final String STORE_DB_SERVICE_INSTANCE_PROP_NAME = "store.db.service.pid";
    private static final String STORE_HOUSEKEEPER_INTERVAL_PROP_NAME = "store.housekeeper-interval";
    private static final String STORE_PURGE_AGE_PROP_NAME = "store.purge-age";
    private static final String STORE_CAPACITY_PROP_NAME = "store.capacity";
    private static final String REPUBLISH_IN_FLIGHT_MSGS_PROP_NAME = "in-flight-messages.republish-on-new-session";
    private static final String MAX_IN_FLIGHT_MSGS_PROP_NAME = "in-flight-messages.max-number";
    private static final String IN_FLIGHT_MSGS_CONGESTION_TIMEOUT_PROP_NAME = "in-flight-messages.congestion-timeout";
    private static final String RATE_LIMIT_ENABLE_PROP_NAME = "enable.rate.limit";
    private static final String RATE_LIMIT_AVERAGE_RATE_PROP_NAME = "rate.limit.average";
    private static final String RATE_LIMIT_TIME_UNIT_PROP_NAME = "rate.limit.time.unit";
    private static final String RATE_LIMIT_BURST_SIZE_PROP_NAME = "rate.limit.burst.size";
    private static final String RECOVERY_ENABLE_PROP_NAME = "enable.recovery.on.connection.failure";
    private static final String RECOVERY_MAX_FAILURES_PROP_NAME = "connection.recovery.max.failures";
    private static final boolean AUTOCONNECT_PROP_DEFAULT = false;
    private static final int CONNECT_DELAY_DEFAULT = 60;
    private static final int DISCONNECT_DELAY_DEFAULT = 10;
    private static final String DB_SERVICE_INSTANCE_DEFAULT = "org.eclipse.kura.db.H2DbService";
    private static final int STORE_HOUSEKEEPER_INTERVAL_DEFAULT = 900;
    private static final int STORE_PURGE_AGE_DEFAULT = 60;
    private static final int STORE_CAPACITY_DEFAULT = 10000;
    private static final boolean REPUBLISH_IN_FLIGHT_MSGS_DEFAULT = true;
    private static final int MAX_IN_FLIGHT_MSGS_DEFAULT = 9;
    private static final int IN_FLIGHT_MSGS_CONGESTION_TIMEOUT_DEFAULT = 0;
    private static final boolean RATE_LIMIT_ENABLE_DEFAULT = true;
    private static final int RATE_LIMIT_AVERAGE_RATE_DEFAULT = 1;
    private static final String RATE_LIMIT_TIME_UNIT_DEFAULT = "SECONDS";
    private static final int RATE_LIMIT_BURST_SIZE_DEFAULT = 1;
    private static final boolean RECOVERY_ENABLE_DEFAULT = true;
    private static final int RECOVERY_MAX_FAILURES_DEFAULT = 10;
    private static final int CONNECT_CRITICAL_COMPONENT_TIMEOUT_MULTIPLIER = 5000;
    private final Map<String, Object> properties;

    DataServiceOptions(Map<String, Object> properties) {
        Objects.requireNonNull(properties, "Required not null");
        this.properties = Collections.unmodifiableMap(properties);
    }

    int getStoreHousekeeperInterval() {
        return (Integer)this.properties.getOrDefault(STORE_HOUSEKEEPER_INTERVAL_PROP_NAME, 900);
    }

    int getStorePurgeAge() {
        return (Integer)this.properties.getOrDefault(STORE_PURGE_AGE_PROP_NAME, 60);
    }

    int getStoreCapacity() {
        return (Integer)this.properties.getOrDefault(STORE_CAPACITY_PROP_NAME, 10000);
    }

    boolean isPublishInFlightMessages() {
        return (Boolean)this.properties.getOrDefault(REPUBLISH_IN_FLIGHT_MSGS_PROP_NAME, true);
    }

    int getMaxInFlightMessages() {
        return (Integer)this.properties.getOrDefault(MAX_IN_FLIGHT_MSGS_PROP_NAME, 9);
    }

    int getInFlightMessagesCongestionTimeout() {
        return (Integer)this.properties.getOrDefault(IN_FLIGHT_MSGS_CONGESTION_TIMEOUT_PROP_NAME, 0);
    }

    boolean isAutoConnect() {
        return (Boolean)this.properties.getOrDefault(AUTOCONNECT_PROP_NAME, false);
    }

    int getConnectDelay() {
        return (Integer)this.properties.getOrDefault(CONNECT_DELAY_PROP_NAME, 60);
    }

    int getDisconnectDelay() {
        return (Integer)this.properties.getOrDefault(DISCONNECT_DELAY_PROP_NAME, 10);
    }

    boolean isRateLimitEnabled() {
        return (Boolean)this.properties.getOrDefault(RATE_LIMIT_ENABLE_PROP_NAME, true);
    }

    int getRateLimitAverageRate() {
        return (Integer)this.properties.getOrDefault(RATE_LIMIT_AVERAGE_RATE_PROP_NAME, 1);
    }

    int getRateLimitBurstSize() {
        return (Integer)this.properties.getOrDefault(RATE_LIMIT_BURST_SIZE_PROP_NAME, 1);
    }

    long getRateLimitTimeUnit() {
        TimeUnit timeUnit;
        String timeUnitString = (String)this.properties.getOrDefault(RATE_LIMIT_TIME_UNIT_PROP_NAME, RATE_LIMIT_TIME_UNIT_DEFAULT);
        if (TimeUnit.MILLISECONDS.name().equals(timeUnitString)) {
            timeUnit = TimeUnit.MILLISECONDS;
        } else if (TimeUnit.SECONDS.name().equals(timeUnitString)) {
            timeUnit = TimeUnit.SECONDS;
        } else if (TimeUnit.MINUTES.name().equals(timeUnitString)) {
            timeUnit = TimeUnit.MINUTES;
        } else if (TimeUnit.HOURS.name().equals(timeUnitString)) {
            timeUnit = TimeUnit.HOURS;
        } else if (TimeUnit.DAYS.name().equals(timeUnitString)) {
            timeUnit = TimeUnit.DAYS;
        } else {
            throw new IllegalArgumentException("Illegal time unit");
        }
        return timeUnit.toMillis(1L);
    }

    String getDbServiceInstancePid() {
        return (String)this.properties.getOrDefault(STORE_DB_SERVICE_INSTANCE_PROP_NAME, DB_SERVICE_INSTANCE_DEFAULT);
    }

    String getKuraServicePid() {
        return (String)this.properties.get("kura.service.pid");
    }

    boolean isConnectionRecoveryEnabled() {
        return (Boolean)this.properties.getOrDefault(RECOVERY_ENABLE_PROP_NAME, true);
    }

    int getRecoveryMaximumAllowedFailures() {
        return (Integer)this.properties.getOrDefault(RECOVERY_MAX_FAILURES_PROP_NAME, 10);
    }

    int getCriticalComponentTimeout() {
        return this.getConnectDelay() * 5000;
    }
}

