/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.cloudconnection;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.kura.web.client.ui.cloudconnection.CloudConnectionConfigurationUi;
import org.eclipse.kura.web.client.ui.cloudconnection.CloudConnectionsUi;
import org.eclipse.kura.web.client.util.request.RequestQueue;
import org.eclipse.kura.web.shared.FilterUtil;
import org.eclipse.kura.web.shared.model.GwtCloudConnectionEntry;
import org.eclipse.kura.web.shared.model.GwtCloudEntry;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtCloudConnectionService;
import org.eclipse.kura.web.shared.service.GwtCloudConnectionServiceAsync;
import org.eclipse.kura.web.shared.service.GwtComponentService;
import org.eclipse.kura.web.shared.service.GwtComponentServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.NavTabs;
import org.gwtbootstrap3.client.ui.TabContent;
import org.gwtbootstrap3.client.ui.TabListItem;
import org.gwtbootstrap3.client.ui.TabPane;

public class CloudConnectionConfigurationsUi
extends Composite {
    private static CloudServiceConfigurationsUiUiBinder uiBinder = (CloudServiceConfigurationsUiUiBinder)GWT.create(CloudServiceConfigurationsUiUiBinder.class);
    private final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);
    private final GwtCloudConnectionServiceAsync gwtCloudService = (GwtCloudConnectionServiceAsync)GWT.create(GwtCloudConnectionService.class);
    private final GwtComponentServiceAsync gwtComponentService = (GwtComponentServiceAsync)GWT.create(GwtComponentService.class);
    private TabListItem currentlySelectedTab;
    private boolean dirty;
    private final CloudConnectionsUi cloudServicesUi;
    @UiField
    TabContent connectionTabContent;
    @UiField
    NavTabs connectionNavtabs;

    public CloudConnectionConfigurationsUi(CloudConnectionsUi cloudServicesUi) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.cloudServicesUi = cloudServicesUi;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        int connectionTabIndex = 0;
        while (connectionTabIndex < this.connectionTabContent.getWidgetCount()) {
            TabPane pane = (TabPane)this.connectionTabContent.getWidget(connectionTabIndex);
            int paneIndex = 0;
            while (paneIndex < pane.getWidgetCount()) {
                CloudConnectionConfigurationUi serviceConfigUi = (CloudConnectionConfigurationUi)pane.getWidget(paneIndex);
                serviceConfigUi.setDirty(dirty);
                ++paneIndex;
            }
            ++connectionTabIndex;
        }
    }

    public boolean isDirty() {
        int connectionTabIndex = 0;
        while (connectionTabIndex < this.connectionTabContent.getWidgetCount()) {
            TabPane pane = (TabPane)this.connectionTabContent.getWidget(connectionTabIndex);
            int paneIndex = 0;
            while (paneIndex < pane.getWidgetCount()) {
                CloudConnectionConfigurationUi serviceConfigUi = (CloudConnectionConfigurationUi)pane.getWidget(paneIndex);
                this.dirty = this.dirty || serviceConfigUi.isDirty();
                ++paneIndex;
            }
            ++connectionTabIndex;
        }
        return this.dirty;
    }

    public CloudConnectionConfigurationUi getDirtyCloudConfiguration() {
        int connectionTabIndex = 0;
        while (connectionTabIndex < this.connectionTabContent.getWidgetCount()) {
            TabPane pane = (TabPane)this.connectionTabContent.getWidget(connectionTabIndex);
            int paneIndex = 0;
            while (paneIndex < pane.getWidgetCount()) {
                CloudConnectionConfigurationUi serviceConfigUi = (CloudConnectionConfigurationUi)pane.getWidget(paneIndex);
                if (serviceConfigUi.isDirty()) {
                    return serviceConfigUi;
                }
                ++paneIndex;
            }
            ++connectionTabIndex;
        }
        return null;
    }

    public void setVisibility(boolean isVisible) {
        this.connectionNavtabs.setVisible(isVisible);
        this.connectionTabContent.setVisible(isVisible);
    }

    public void selectEntry(GwtCloudEntry selection) {
        this.connectionNavtabs.clear();
        this.connectionTabContent.clear();
        if (selection instanceof GwtCloudConnectionEntry) {
            this.getCloudStackConfigurations(((GwtCloudConnectionEntry)selection).getCloudConnectionFactoryPid(), selection.getPid());
        } else {
            this.getPubSubConfiguration(selection.getPid());
        }
    }

    public TabListItem getSelectedTab() {
        return this.currentlySelectedTab;
    }

    public void setSelectedTab(TabListItem tabListItem) {
        this.currentlySelectedTab = tabListItem;
    }

    private void getPubSubConfiguration(String pid) {
        RequestQueue.submit(context -> this.gwtXSRFService.generateSecurityToken(context.callback(token -> this.gwtComponentService.findFilteredComponentConfiguration((GwtXSRFToken)token, pid, (AsyncCallback<List<GwtConfigComponent>>)context.callback(confs -> {
            this.connectionNavtabs.clear();
            this.renderTabs((GwtConfigComponent)confs.get(0), true);
        })))));
    }

    private void getCloudStackConfigurations(String factoryPid, String cloudServicePid) {
        this.connectionNavtabs.clear();
        RequestQueue.submit(context -> this.gwtCloudService.findStackPidsByFactory(factoryPid, cloudServicePid, context.callback(pidsResult -> {
            if (pidsResult.isEmpty()) {
                return;
            }
            this.gwtXSRFService.generateSecurityToken(context.callback(token -> this.gwtComponentService.findComponentConfigurations((GwtXSRFToken)token, FilterUtil.getPidFilter(pidsResult.iterator()), (AsyncCallback<List<GwtConfigComponent>>)context.callback(result -> {
                ArrayList<GwtConfigComponent> sorted = new ArrayList<GwtConfigComponent>((Collection<GwtConfigComponent>)result);
                sorted.sort(Comparator.comparing(this::getSimplifiedComponentName));
                boolean isFirstEntry = true;
                for (GwtConfigComponent pair : sorted) {
                    if (!pidsResult.contains(pair.getComponentId())) continue;
                    this.renderTabs(pair, isFirstEntry);
                    isFirstEntry = false;
                }
            }))));
        })));
    }

    private void renderTabs(GwtConfigComponent config, boolean isFirstEntry) {
        String simplifiedComponentName = this.getSimplifiedComponentName(config);
        TabListItem item = new TabListItem(simplifiedComponentName);
        item.setDataTarget("#" + simplifiedComponentName);
        item.addClickHandler(event -> {
            Anchor anchor = (Anchor)event.getSource();
            this.cloudServicesUi.onTabSelectionChange((TabListItem)anchor.getParent());
        });
        this.connectionNavtabs.add((Widget)item);
        TabPane tabPane = new TabPane();
        tabPane.setId(simplifiedComponentName);
        CloudConnectionConfigurationUi serviceConfigurationBinder = new CloudConnectionConfigurationUi(config);
        tabPane.add((Widget)serviceConfigurationBinder);
        this.connectionTabContent.add((Widget)tabPane);
        if (isFirstEntry) {
            this.currentlySelectedTab = item;
            item.setActive(true);
            tabPane.setActive(true);
        }
        serviceConfigurationBinder.renderForm();
    }

    private String getSimplifiedComponentName(GwtConfigComponent config) {
        String selectedCloudServicePid = config.getComponentId();
        int start = selectedCloudServicePid.lastIndexOf(46);
        int substringIndex = start + 1;
        String tempName = start != -1 && substringIndex < selectedCloudServicePid.length() ? selectedCloudServicePid.substring(substringIndex) : selectedCloudServicePid;
        return tempName;
    }

    static interface CloudServiceConfigurationsUiUiBinder
    extends UiBinder<Widget, CloudConnectionConfigurationsUi> {
    }
}

