/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.AbstractInfo;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.DeploymentAdminImpl;
import org.apache.felix.deploymentadmin.ResourceInfoImpl;
import org.apache.felix.deploymentadmin.Utils;
import org.osgi.framework.BundleContext;
import org.osgi.service.deploymentadmin.DeploymentException;

public class FileDeploymentPackage
extends AbstractDeploymentPackage {
    private final List m_index;
    private final File m_contentsDir;

    public FileDeploymentPackage(File index, File packageDir, BundleContext bundleContext, DeploymentAdminImpl deploymentAdmin) throws DeploymentException, IOException {
        this(Utils.readIndex(index), packageDir, bundleContext, deploymentAdmin);
    }

    private FileDeploymentPackage(List index, File packageDir, BundleContext bundleContext, DeploymentAdminImpl deploymentAdmin) throws DeploymentException, IOException {
        super(Utils.readManifest(new File(packageDir, (String)index.remove(0))), bundleContext, deploymentAdmin);
        this.m_index = index;
        this.m_contentsDir = packageDir;
    }

    public BundleInfoImpl[] getOrderedBundleInfos() {
        ArrayList<BundleInfoImpl> result = new ArrayList<BundleInfoImpl>();
        Iterator i = this.m_index.iterator();
        while (i.hasNext()) {
            BundleInfoImpl bundleInfo = this.getBundleInfoByPath((String)i.next());
            if (bundleInfo == null) continue;
            result.add(bundleInfo);
        }
        return result.toArray(new BundleInfoImpl[result.size()]);
    }

    public InputStream getBundleStream(String symbolicName) throws IOException {
        BundleInfoImpl bundleInfo = this.getBundleInfoByName(symbolicName);
        if (bundleInfo != null) {
            return new GZIPInputStream(new FileInputStream(new File(this.m_contentsDir, bundleInfo.getPath())));
        }
        return null;
    }

    public ResourceInfoImpl[] getOrderedResourceInfos() {
        ArrayList<ResourceInfoImpl> result = new ArrayList<ResourceInfoImpl>();
        Iterator i = this.m_index.iterator();
        while (i.hasNext()) {
            ResourceInfoImpl resourceInfo = this.getResourceInfoByPath((String)i.next());
            if (resourceInfo == null) continue;
            result.add(resourceInfo);
        }
        return result.toArray(new ResourceInfoImpl[result.size()]);
    }

    public InputStream getCurrentEntryStream() {
        throw new UnsupportedOperationException("Not implemented for file-based deployment package");
    }

    public AbstractInfo getNextEntry() throws IOException {
        throw new UnsupportedOperationException("Not implemented for file-based deployment package");
    }
}

