/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.join;

import java.util.Map;
import java.util.Objects;
import org.eclipse.kura.wire.graph.BarrierAggregatorFactory;
import org.eclipse.kura.wire.graph.CachingAggregatorFactory;
import org.eclipse.kura.wire.graph.PortAggregatorFactory;
import org.osgi.framework.BundleContext;

public class JoinComponentOptions {
    private static final String BARRIER_MODALITY_PROPERTY_KEY = "barrier";
    private static final boolean BARRIER_MODALITY_PROPERTY_DEFAULT = true;
    private final Map<String, Object> properties;
    private final BundleContext context;

    JoinComponentOptions(Map<String, Object> properties, BundleContext context) {
        Objects.requireNonNull(properties, "Properties must be not null");
        this.properties = properties;
        this.context = context;
    }

    PortAggregatorFactory getPortAggregatorFactory() {
        boolean useBarrier = (Boolean)this.properties.getOrDefault(BARRIER_MODALITY_PROPERTY_KEY, true);
        if (useBarrier) {
            return (PortAggregatorFactory)this.context.getService(this.context.getServiceReference(BarrierAggregatorFactory.class));
        }
        return (PortAggregatorFactory)this.context.getService(this.context.getServiceReference(CachingAggregatorFactory.class));
    }
}

