/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.asset;

import java.util.Map;
import org.eclipse.kura.internal.wire.asset.TimestampMode;

class WireAssetOptions {
    public static final String EMIT_ALL_CHANNELS_PROP_NAME = "emit.all.channels";
    public static final String TIMESTAMP_MODE_PROP_NAME = "timestamp.mode";
    public static final String EMIT_ERRORS_PROP_NAME = "emit.errors";
    private boolean emitAllChannels;
    private TimestampMode timestampMode;
    private boolean emitErrors;

    public WireAssetOptions() {
    }

    public WireAssetOptions(Map<String, Object> properties) {
        Object emitAllChannels = properties.get(EMIT_ALL_CHANNELS_PROP_NAME);
        Object emitErrors = properties.get(EMIT_ERRORS_PROP_NAME);
        this.emitAllChannels = emitAllChannels instanceof Boolean && (Boolean)emitAllChannels != false;
        this.emitErrors = emitErrors instanceof Boolean && (Boolean)emitErrors != false;
        this.timestampMode = WireAssetOptions.extractTimestampMode(properties);
    }

    public boolean emitAllChannels() {
        return this.emitAllChannels;
    }

    public TimestampMode getTimestampMode() {
        return this.timestampMode;
    }

    public boolean emitErrors() {
        return this.emitErrors;
    }

    private static TimestampMode extractTimestampMode(Map<String, Object> properties) {
        try {
            return TimestampMode.valueOf(properties.get(TIMESTAMP_MODE_PROP_NAME).toString());
        }
        catch (Exception exception) {
            return TimestampMode.PER_CHANNEL;
        }
    }
}

