/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl.ssl;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.qpid.proton.engine.SslDomain;
import org.apache.qpid.proton.engine.SslPeerDetails;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.impl.ssl.DefaultSslEngineFacade;
import org.apache.qpid.proton.engine.impl.ssl.ProtonSslEngine;

public class SslEngineFacadeFactory {
    private static final Logger _logger = Logger.getLogger(SslEngineFacadeFactory.class.getName());
    private static final String TLS_PROTOCOL = "TLS";
    private static final Constructor<?> pemParserCons;
    private static final Method pemReadMethod;
    private static final Constructor<?> JcaPEMKeyConverterCons;
    private static final Class<?> PEMKeyPairClass;
    private static final Method getKeyPairMethod;
    private static final Method getPrivateKeyMethod;
    private static final Class<?> PEMEncryptedKeyPairClass;
    private static final Method decryptKeyPairMethod;
    private static final Constructor<?> JcePEMDecryptorProviderBuilderCons;
    private static final Method builderMethod;
    private static final Class<?> PrivateKeyInfoClass;
    private static final Exception bouncyCastleSetupException;
    private static final List<String> ANONYMOUS_CIPHER_SUITES;
    private SSLContext _sslContext;
    private static final String SSLV3_PROTOCOL = "SSLv3";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerBouncyCastleProvider() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> klass = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
        Provider bouncyCastleProvider = (Provider)klass.getConstructor(new Class[0]).newInstance(new Object[0]);
        Class<Security> clazz = Security.class;
        synchronized (Security.class) {
            if (Security.getProvider(bouncyCastleProvider.getName()) == null) {
                Security.addProvider(bouncyCastleProvider);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    SslEngineFacadeFactory() {
    }

    public ProtonSslEngine createProtonSslEngine(SslDomain domain, SslPeerDetails peerDetails) {
        SSLEngine engine = this.createAndInitialiseSslEngine(domain, peerDetails);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Created SSL engine: " + this.engineToString(engine));
        }
        return new DefaultSslEngineFacade(engine);
    }

    public void resetCache() {
        this._sslContext = null;
    }

    private SSLEngine createAndInitialiseSslEngine(SslDomain domain, SslPeerDetails peerDetails) {
        SslDomain.Mode mode = domain.getMode();
        SSLContext sslContext = this.getOrCreateSslContext(domain);
        SSLEngine sslEngine = this.createSslEngine(sslContext, peerDetails);
        if (domain.getPeerAuthentication() == SslDomain.VerifyMode.ANONYMOUS_PEER) {
            this.addAnonymousCipherSuites(sslEngine);
        } else if (mode == SslDomain.Mode.SERVER) {
            sslEngine.setNeedClientAuth(true);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, (Object)((Object)mode) + " Enabled cipher suites " + Arrays.asList(sslEngine.getEnabledCipherSuites()));
        }
        boolean useClientMode = mode == SslDomain.Mode.CLIENT;
        sslEngine.setUseClientMode(useClientMode);
        SslEngineFacadeFactory.removeSSLv3Support(sslEngine);
        return sslEngine;
    }

    private static void removeSSLv3Support(SSLEngine engine) {
        List<String> enabledProtocols = Arrays.asList(engine.getEnabledProtocols());
        if (enabledProtocols.contains(SSLV3_PROTOCOL)) {
            ArrayList<String> allowedProtocols = new ArrayList<String>(enabledProtocols);
            allowedProtocols.remove(SSLV3_PROTOCOL);
            engine.setEnabledProtocols(allowedProtocols.toArray(new String[allowedProtocols.size()]));
        }
    }

    private SSLEngine createSslEngine(SSLContext sslContext, SslPeerDetails sslPeerDetails) {
        SSLEngine sslEngine = sslPeerDetails == null ? sslContext.createSSLEngine() : sslContext.createSSLEngine(sslPeerDetails.getHostname(), sslPeerDetails.getPort());
        return sslEngine;
    }

    private SSLContext getOrCreateSslContext(SslDomain sslDomain) {
        if (this._sslContext == null && sslDomain.getSslContext() != null) {
            this._sslContext = sslDomain.getSslContext();
        } else if (this._sslContext == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("lazily creating new SSLContext using domain " + sslDomain);
            }
            char[] dummyPassword = "unused-passphrase".toCharArray();
            try {
                TrustManager[] trustManagers;
                SSLContext sslContext = SSLContext.getInstance(TLS_PROTOCOL);
                KeyStore ksKeys = this.createKeyStoreFrom(sslDomain, dummyPassword);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(ksKeys, dummyPassword);
                if (sslDomain.getPeerAuthentication() == SslDomain.VerifyMode.ANONYMOUS_PEER) {
                    trustManagers = new TrustManager[]{new AlwaysTrustingTrustManager()};
                } else {
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(ksKeys);
                    trustManagers = tmf.getTrustManagers();
                }
                sslContext.init(kmf.getKeyManagers(), trustManagers, null);
                this._sslContext = sslContext;
            }
            catch (NoSuchAlgorithmException e) {
                throw new TransportException("Unexpected exception creating SSLContext", e);
            }
            catch (KeyStoreException e) {
                throw new TransportException("Unexpected exception creating SSLContext", e);
            }
            catch (UnrecoverableKeyException e) {
                throw new TransportException("Unexpected exception creating SSLContext", e);
            }
            catch (KeyManagementException e) {
                throw new TransportException("Unexpected exception creating SSLContext", e);
            }
        }
        return this._sslContext;
    }

    private KeyStore createKeyStoreFrom(SslDomain sslDomain, char[] dummyPassword) {
        try {
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(null, null);
            if (sslDomain.getTrustedCaDb() != null) {
                String caCertAlias = "cacert";
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "_sslParams.getTrustedCaDb() : " + sslDomain.getTrustedCaDb());
                }
                int i = 1;
                for (Certificate certificate : this.readCertificates(sslDomain.getTrustedCaDb())) {
                    keystore.setCertificateEntry(caCertAlias + i++, certificate);
                }
            }
            if (sslDomain.getCertificateFile() != null && sslDomain.getPrivateKeyFile() != null) {
                String clientPrivateKeyAlias = "clientPrivateKey";
                Certificate clientCertificate = this.readCertificate(sslDomain.getCertificateFile());
                PrivateKey clientPrivateKey = this.readPrivateKey(sslDomain.getPrivateKeyFile(), sslDomain.getPrivateKeyPassword());
                keystore.setKeyEntry(clientPrivateKeyAlias, clientPrivateKey, dummyPassword, new Certificate[]{clientCertificate});
            }
            return keystore;
        }
        catch (KeyStoreException e) {
            throw new TransportException("Unexpected exception creating keystore", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TransportException("Unexpected exception creating keystore", e);
        }
        catch (CertificateException e) {
            throw new TransportException("Unexpected exception creating keystore", e);
        }
        catch (IOException e) {
            throw new TransportException("Unexpected exception creating keystore", e);
        }
    }

    private void addAnonymousCipherSuites(SSLEngine sslEngine) {
        List<String> supportedSuites = Arrays.asList(sslEngine.getSupportedCipherSuites());
        List<String> currentEnabledSuites = Arrays.asList(sslEngine.getEnabledCipherSuites());
        List<String> enabledSuites = this.buildEnabledSuitesIncludingAnonymous(ANONYMOUS_CIPHER_SUITES, supportedSuites, currentEnabledSuites);
        sslEngine.setEnabledCipherSuites(enabledSuites.toArray(new String[0]));
    }

    private List<String> buildEnabledSuitesIncludingAnonymous(List<String> anonymousCipherSuites, List<String> supportedSuites, List<String> currentEnabled) {
        ArrayList<String> newEnabled = new ArrayList<String>(currentEnabled);
        int addedAnonymousCipherSuites = 0;
        for (String anonymousCipherSuiteName : anonymousCipherSuites) {
            if (!supportedSuites.contains(anonymousCipherSuiteName)) continue;
            newEnabled.add(anonymousCipherSuiteName);
            ++addedAnonymousCipherSuites;
        }
        if (addedAnonymousCipherSuites > 0 && _logger.isLoggable(Level.FINE)) {
            _logger.fine("There are now " + newEnabled.size() + " cipher suites enabled (previously " + currentEnabled.size() + "), including " + addedAnonymousCipherSuites + " out of the " + anonymousCipherSuites.size() + " requested anonymous ones.");
        }
        return newEnabled;
    }

    private String engineToString(SSLEngine engine) {
        return "[ " + engine + ", needClientAuth=" + engine.getNeedClientAuth() + ", useClientMode=" + engine.getUseClientMode() + ", peerHost=" + engine.getPeerHost() + ", peerPort=" + engine.getPeerPort() + " ]";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Certificate readCertificate(String pemFile) {
        FileInputStream is = null;
        try {
            CertificateFactory cFactory = CertificateFactory.getInstance("X.509");
            is = new FileInputStream(pemFile);
            Certificate certificate = cFactory.generateCertificate(is);
            this.closeSafely(is);
            return certificate;
        }
        catch (CertificateException ce) {
            try {
                String msg = "Failed to load certificate [" + pemFile + "]";
                _logger.log(Level.SEVERE, msg, ce);
                throw new TransportException(msg, ce);
                catch (FileNotFoundException e) {
                    msg = "Certificate file not found [" + pemFile + "]";
                    _logger.log(Level.SEVERE, msg);
                    throw new TransportException(msg, e);
                }
            }
            catch (Throwable throwable) {
                this.closeSafely(is);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Collection<? extends Certificate> readCertificates(String pemFile) {
        FileInputStream is = null;
        try {
            CertificateFactory cFactory = CertificateFactory.getInstance("X.509");
            is = new FileInputStream(pemFile);
            Collection<? extends Certificate> collection = cFactory.generateCertificates(is);
            this.closeSafely(is);
            return collection;
        }
        catch (CertificateException ce) {
            try {
                String msg = "Failed to load certificates [" + pemFile + "]";
                _logger.log(Level.SEVERE, msg, ce);
                throw new TransportException(msg, ce);
                catch (FileNotFoundException e) {
                    msg = "Certificates file not found [" + pemFile + "]";
                    _logger.log(Level.SEVERE, msg);
                    throw new TransportException(msg, e);
                }
            }
            catch (Throwable throwable) {
                this.closeSafely(is);
                throw throwable;
            }
        }
    }

    PrivateKey readPrivateKey(String pemFile, String password) {
        PrivateKey privateKey;
        block6: {
            if (bouncyCastleSetupException != null) {
                throw new TransportException("BouncyCastle failed to load", bouncyCastleSetupException);
            }
            Object pemObject = this.readPemObject(pemFile);
            privateKey = null;
            try {
                Object keyConverter = JcaPEMKeyConverterCons.newInstance(new Object[0]);
                this.setProvider(keyConverter, "BC");
                if (PEMEncryptedKeyPairClass.isInstance(pemObject)) {
                    Object decryptorBuilder = JcePEMDecryptorProviderBuilderCons.newInstance(new Object[0]);
                    Object decryptProvider = builderMethod.invoke(decryptorBuilder, new Object[]{password.toCharArray()});
                    Object decryptedKeyPair = decryptKeyPairMethod.invoke(pemObject, decryptProvider);
                    KeyPair keyPair = (KeyPair)getKeyPairMethod.invoke(keyConverter, decryptedKeyPair);
                    privateKey = keyPair.getPrivate();
                    break block6;
                }
                if (PEMKeyPairClass.isInstance(pemObject)) {
                    KeyPair keyPair = (KeyPair)getKeyPairMethod.invoke(keyConverter, pemObject);
                    privateKey = keyPair.getPrivate();
                    break block6;
                }
                if (PrivateKeyInfoClass.isInstance(pemObject)) {
                    privateKey = (PrivateKey)getPrivateKeyMethod.invoke(keyConverter, pemObject);
                    break block6;
                }
                String msg = "Unable to load PrivateKey, Unpexected Object [" + pemObject.getClass().getName() + "]";
                _logger.log(Level.SEVERE, msg);
                throw new TransportException(msg);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                String msg = "Failed to process key file [" + pemFile + "] - " + e.getMessage();
                throw new TransportException(msg, e);
            }
        }
        return privateKey;
    }

    private Object readPemObject(String pemFile) {
        FileReader reader = null;
        Object pemParser = null;
        Object pemObject = null;
        try {
            reader = new FileReader(pemFile);
            pemParser = pemParserCons.newInstance(reader);
            pemObject = pemReadMethod.invoke(pemParser, new Object[0]);
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            _logger.log(Level.SEVERE, "Unable to read PEM object. Perhaps you need the unlimited strength libraries in <java-home>/jre/lib/security/ ?", e);
            throw new TransportException("Unable to read PEM object from file " + pemFile, e);
        }
        finally {
            this.closeSafely(reader);
        }
        return pemObject;
    }

    private void setProvider(Object obj, String provider) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Class<?> aClz = obj.getClass();
        Method setProvider = aClz.getMethod("setProvider", String.class);
        setProvider.invoke(obj, provider);
    }

    private void closeSafely(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Constructor<?> pemParserConsResult = null;
        Method pemReadMethodResult = null;
        Constructor<?> JcaPEMKeyConverterConsResult = null;
        Class<?> PEMKeyPairClassResult = null;
        Method getKeyPairMethodResult = null;
        Method getPrivateKeyMethodResult = null;
        Class<?> PEMEncryptedKeyPairClassResult = null;
        Method decryptKeyPairMethodResult = null;
        Constructor<?> JcePEMDecryptorProviderBuilderConsResult = null;
        Method builderMethodResult = null;
        Class<?> PrivateKeyInfoClassResult = null;
        Exception bouncyCastleSetupExceptionResult = null;
        try {
            Class<?> pemParserClass = Class.forName("org.bouncycastle.openssl.PEMParser");
            pemParserConsResult = pemParserClass.getConstructor(Reader.class);
            pemReadMethodResult = pemParserClass.getMethod("readObject", new Class[0]);
            Class<?> jcaPEMKeyConverterClass = Class.forName("org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter");
            JcaPEMKeyConverterConsResult = jcaPEMKeyConverterClass.getConstructor(new Class[0]);
            PEMKeyPairClassResult = Class.forName("org.bouncycastle.openssl.PEMKeyPair");
            getKeyPairMethodResult = jcaPEMKeyConverterClass.getMethod("getKeyPair", PEMKeyPairClassResult);
            Class<?> PEMDecrypterProvider = Class.forName("org.bouncycastle.openssl.PEMDecryptorProvider");
            PEMEncryptedKeyPairClassResult = Class.forName("org.bouncycastle.openssl.PEMEncryptedKeyPair");
            decryptKeyPairMethodResult = PEMEncryptedKeyPairClassResult.getMethod("decryptKeyPair", PEMDecrypterProvider);
            Class<?> jcePEMDecryptorProviderBuilderClass = Class.forName("org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder");
            JcePEMDecryptorProviderBuilderConsResult = jcePEMDecryptorProviderBuilderClass.getConstructor(new Class[0]);
            builderMethodResult = jcePEMDecryptorProviderBuilderClass.getMethod("build", char[].class);
            PrivateKeyInfoClassResult = Class.forName("org.bouncycastle.asn1.pkcs.PrivateKeyInfo");
            getPrivateKeyMethodResult = jcaPEMKeyConverterClass.getMethod("getPrivateKey", PrivateKeyInfoClassResult);
            SslEngineFacadeFactory.registerBouncyCastleProvider();
        }
        catch (Exception e) {
            bouncyCastleSetupExceptionResult = e;
        }
        finally {
            pemParserCons = pemParserConsResult;
            pemReadMethod = pemReadMethodResult;
            JcaPEMKeyConverterCons = JcaPEMKeyConverterConsResult;
            PEMKeyPairClass = PEMKeyPairClassResult;
            getKeyPairMethod = getKeyPairMethodResult;
            getPrivateKeyMethod = getPrivateKeyMethodResult;
            PEMEncryptedKeyPairClass = PEMEncryptedKeyPairClassResult;
            decryptKeyPairMethod = decryptKeyPairMethodResult;
            JcePEMDecryptorProviderBuilderCons = JcePEMDecryptorProviderBuilderConsResult;
            builderMethod = builderMethodResult;
            PrivateKeyInfoClass = PrivateKeyInfoClassResult;
            bouncyCastleSetupException = bouncyCastleSetupExceptionResult;
        }
        ANONYMOUS_CIPHER_SUITES = Arrays.asList("TLS_DH_anon_WITH_AES_128_CBC_SHA", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA");
    }

    private static final class AlwaysTrustingTrustManager
    implements X509TrustManager {
        private AlwaysTrustingTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }
    }
}

