/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ip.provider.http;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.internal.ip.ProvisioningInfoProvider;
import org.eclipse.equinox.internal.ip.impl.Log;
import org.eclipse.equinox.internal.ip.impl.ProvisioningAgent;
import org.eclipse.equinox.internal.ip.provider.BaseProvider;
import org.eclipse.equinox.internal.ip.provider.http.Context;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.provisioning.ProvisioningService;
import org.osgi.service.useradmin.Authorization;
import org.osgi.service.useradmin.User;
import org.osgi.service.useradmin.UserAdmin;

public class HttpProvider
extends BaseProvider
implements ProvisioningInfoProvider,
ServiceListener {
    public static final String ALIAS = "/rminit";
    public static final String HTTP_SUPPORT = "equinox.provisioning.http.provider.allowed";
    public static final String SECURE = "equinox.provisioning.http.provider.secure";
    public static final String REQUIRE_AUTH = "equinox.provisioning.require.auth";
    static boolean secure;
    ProvisioningService prvSrv;
    private BundleContext bc;
    private HttpService http;
    private HttpServlet servlet = new HttpServletImpl();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void start(BundleContext bc) throws Exception {
        boolean httpsupport = true;
        if (bc.getProperty(HTTP_SUPPORT) != null && bc.getProperty(HTTP_SUPPORT).equals("false")) {
            httpsupport = false;
        }
        if (!httpsupport) {
            Log.debug(this + " is not an allowed provider.");
            return;
        }
        this.bc = bc;
        super.start(bc);
    }

    public void stop(BundleContext bc) {
        super.stop(bc);
        if (this.http != null) {
            try {
                this.http.unregister(ALIAS);
            }
            catch (Exception exception) {}
            this.http = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary init(ProvisioningService prvSrv) {
        this.prvSrv = prvSrv;
        secure = false;
        if (ProvisioningAgent.bc.getProperty(SECURE) != null && ProvisioningAgent.bc.getProperty(SECURE).equals("true")) {
            secure = true;
        }
        try {
            StringBuffer stringBuffer = new StringBuffer("(objectClass=");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.service.http.HttpService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.bc.addServiceListener((ServiceListener)this, stringBuffer.append(clazz.getName()).append(')').toString());
        }
        catch (Exception e) {
            Log.debug(e);
        }
        HttpProvider httpProvider = this;
        synchronized (httpProvider) {
            if (this.http == null) {
                ServiceReference sref;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.osgi.service.http.HttpService");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((sref = this.bc.getServiceReference(clazz.getName())) != null) {
                    this.http = (HttpService)this.bc.getService(sref);
                    this.registerServlet();
                }
            }
        }
        return null;
    }

    public Object get(Object key) {
        return null;
    }

    public synchronized void serviceChanged(ServiceEvent se) {
        if (se.getType() == 1) {
            if (this.http == null) {
                this.http = (HttpService)this.bc.getService(se.getServiceReference());
                this.registerServlet();
            }
        } else if (se.getType() == 4 && this.http != null) {
            ServiceReference sref;
            try {
                this.http.unregister(ALIAS);
            }
            catch (Exception exception) {}
            this.http = null;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.service.http.HttpService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((sref = this.bc.getServiceReference(clazz.getName())) != null) {
                this.http = (HttpService)this.bc.getService(sref);
                this.registerServlet();
            }
        }
    }

    private void registerServlet() {
        try {
            this.http.registerServlet(ALIAS, (Servlet)this.servlet, null, (HttpContext)Context.getInstance());
            Log.debug("Servlet \"/rminit\" registered.");
        }
        catch (Exception e) {
            Log.debug("Error registering HTTP provider servlet!", e);
        }
    }

    public String toString() {
        return "Http";
    }

    boolean checkAccount(String user, String pass) {
        ServiceReference sref;
        if (user == null || pass == null) {
            return false;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.osgi.service.useradmin.UserAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((sref = this.bc.getServiceReference(clazz.getName())) == null) {
            return false;
        }
        UserAdmin userAdmin = (UserAdmin)this.bc.getService(sref);
        if (userAdmin != null) {
            try {
                User userRole = (User)userAdmin.getRole(user);
                if (userRole != null && userRole.hasCredential("password", (Object)pass)) {
                    Authorization authorization = userAdmin.getAuthorization(userRole);
                    return authorization.hasRole("administration");
                }
            }
            catch (Exception e) {
                Log.debug(e);
            }
        }
        return false;
    }

    class HttpServletImpl
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        HttpServletImpl() {
        }

        public void doGet(HttpServletRequest request, HttpServletResponse response) {
            Log.debug("doGet ...");
            if (request.getHeader("Get-Id") == null) {
                Log.debug("Redirect to doPost.");
                this.doPost(request, response);
            } else {
                Log.debug("Request for spid.");
                if (secure && !request.getScheme().equals("https")) {
                    Log.debug("Request to secure HttpLoader must be via https!");
                    response.setHeader("error", "Request to secure HttpLoader must be via https!");
                    response.setStatus(200);
                    return;
                }
                String spid = (String)HttpProvider.this.prvSrv.getInformation().get("provisioning.spid");
                if (spid != null && spid.length() != 0) {
                    response.setHeader("Gw-Id", spid);
                }
                response.setStatus(200);
            }
        }

        public void doPost(HttpServletRequest request, HttpServletResponse response) {
            Log.debug("doPost ...");
            if (secure && !request.getScheme().equals("https")) {
                Log.debug("Request to secure HttpLoader must be via https!");
                response.setHeader("error", "Request to secure HttpLoader must be via https!");
                response.setStatus(200);
                return;
            }
            String user = request.getParameter("user");
            String pass = request.getParameter("pass");
            boolean req_auth = false;
            if (ProvisioningAgent.bc.getProperty(HttpProvider.REQUIRE_AUTH) != null && ProvisioningAgent.bc.getProperty(HttpProvider.REQUIRE_AUTH).equals("true")) {
                req_auth = true;
            }
            if (!req_auth && !HttpProvider.this.checkAccount(user, pass)) {
                Log.debug("Incorrect Account!");
                response.setHeader("error", "Incorrect account!");
                return;
            }
            Hashtable<String, String> info = new Hashtable<String, String>();
            Log.debug("HttpLoader loads:");
            Enumeration e = request.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if ("user".equals(name) || "pass".equals(name)) continue;
                String param = request.getParameter(name);
                if ("equinox.provisioning.gm.host".equals(name) && "no".equals(param)) continue;
                Log.debug("  " + name + '=' + param);
                ((Dictionary)info).put(name, param);
            }
            HttpProvider.this.prvSrv.addInformation(info);
            response.setStatus(200);
        }
    }
}

