/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.rpc;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.tigris.mtoolkit.iagent.event.EventSynchronizer;
import org.tigris.mtoolkit.iagent.internal.VMCommander;
import org.tigris.mtoolkit.iagent.internal.rpc.EventSynchronizerImpl;
import org.tigris.mtoolkit.iagent.internal.rpc.RemoteApplicationAdminImpl;
import org.tigris.mtoolkit.iagent.internal.rpc.RemoteBundleAdminImpl;
import org.tigris.mtoolkit.iagent.internal.rpc.RemoteCapabilitiesManagerImpl;
import org.tigris.mtoolkit.iagent.internal.rpc.RemoteDeploymentAdminImpl;
import org.tigris.mtoolkit.iagent.internal.rpc.RemoteServiceAdminImpl;
import org.tigris.mtoolkit.iagent.internal.rpc.console.EquinoxRemoteConsole;
import org.tigris.mtoolkit.iagent.internal.rpc.console.ProSystRemoteConsole;
import org.tigris.mtoolkit.iagent.internal.rpc.console.RemoteConsoleServiceBase;
import org.tigris.mtoolkit.iagent.internal.utils.DebugUtils;
import org.tigris.mtoolkit.iagent.pmp.PMPServer;
import org.tigris.mtoolkit.iagent.pmp.PMPServerFactory;
import org.tigris.mtoolkit.iagent.pmp.PMPServiceFactory;
import org.tigris.mtoolkit.iagent.rpc.RemoteCapabilitiesManager;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer,
FrameworkListener {
    private static final String DEPLOYMENT_ADMIN_CLASS = "org.osgi.service.deploymentadmin.DeploymentAdmin";
    private static final String EVENT_ADMIN_CLASS = "org.osgi.service.event.EventAdmin";
    private RemoteBundleAdminImpl bundleAdmin;
    private RemoteApplicationAdminImpl applicationAdmin;
    private RemoteDeploymentAdminImpl deploymentAdmin;
    private RemoteServiceAdminImpl serviceAdmin;
    private RemoteConsoleServiceBase console;
    private PMPServer pmpServer;
    private ServiceRegistration pmpServiceReg;
    private ServiceRegistration pmpServerReg;
    private BundleContext context;
    private static Activator instance;
    private EventSynchronizerImpl synchronizer;
    private VMCommander vmCommander;
    private RemoteCapabilitiesManagerImpl capabilitiesManager;
    private ServiceTracker deploymentAdminTrack;
    private ServiceTracker eventAdminTracker;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void start(BundleContext context) throws Exception {
        boolean registerVMController;
        this.context = context;
        instance = this;
        DebugUtils.initialize(context);
        this.synchronizer = new EventSynchronizerImpl(context);
        this.capabilitiesManager = new RemoteCapabilitiesManagerImpl();
        this.capabilitiesManager.register(context);
        this.bundleAdmin = new RemoteBundleAdminImpl();
        this.bundleAdmin.register(context);
        this.registerApplicationAdmin(context);
        this.deploymentAdminTrack = new ServiceTracker(context, DEPLOYMENT_ADMIN_CLASS, (ServiceTrackerCustomizer)this);
        this.deploymentAdminTrack.open(true);
        this.eventAdminTracker = new ServiceTracker(context, EVENT_ADMIN_CLASS, (ServiceTrackerCustomizer)this);
        this.eventAdminTracker.open(true);
        this.serviceAdmin = new RemoteServiceAdminImpl();
        this.serviceAdmin.register(context);
        this.registerConsole(context);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.tigris.mtoolkit.iagent.pmp.PMPService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.pmpServiceReg = context.registerService(clazz.getName(), (Object)PMPServiceFactory.getDefault(), null);
        this.pmpServer = PMPServerFactory.createServer(context, 1450, null);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.tigris.mtoolkit.iagent.pmp.PMPServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.pmpServerReg = context.registerService(clazz2.getName(), (Object)this.pmpServer, null);
        this.synchronizer.setPMPServer(this.pmpServer);
        this.synchronizer.start();
        boolean bl = registerVMController = !"false".equals(System.getProperty("iagent.controller"));
        if (registerVMController) {
            this.registerControllerSupport(context);
        }
    }

    private void registerControllerSupport(BundleContext context) {
        Bundle sysBundle = context.getBundle(0L);
        switch (sysBundle.getState()) {
            case 32: {
                this.startController(context);
                break;
            }
            case 8: {
                context.addFrameworkListener((FrameworkListener)this);
            }
        }
    }

    private void startController(BundleContext context) {
        boolean shutdownOnDisconnect = Boolean.getBoolean("iagent.shutdownOnDisconnect");
        this.vmCommander = new VMCommander(context, this.pmpServer, shutdownOnDisconnect);
    }

    private void registerConsole(BundleContext context) {
        try {
            this.console = new EquinoxRemoteConsole();
            this.console.register(context);
            return;
        }
        catch (Throwable throwable) {
            this.console = null;
            try {
                this.console = new ProSystRemoteConsole();
                this.console.register(context);
                return;
            }
            catch (Throwable throwable2) {
                this.console = null;
                return;
            }
        }
    }

    private void unregisterConsole() {
        if (this.console != null) {
            this.console.unregister();
        }
    }

    private void registerApplicationAdmin(BundleContext context) {
        try {
            this.applicationAdmin = new RemoteApplicationAdminImpl();
            this.applicationAdmin.register(context);
        }
        catch (Throwable throwable) {
            this.applicationAdmin = null;
        }
    }

    private void unregisterApplicationAdmin(BundleContext context) {
        if (this.applicationAdmin != null) {
            this.applicationAdmin.unregister(context);
            this.applicationAdmin = null;
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.unregisterConsole();
        this.pmpServerReg.unregister();
        this.pmpServer.close();
        this.pmpServiceReg.unregister();
        if (this.synchronizer != null) {
            this.synchronizer.stopDispatching();
            this.synchronizer.unregister(context);
        }
        if (this.bundleAdmin != null) {
            this.bundleAdmin.unregister(context);
            this.bundleAdmin = null;
        }
        this.unregisterApplicationAdmin(context);
        if (this.deploymentAdminTrack != null) {
            this.deploymentAdminTrack.close();
            this.deploymentAdminTrack = null;
        }
        if (this.eventAdminTracker != null) {
            this.eventAdminTracker.close();
            this.eventAdminTracker = null;
        }
        if (this.serviceAdmin != null) {
            this.serviceAdmin.unregister(context);
            this.serviceAdmin = null;
        }
        if (this.vmCommander != null) {
            context.removeFrameworkListener((FrameworkListener)this);
            this.vmCommander.close();
            this.vmCommander = null;
        }
        if (this.capabilitiesManager != null) {
            this.capabilitiesManager.unregister(context);
            this.capabilitiesManager = null;
        }
        instance = null;
        this.context = null;
    }

    private boolean registerDeploymentAdmin(Object admin) {
        if (this.deploymentAdmin == null) {
            try {
                this.deploymentAdmin = new RemoteDeploymentAdminImpl();
                this.deploymentAdmin.register(this.context, admin);
                return true;
            }
            catch (Throwable throwable) {
                this.deploymentAdmin = null;
                return false;
            }
        }
        return false;
    }

    private boolean unregisterDeploymentAdmin(Object admin) {
        if (this.deploymentAdmin != null && this.deploymentAdmin.getDeploymentAdmin() == admin) {
            this.deploymentAdmin.unregister(this.context);
            this.deploymentAdmin = null;
            return true;
        }
        return false;
    }

    public Object addingService(ServiceReference arg0) {
        String[] classes = (String[])arg0.getProperty("objectClass");
        int i = 0;
        while (i < classes.length) {
            if (classes[i].equals(DEPLOYMENT_ADMIN_CLASS)) {
                Object admin = this.context.getService(arg0);
                this.registerDeploymentAdmin(admin);
                return admin;
            }
            if (classes[i].equals(EVENT_ADMIN_CLASS)) {
                this.setCapability("remote.event.support", true);
                return new Object();
            }
            ++i;
        }
        return null;
    }

    public void modifiedService(ServiceReference arg0, Object arg1) {
    }

    public void removedService(ServiceReference ref, Object obj) {
        String[] classes = (String[])ref.getProperty("objectClass");
        int i = 0;
        while (i < classes.length) {
            if (classes[i].equals(DEPLOYMENT_ADMIN_CLASS)) {
                Object admin;
                if (this.unregisterDeploymentAdmin(obj) && (admin = this.deploymentAdminTrack.getService()) != null) {
                    this.registerDeploymentAdmin(admin);
                }
            } else if (classes[i].equals(EVENT_ADMIN_CLASS) && this.eventAdminTracker.getService() == null) {
                this.setCapability("remote.event.support", false);
            }
            ++i;
        }
    }

    public static EventSynchronizer getSynchronizer() {
        return instance != null ? Activator.instance.synchronizer : null;
    }

    public static RemoteCapabilitiesManager getCapabilitiesManager() {
        return instance != null ? Activator.instance.capabilitiesManager : null;
    }

    private void setCapability(String capability, boolean value) {
        if (this.capabilitiesManager != null) {
            this.capabilitiesManager.setCapability(capability, new Boolean(value));
        }
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 1) {
            this.startController(this.context);
        }
    }
}

