/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest;

import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.beans.HasProperty;
import org.hamcrest.beans.HasPropertyWithValue;
import org.hamcrest.collection.IsArrayContaining;
import org.hamcrest.collection.IsCollectionContaining;
import org.hamcrest.collection.IsIn;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.AnyOf;
import org.hamcrest.core.DescribedAs;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsAnything;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.hamcrest.number.IsCloseTo;
import org.hamcrest.number.OrderingComparisons;
import org.hamcrest.object.HasToString;
import org.hamcrest.object.IsCompatibleType;
import org.hamcrest.object.IsEventFrom;
import org.hamcrest.text.IsEqualIgnoringCase;
import org.hamcrest.text.IsEqualIgnoringWhiteSpace;
import org.hamcrest.text.StringContains;
import org.hamcrest.text.StringEndsWith;
import org.hamcrest.text.StringStartsWith;
import org.hamcrest.xml.HasXPath;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Matchers {
    public static <T> Matcher<T> is(Matcher<T> matcher) {
        return Is.is(matcher);
    }

    public static <T> Matcher<T> is(T value) {
        return Is.is(value);
    }

    public static Matcher<Object> is(Class<?> type) {
        return Is.is(type);
    }

    public static <T> Matcher<T> not(Matcher<T> matcher) {
        return IsNot.not(matcher);
    }

    public static <T> Matcher<T> not(T value) {
        return IsNot.not(value);
    }

    public static <T> Matcher<T> equalTo(T operand) {
        return IsEqual.equalTo(operand);
    }

    public static Matcher<Object> instanceOf(Class<?> type) {
        return IsInstanceOf.instanceOf(type);
    }

    public static <T> Matcher<T> allOf(Matcher<? extends T> ... matchers) {
        return AllOf.allOf(matchers);
    }

    public static <T> Matcher<T> allOf(Iterable<Matcher<? extends T>> matchers) {
        return AllOf.allOf(matchers);
    }

    public static <T> Matcher<T> anyOf(Matcher<? extends T> ... matchers) {
        return AnyOf.anyOf(matchers);
    }

    public static <T> Matcher<T> anyOf(Iterable<Matcher<? extends T>> matchers) {
        return AnyOf.anyOf(matchers);
    }

    public static <T> Matcher<T> sameInstance(T object) {
        return IsSame.sameInstance(object);
    }

    public static <T> Matcher<T> anything() {
        return IsAnything.anything();
    }

    public static <T> Matcher<T> anything(String description) {
        return IsAnything.anything((String)description);
    }

    public static <T> Matcher<T> any(Class<T> type) {
        return IsAnything.any(type);
    }

    public static <T> Matcher<T> nullValue() {
        return IsNull.nullValue();
    }

    public static <T> Matcher<T> nullValue(Class<T> type) {
        return IsNull.nullValue(type);
    }

    public static <T> Matcher<T> notNullValue() {
        return IsNull.notNullValue();
    }

    public static <T> Matcher<T> notNullValue(Class<T> type) {
        return IsNull.notNullValue(type);
    }

    public static <T> Matcher<T> describedAs(String description, Matcher<T> matcher, Object ... values) {
        return DescribedAs.describedAs((String)description, matcher, (Object[])values);
    }

    public static <T> Matcher<T[]> hasItemInArray(Matcher<T> elementMatcher) {
        return IsArrayContaining.hasItemInArray(elementMatcher);
    }

    public static <T> Matcher<T[]> hasItemInArray(T element) {
        return IsArrayContaining.hasItemInArray(element);
    }

    public static <T> Matcher<Iterable<T>> hasItem(T element) {
        return IsCollectionContaining.hasItem(element);
    }

    public static <T> Matcher<Iterable<T>> hasItem(Matcher<? extends T> elementMatcher) {
        return IsCollectionContaining.hasItem(elementMatcher);
    }

    public static <T> Matcher<Iterable<T>> hasItems(Matcher<? extends T> ... elementMatchers) {
        return IsCollectionContaining.hasItems(elementMatchers);
    }

    public static <T> Matcher<Iterable<T>> hasItems(T ... elements) {
        return IsCollectionContaining.hasItems(elements);
    }

    public static <K, V> Matcher<Map<K, V>> hasEntry(Matcher<K> keyMatcher, Matcher<V> valueMatcher) {
        return IsMapContaining.hasEntry(keyMatcher, valueMatcher);
    }

    public static <K, V> Matcher<Map<K, V>> hasEntry(K key, V value) {
        return IsMapContaining.hasEntry(key, value);
    }

    public static <K, V> Matcher<Map<K, V>> hasKey(Matcher<K> keyMatcher) {
        return IsMapContaining.hasKey(keyMatcher);
    }

    public static <K, V> Matcher<Map<K, V>> hasKey(K key) {
        return IsMapContaining.hasKey(key);
    }

    public static <K, V> Matcher<Map<K, V>> hasValue(Matcher<V> valueMatcher) {
        return IsMapContaining.hasValue(valueMatcher);
    }

    public static <K, V> Matcher<Map<K, V>> hasValue(V value) {
        return IsMapContaining.hasValue(value);
    }

    public static <T> Matcher<T> isIn(Collection<T> collection) {
        return IsIn.isIn(collection);
    }

    public static <T> Matcher<T> isIn(T[] param1) {
        return IsIn.isIn(param1);
    }

    public static <T> Matcher<T> isOneOf(T ... elements) {
        return IsIn.isOneOf(elements);
    }

    public static Matcher<Double> closeTo(double operand, double error) {
        return IsCloseTo.closeTo(operand, error);
    }

    public static <T extends Comparable<T>> Matcher<T> greaterThan(T value) {
        return OrderingComparisons.greaterThan(value);
    }

    public static <T extends Comparable<T>> Matcher<T> greaterThanOrEqualTo(T value) {
        return OrderingComparisons.greaterThanOrEqualTo(value);
    }

    public static <T extends Comparable<T>> Matcher<T> lessThan(T value) {
        return OrderingComparisons.lessThan(value);
    }

    public static <T extends Comparable<T>> Matcher<T> lessThanOrEqualTo(T value) {
        return OrderingComparisons.lessThanOrEqualTo(value);
    }

    public static Matcher<String> equalToIgnoringCase(String string) {
        return IsEqualIgnoringCase.equalToIgnoringCase(string);
    }

    public static Matcher<String> equalToIgnoringWhiteSpace(String string) {
        return IsEqualIgnoringWhiteSpace.equalToIgnoringWhiteSpace(string);
    }

    public static Matcher<String> containsString(String substring) {
        return StringContains.containsString(substring);
    }

    public static Matcher<String> endsWith(String substring) {
        return StringEndsWith.endsWith(substring);
    }

    public static Matcher<String> startsWith(String substring) {
        return StringStartsWith.startsWith(substring);
    }

    public static <T> Matcher<T> hasToString(Matcher<String> toStringMatcher) {
        return HasToString.hasToString(toStringMatcher);
    }

    public static <T> Matcher<Class<?>> typeCompatibleWith(Class<T> baseType) {
        return IsCompatibleType.typeCompatibleWith(baseType);
    }

    public static Matcher<EventObject> eventFrom(Class<? extends EventObject> eventClass, Object source) {
        return IsEventFrom.eventFrom(eventClass, source);
    }

    public static Matcher<EventObject> eventFrom(Object source) {
        return IsEventFrom.eventFrom(source);
    }

    public static <T> Matcher<T> hasProperty(String propertyName) {
        return HasProperty.hasProperty(propertyName);
    }

    public static <T> Matcher<T> hasProperty(String propertyName, Matcher value) {
        return HasPropertyWithValue.hasProperty(propertyName, value);
    }

    public static Matcher<Node> hasXPath(String xPath, Matcher<String> valueMatcher) {
        return HasXPath.hasXPath(xPath, valueMatcher);
    }

    public static Matcher<Node> hasXPath(String xPath) {
        return HasXPath.hasXPath(xPath);
    }
}

