/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.LongAdder;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.StreamCache;
import org.apache.camel.Traceable;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.processor.SendDynamicProcessor;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WireTapProcessor
extends ServiceSupport
implements AsyncProcessor,
Traceable,
ShutdownAware,
IdAware,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(WireTapProcessor.class);
    private String id;
    private CamelContext camelContext;
    private final SendDynamicProcessor dynamicProcessor;
    private final String uri;
    private final Processor processor;
    private final ExchangePattern exchangePattern;
    private final ExecutorService executorService;
    private volatile boolean shutdownExecutorService;
    private final LongAdder taskCount = new LongAdder();
    private Expression newExchangeExpression;
    private List<Processor> newExchangeProcessors;
    private boolean copy;
    private Processor onPrepare;

    public WireTapProcessor(SendDynamicProcessor dynamicProcessor, Processor processor, ExchangePattern exchangePattern, ExecutorService executorService, boolean shutdownExecutorService) {
        this.dynamicProcessor = dynamicProcessor;
        this.uri = dynamicProcessor.getUri();
        this.processor = processor;
        this.exchangePattern = exchangePattern;
        ObjectHelper.notNull(executorService, "executorService");
        this.executorService = executorService;
        this.shutdownExecutorService = shutdownExecutorService;
    }

    public String toString() {
        return "WireTap[" + this.uri + "]";
    }

    @Override
    public String getTraceLabel() {
        return "wireTap(" + this.uri + ")";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        return true;
    }

    @Override
    public int getPendingExchangesSize() {
        return this.taskCount.intValue();
    }

    @Override
    public void prepareShutdown(boolean suspendOnly, boolean forced) {
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.dynamicProcessor.getEndpointUtilizationStatistics();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Exchange target;
        if (!this.isStarted()) {
            throw new IllegalStateException("WireTapProcessor has not been started: " + this);
        }
        try {
            target = this.configureExchange(exchange, this.exchangePattern);
        }
        catch (Exception e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
        final Exchange wireTapExchange = target;
        this.executorService.submit(new Callable<Exchange>(){

            @Override
            public Exchange call() throws Exception {
                WireTapProcessor.this.taskCount.increment();
                try {
                    LOG.debug(">>>> (wiretap) {} {}", (Object)WireTapProcessor.this.uri, (Object)wireTapExchange);
                    WireTapProcessor.this.processor.process(wireTapExchange);
                }
                catch (Throwable e) {
                    LOG.warn("Error occurred during processing " + wireTapExchange + " wiretap to " + WireTapProcessor.this.uri + ". This exception will be ignored.", e);
                }
                finally {
                    WireTapProcessor.this.taskCount.decrement();
                }
                return wireTapExchange;
            }
        });
        callback.done(true);
        return true;
    }

    protected Exchange configureExchange(Exchange exchange, ExchangePattern pattern) throws IOException {
        StreamCache cache;
        StreamCache copied;
        Message msg;
        Iterator<Processor> body;
        Exchange answer = this.copy ? this.configureCopyExchange(exchange) : this.configureNewExchange(exchange);
        if (this.newExchangeExpression != null && (body = this.newExchangeExpression.evaluate(answer, Object.class)) != null) {
            answer.getIn().setBody(body);
        }
        if (this.newExchangeProcessors != null) {
            for (Processor processor : this.newExchangeProcessors) {
                try {
                    processor.process(answer);
                }
                catch (Exception e) {
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
            }
        }
        Message message = msg = answer.hasOut() ? answer.getOut() : answer.getIn();
        if (msg.getBody() instanceof StreamCache && (copied = (cache = (StreamCache)msg.getBody()).copy(answer)) != null) {
            msg.setBody(copied);
        }
        if (this.onPrepare != null) {
            try {
                this.onPrepare.process(answer);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        return answer;
    }

    private Exchange configureCopyExchange(Exchange exchange) {
        Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange, false);
        copy.setPattern(ExchangePattern.InOnly);
        copy.removeProperty("CamelStreamCacheUnitOfWork");
        return copy;
    }

    private Exchange configureNewExchange(Exchange exchange) {
        return new DefaultExchange(exchange.getFromEndpoint(), ExchangePattern.InOnly);
    }

    public List<Processor> getNewExchangeProcessors() {
        return this.newExchangeProcessors;
    }

    public void setNewExchangeProcessors(List<Processor> newExchangeProcessors) {
        this.newExchangeProcessors = newExchangeProcessors;
    }

    public Expression getNewExchangeExpression() {
        return this.newExchangeExpression;
    }

    public void setNewExchangeExpression(Expression newExchangeExpression) {
        this.newExchangeExpression = newExchangeExpression;
    }

    public void addNewExchangeProcessor(Processor processor) {
        if (this.newExchangeProcessors == null) {
            this.newExchangeProcessors = new ArrayList<Processor>();
        }
        this.newExchangeProcessors.add(processor);
    }

    public boolean isCopy() {
        return this.copy;
    }

    public void setCopy(boolean copy) {
        this.copy = copy;
    }

    public Processor getOnPrepare() {
        return this.onPrepare;
    }

    public void setOnPrepare(Processor onPrepare) {
        this.onPrepare = onPrepare;
    }

    public String getUri() {
        return this.uri;
    }

    public int getCacheSize() {
        return this.dynamicProcessor.getCacheSize();
    }

    public boolean isIgnoreInvalidEndpoint() {
        return this.dynamicProcessor.isIgnoreInvalidEndpoint();
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.processor);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService(this.processor);
        if (this.shutdownExecutorService) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.executorService);
        }
    }
}

