/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble.beacon;

import org.eclipse.kura.KuraBluetoothCommandException;
import org.eclipse.kura.bluetooth.le.BluetoothLeAdapter;
import org.eclipse.kura.bluetooth.le.beacon.BluetoothLeBeacon;
import org.eclipse.kura.bluetooth.le.beacon.BluetoothLeBeaconAdvertiser;
import org.eclipse.kura.bluetooth.le.beacon.BluetoothLeBeaconEncoder;
import org.eclipse.kura.internal.ble.beacon.BluetoothLeBeaconManagerImpl;

public class BluetoothLeBeaconAdvertiserImpl<T extends BluetoothLeBeacon>
implements BluetoothLeBeaconAdvertiser<T> {
    private final BluetoothLeAdapter adapter;
    private final BluetoothLeBeaconEncoder<T> encoder;
    private final BluetoothLeBeaconManagerImpl beaconManager;

    public BluetoothLeBeaconAdvertiserImpl(BluetoothLeAdapter adapter, BluetoothLeBeaconEncoder<T> encoder, BluetoothLeBeaconManagerImpl beaconManager) {
        this.adapter = adapter;
        this.encoder = encoder;
        this.beaconManager = beaconManager;
    }

    public BluetoothLeAdapter getAdapter() {
        return this.adapter;
    }

    public void startBeaconAdvertising() throws KuraBluetoothCommandException {
        this.beaconManager.startBeaconAdvertising(this.adapter.getInterfaceName());
    }

    public void stopBeaconAdvertising() throws KuraBluetoothCommandException {
        this.beaconManager.stopBeaconAdvertising(this.adapter.getInterfaceName());
    }

    public void updateBeaconAdvertisingInterval(Integer min, Integer max) throws KuraBluetoothCommandException {
        this.beaconManager.updateBeaconAdvertisingInterval(min, max, this.adapter.getInterfaceName());
    }

    public void updateBeaconAdvertisingData(T beacon) throws KuraBluetoothCommandException {
        this.beaconManager.updateBeaconAdvertisingData((BluetoothLeBeacon)beacon, (BluetoothLeBeaconEncoder<BluetoothLeBeacon>)this.encoder, this.adapter.getInterfaceName());
    }
}

