/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.io.IOException;
import java.io.InputStream;

public class NonCloseableStream
extends InputStream {
    private final InputStream m_input;
    private boolean m_closed;

    public NonCloseableStream(InputStream m_input) {
        this.m_input = m_input;
    }

    public void close() throws IOException {
        if (this.m_closed) {
            throw new IOException("Unable to read, stream is closed.");
        }
        this.m_closed = true;
    }

    public int read() throws IOException {
        return this.m_input.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.m_closed) {
            throw new IOException("Unable to read, stream is closed.");
        }
        return this.m_input.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        if (this.m_closed) {
            throw new IOException("Unable to read, stream is closed.");
        }
        return this.m_input.read(b);
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readlimit) {
    }

    public void reset() throws IOException {
        throw new IOException("Mark and reset are not available on this type of stream.");
    }

    public int available() throws IOException {
        return this.m_input.available();
    }

    public int hashCode() {
        return this.m_input.hashCode();
    }

    public long skip(long n) throws IOException {
        return this.m_input.skip(n);
    }

    public boolean equals(Object obj) {
        return this.m_input.equals(obj);
    }

    public String toString() {
        return this.m_input.toString();
    }
}

