/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.monitoradmin;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.knowhowlab.osgi.monitoradmin.LogVisitor;
import org.knowhowlab.osgi.monitoradmin.MonitorAdminCommon;
import org.knowhowlab.osgi.monitoradmin.MonitorAdminFactory;
import org.knowhowlab.osgi.monitoradmin.OsgiVisitor;
import org.knowhowlab.osgi.monitoradmin.util.Utils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.log.LogService;
import org.osgi.service.monitor.MonitorAdmin;
import org.osgi.service.monitor.MonitorListener;
import org.osgi.service.monitor.Monitorable;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator,
OsgiVisitor,
LogVisitor {
    private static final Logger LOG = Logger.getLogger(Activator.class.getName());
    private MonitorAdminFactory monitorAdminFactory;
    private MonitorAdminCommon common;
    private BundleContext bc;
    private ServiceRegistration monitorAdminRegistration;
    private ServiceRegistration monitorListenerRegistration;
    private ServiceTracker eventAdminTracker;
    private ServiceTracker logServiceTracker;

    public void start(BundleContext bundleContext) throws Exception {
        this.bc = bundleContext;
        this.logServiceTracker = new ServiceTracker(this.bc, LogService.class.getName(), null);
        this.logServiceTracker.open();
        this.eventAdminTracker = new ServiceTracker(this.bc, EventAdmin.class.getName(), null);
        this.eventAdminTracker.open();
        this.common = new MonitorAdminCommon(this, this);
        this.monitorAdminFactory = new MonitorAdminFactory(this, this.common);
        this.monitorAdminRegistration = bundleContext.registerService(MonitorAdmin.class.getName(), (Object)this.monitorAdminFactory, null);
        this.monitorListenerRegistration = bundleContext.registerService(MonitorListener.class.getName(), (Object)this.common, null);
        this.info("MonitorAdmin started", null);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.monitorAdminRegistration != null) {
            this.monitorAdminRegistration.unregister();
            this.monitorAdminRegistration = null;
        }
        if (this.monitorListenerRegistration != null) {
            this.monitorListenerRegistration.unregister();
            this.monitorListenerRegistration = null;
        }
        if (this.common != null) {
            this.common.cancelAllJobs();
            this.monitorAdminFactory = null;
        }
        if (this.eventAdminTracker != null) {
            this.eventAdminTracker.close();
            this.eventAdminTracker = null;
        }
        this.info("MonitorAdmin stoppped", null);
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
        }
        this.bc = null;
    }

    public void debug(String message, Throwable throwable) {
        LogService logService = (LogService)this.logServiceTracker.getService();
        if (logService != null) {
            logService.log(4, message, throwable);
        } else {
            LOG.log(Level.FINE, message, throwable);
        }
    }

    public void info(String message, Throwable throwable) {
        LogService logService = (LogService)this.logServiceTracker.getService();
        if (logService != null) {
            logService.log(3, message, throwable);
        } else {
            LOG.log(Level.INFO, message, throwable);
        }
    }

    public void warning(String message, Throwable throwable) {
        LogService logService = (LogService)this.logServiceTracker.getService();
        if (logService != null) {
            logService.log(2, message, throwable);
        } else {
            LOG.log(Level.WARNING, message, throwable);
        }
    }

    public void error(String message, Throwable throwable) {
        LogService logService = (LogService)this.logServiceTracker.getService();
        if (logService != null) {
            logService.log(1, message, throwable);
        } else {
            LOG.log(Level.SEVERE, message, throwable);
        }
    }

    public Monitorable getService(ServiceReference reference) {
        return (Monitorable)this.bc.getService(reference);
    }

    public ServiceReference[] findMonitorableReferences(String monitorableId) {
        String filter = null;
        if (monitorableId != null) {
            filter = Utils.createServicePidFilter(monitorableId);
        }
        try {
            return this.bc.getServiceReferences(Monitorable.class.getName(), filter);
        }
        catch (InvalidSyntaxException e) {
            this.warning("Unable to find Monitorable References", e);
            return null;
        }
    }

    public void postEvent(Event event) {
        EventAdmin eventAdmin = (EventAdmin)this.eventAdminTracker.getService();
        if (eventAdmin != null) {
            eventAdmin.postEvent(event);
        } else {
            this.warning("EventAdmin is unavailable", null);
        }
    }
}

