/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import org.eclipse.kura.KuraBluetoothIOException;
import org.eclipse.kura.KuraBluetoothNotificationException;
import org.eclipse.kura.KuraBluetoothResourceNotFoundException;
import org.eclipse.kura.bluetooth.le.BluetoothLeGattCharacteristic;
import org.eclipse.kura.bluetooth.le.BluetoothLeGattCharacteristicProperties;
import org.eclipse.kura.bluetooth.le.BluetoothLeGattDescriptor;
import org.eclipse.kura.bluetooth.le.BluetoothLeGattService;
import org.eclipse.kura.internal.ble.BluetoothLeGattDescriptorImpl;
import org.eclipse.kura.internal.ble.BluetoothLeGattServiceImpl;
import org.eclipse.kura.internal.ble.BluetoothLeNotification;
import tinyb.BluetoothException;
import tinyb.BluetoothGattCharacteristic;
import tinyb.BluetoothGattDescriptor;

public class BluetoothLeGattCharacteristicImpl
implements BluetoothLeGattCharacteristic {
    private static final long TIMEOUT = 30L;
    private final BluetoothGattCharacteristic characteristic;

    public BluetoothLeGattCharacteristicImpl(BluetoothGattCharacteristic characteristic) {
        this.characteristic = characteristic;
    }

    public BluetoothLeGattDescriptor findDescriptor(UUID uuid) throws KuraBluetoothResourceNotFoundException {
        return this.findDescriptor(uuid, 30L);
    }

    public BluetoothLeGattDescriptor findDescriptor(UUID uuid, long timeout) throws KuraBluetoothResourceNotFoundException {
        BluetoothGattDescriptor descriptor = this.characteristic.find(uuid.toString(), Duration.ofSeconds(timeout));
        if (descriptor != null) {
            return new BluetoothLeGattDescriptorImpl(descriptor);
        }
        throw new KuraBluetoothResourceNotFoundException((Object)"Descriptor not found");
    }

    public List<BluetoothLeGattDescriptor> findDescriptors() throws KuraBluetoothResourceNotFoundException {
        List tinybDescriptors = this.characteristic.getDescriptors();
        ArrayList<BluetoothLeGattDescriptor> descriptors = new ArrayList<BluetoothLeGattDescriptor>();
        if (tinybDescriptors != null) {
            for (BluetoothGattDescriptor descriptor : tinybDescriptors) {
                descriptors.add(new BluetoothLeGattDescriptorImpl(descriptor));
            }
        } else {
            throw new KuraBluetoothResourceNotFoundException((Object)"Descriptors not found");
        }
        return descriptors;
    }

    public byte[] readValue() throws KuraBluetoothIOException {
        byte[] value;
        try {
            value = this.characteristic.readValue();
        }
        catch (BluetoothException e) {
            throw new KuraBluetoothIOException((Throwable)e, (Object)"Read characteristic value failed");
        }
        return value;
    }

    public void enableValueNotifications(Consumer<byte[]> callback) throws KuraBluetoothNotificationException {
        BluetoothLeNotification<byte[]> notification = new BluetoothLeNotification<byte[]>(callback);
        try {
            this.characteristic.enableValueNotifications(notification);
        }
        catch (Exception e) {
            throw new KuraBluetoothNotificationException((Throwable)e, (Object)"Notification can't be enabled");
        }
    }

    public void disableValueNotifications() throws KuraBluetoothNotificationException {
        try {
            this.characteristic.disableValueNotifications();
        }
        catch (Exception e) {
            throw new KuraBluetoothNotificationException((Throwable)e, (Object)"Notification can't be disabled");
        }
    }

    public void writeValue(byte[] value) throws KuraBluetoothIOException {
        try {
            this.characteristic.writeValue(value);
        }
        catch (BluetoothException e) {
            throw new KuraBluetoothIOException((Throwable)e, (Object)"Write characteristic value failed");
        }
    }

    public UUID getUUID() {
        return UUID.fromString(this.characteristic.getUUID());
    }

    public BluetoothLeGattService getService() {
        return new BluetoothLeGattServiceImpl(this.characteristic.getService());
    }

    public byte[] getValue() {
        return this.characteristic.getValue();
    }

    public boolean isNotifying() {
        return this.characteristic.getNotifying();
    }

    public List<BluetoothLeGattCharacteristicProperties> getProperties() {
        ArrayList<BluetoothLeGattCharacteristicProperties> properties = new ArrayList<BluetoothLeGattCharacteristicProperties>();
        String[] stringArray = this.characteristic.getFlags();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String flag = stringArray[n2];
            properties.add(BluetoothLeGattCharacteristicProperties.valueOf((String)flag.toUpperCase()));
            ++n2;
        }
        return properties;
    }
}

