/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.eclipse.kura.KuraBluetoothResourceNotFoundException;
import org.eclipse.kura.bluetooth.le.BluetoothLeDevice;
import org.eclipse.kura.bluetooth.le.BluetoothLeGattCharacteristic;
import org.eclipse.kura.bluetooth.le.BluetoothLeGattService;
import org.eclipse.kura.internal.ble.BluetoothLeDeviceImpl;
import org.eclipse.kura.internal.ble.BluetoothLeGattCharacteristicImpl;
import tinyb.BluetoothGattCharacteristic;
import tinyb.BluetoothGattService;

public class BluetoothLeGattServiceImpl
implements BluetoothLeGattService {
    private static final long TIMEOUT = 30L;
    private final BluetoothGattService service;

    public BluetoothLeGattServiceImpl(BluetoothGattService service) {
        this.service = service;
    }

    public BluetoothLeGattCharacteristic findCharacteristic(UUID uuid) throws KuraBluetoothResourceNotFoundException {
        return this.findCharacteristic(uuid, 30L);
    }

    public BluetoothLeGattCharacteristic findCharacteristic(UUID uuid, long timeout) throws KuraBluetoothResourceNotFoundException {
        BluetoothGattCharacteristic characteristic = this.service.find(uuid.toString(), Duration.ofSeconds(timeout));
        if (characteristic != null) {
            return new BluetoothLeGattCharacteristicImpl(characteristic);
        }
        throw new KuraBluetoothResourceNotFoundException((Object)"Gatt characteristic not found");
    }

    public List<BluetoothLeGattCharacteristic> findCharacteristics() throws KuraBluetoothResourceNotFoundException {
        List tinybCharacteristics = this.service.getCharacteristics();
        ArrayList<BluetoothLeGattCharacteristic> characteristics = new ArrayList<BluetoothLeGattCharacteristic>();
        if (tinybCharacteristics != null) {
            for (BluetoothGattCharacteristic characteristic : tinybCharacteristics) {
                characteristics.add(new BluetoothLeGattCharacteristicImpl(characteristic));
            }
        } else {
            throw new KuraBluetoothResourceNotFoundException((Object)"Gatt characteristics not found");
        }
        return characteristics;
    }

    public UUID getUUID() {
        return UUID.fromString(this.service.getUUID());
    }

    public BluetoothLeDevice getDevice() {
        return new BluetoothLeDeviceImpl(this.service.getDevice());
    }

    public boolean isPrimary() {
        return this.service.getPrimary();
    }
}

