/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.linux.bluetooth.le;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraTimeoutException;
import org.eclipse.kura.bluetooth.BluetoothGatt;
import org.eclipse.kura.bluetooth.BluetoothGattCharacteristic;
import org.eclipse.kura.bluetooth.BluetoothGattSecurityLevel;
import org.eclipse.kura.bluetooth.BluetoothGattService;
import org.eclipse.kura.bluetooth.BluetoothLeNotificationListener;
import org.eclipse.kura.linux.bluetooth.le.BluetoothGattCharacteristicImpl;
import org.eclipse.kura.linux.bluetooth.le.BluetoothGattServiceImpl;
import org.eclipse.kura.linux.bluetooth.util.BluetoothProcess;
import org.eclipse.kura.linux.bluetooth.util.BluetoothProcessListener;
import org.eclipse.kura.linux.bluetooth.util.BluetoothUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BluetoothGattImpl
implements BluetoothGatt,
BluetoothProcessListener {
    private static final Logger logger = LoggerFactory.getLogger(BluetoothGattImpl.class);
    private static final long GATT_CONNECTION_TIMEOUT = 10000L;
    private static final long GATT_SERVICE_TIMEOUT = 6000L;
    private static final long GATT_COMMAND_TIMEOUT = 2000L;
    private static final String ANSI_ESCAPE_SEQUENCES = "\\x1b\\[(K|[^m]+m)";
    private static final String[] NOT_CONNECTED = new String[]{"[   ]", "disconnected", "not connected", "error: connect"};
    private static final String[] CONNECTED = new String[]{"[con]", "connection successful", "usage: mtu <value>"};
    private static final String SERVICES = "attr handle:";
    private static final String CHARACTERISTICS = "handle:";
    private static final String READ_CHAR = "characteristic value/descriptor:";
    private static final String REGEX_READ_CHAR_UUID = "handle\\:.*value\\:[\\s|0-9|a-f|A-F]*";
    private static final String NOTIFICATION = "notification handle";
    private static final String ERROR_HANDLE = "invalid handle";
    private static final String[] ERROR_UUID = new String[]{"invalid uuid", "read characteristics by uuid failed: attribute can't be read"};
    private static final String ERROR_CHAR_MESSAGE = "Exception waiting for characteristics";
    private static final String ERROR_GATT_READ_MESSAGE = "Gatttool read timeout.";
    private static final String ERROR_GATT_TIMEOUT_MESSAGE = "Gatttool read error.";
    private static final String ERROR = "ERROR";
    private List<BluetoothGattService> bluetoothServices;
    private List<BluetoothGattCharacteristic> bluetoothGattCharacteristics;
    private BluetoothLeNotificationListener listener;
    private String charValue;
    private String charValueUuid;
    private String securityLevel;
    private BluetoothProcess proc;
    private BufferedWriter bufferedWriter;
    private boolean isConnected = false;
    private boolean ready = false;
    private StringBuilder stringBuilder = null;
    private final String address;

    public BluetoothGattImpl(String address) {
        this.address = address;
    }

    public boolean connect() throws KuraException {
        return this.connect("hci0");
    }

    public boolean connect(String adapterName) throws KuraException {
        this.proc = BluetoothUtil.startSession(adapterName, this.address, this);
        if (this.proc != null) {
            this.bufferedWriter = this.proc.getWriter();
            logger.info("Sending connect message...");
            this.ready = false;
            String command = "connect\n";
            this.sendCmd(command);
            long startTime = System.currentTimeMillis();
            while (!this.ready && System.currentTimeMillis() - startTime < 10000L) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    logger.error("Exception waiting for connection", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            if (!this.ready) {
                throw new KuraTimeoutException("Gatttool connection timeout.");
            }
        }
        return this.isConnected;
    }

    public void disconnect() {
        if (this.proc != null) {
            String command = "exit\n";
            this.sendCmd(command);
            this.proc.destroy();
            this.proc = null;
            logger.info("Disconnected");
        }
    }

    public boolean checkConnection() throws KuraException {
        if (this.proc != null) {
            this.bufferedWriter = this.proc.getWriter();
            logger.info("Check for connection...");
            this.ready = false;
            String command = "mtu\n";
            this.sendCmd(command);
            long startTime = System.currentTimeMillis();
            while (!this.ready && System.currentTimeMillis() - startTime < 10000L) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    logger.error("Exception waiting for connection", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            if (!this.ready) {
                throw new KuraTimeoutException("Gatttool connection timeout.");
            }
        }
        return this.isConnected;
    }

    public void setBluetoothLeNotificationListener(BluetoothLeNotificationListener listener) {
        this.listener = listener;
    }

    public BluetoothGattService getService(UUID uuid) {
        return null;
    }

    public List<BluetoothGattService> getServices() {
        if (this.proc != null) {
            this.bluetoothServices = new ArrayList<BluetoothGattService>();
            String command = "primary\n";
            this.sendCmd(command);
            try {
                Thread.sleep(6000L);
            }
            catch (InterruptedException e) {
                logger.error("Exception waiting for services", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        return this.bluetoothServices;
    }

    public List<BluetoothGattCharacteristic> getCharacteristics(String startHandle, String endHandle) {
        logger.info("getCharacteristics {} : {}", (Object)startHandle, (Object)endHandle);
        if (this.proc != null) {
            this.bluetoothGattCharacteristics = new ArrayList<BluetoothGattCharacteristic>();
            String command = "characteristics " + startHandle + " " + endHandle + "\n";
            this.sendCmd(command);
            try {
                Thread.sleep(6000L);
            }
            catch (InterruptedException e) {
                logger.error(ERROR_CHAR_MESSAGE, (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        return this.bluetoothGattCharacteristics;
    }

    public String readCharacteristicValue(String handle) throws KuraException {
        if (this.proc != null) {
            this.charValue = "";
            String command = "char-read-hnd " + handle + "\n";
            this.sendCmd(command);
            long startTime = System.currentTimeMillis();
            while ("".equals(this.charValue) && !this.charValue.startsWith(ERROR) && System.currentTimeMillis() - startTime < 2000L) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    logger.error(ERROR_CHAR_MESSAGE, (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            if ("".equals(this.charValue)) {
                throw new KuraTimeoutException(ERROR_GATT_READ_MESSAGE);
            }
            if (this.charValue.startsWith(ERROR)) {
                throw KuraException.internalError((String)ERROR_GATT_TIMEOUT_MESSAGE);
            }
        }
        return this.charValue;
    }

    public String readCharacteristicValueByUuid(UUID uuid) throws KuraException {
        if (this.proc != null) {
            this.charValueUuid = "";
            String uuidString = uuid.toString();
            String command = "char-read-uuid " + uuidString + "\n";
            logger.info("send command : {}", (Object)command);
            this.sendCmd(command);
            long startTime = System.currentTimeMillis();
            while ("".equals(this.charValueUuid) && !this.charValueUuid.startsWith(ERROR) && System.currentTimeMillis() - startTime < 2000L) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    logger.error(ERROR_CHAR_MESSAGE, (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            if ("".equals(this.charValueUuid)) {
                throw new KuraTimeoutException(ERROR_GATT_READ_MESSAGE);
            }
            if (this.charValueUuid.startsWith(ERROR)) {
                throw KuraException.internalError((String)ERROR_GATT_TIMEOUT_MESSAGE);
            }
        }
        return this.charValueUuid;
    }

    public void writeCharacteristicValue(String handle, String value) {
        if (this.proc != null) {
            this.charValueUuid = null;
            String command = "char-write-cmd " + handle + " " + value + "\n";
            this.sendCmd(command);
        }
    }

    @Override
    public void processInputStream(int ch) {
        if (this.stringBuilder == null) {
            this.stringBuilder = new StringBuilder();
        }
        if (ch == 10 || ch == 13 || (char)ch == '>') {
            this.stringBuilder.append((char)ch);
            this.processLine(this.stringBuilder.toString().replaceAll(ANSI_ESCAPE_SEQUENCES, ""));
            this.stringBuilder.setLength(0);
        } else {
            this.stringBuilder.append((char)ch);
        }
    }

    @Override
    public void processInputStream(String string) {
    }

    @Override
    public void processErrorStream(String string) {
    }

    public BluetoothGattSecurityLevel getSecurityLevel() throws KuraException {
        BluetoothGattSecurityLevel level = BluetoothGattSecurityLevel.UNKNOWN;
        if (this.isConnected && this.proc != null) {
            this.securityLevel = "";
            this.bufferedWriter = this.proc.getWriter();
            logger.info("Get security level...");
            String command = "sec-level\n";
            this.sendCmd(command);
            long startTime = System.currentTimeMillis();
            while ("".equals(this.securityLevel) && !this.securityLevel.startsWith(ERROR) && System.currentTimeMillis() - startTime < 2000L) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    logger.error(ERROR_CHAR_MESSAGE, (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            if ("".equals(this.securityLevel)) {
                throw new KuraTimeoutException(ERROR_GATT_READ_MESSAGE);
            }
            if (this.securityLevel.startsWith(ERROR)) {
                throw KuraException.internalError((String)ERROR_GATT_TIMEOUT_MESSAGE);
            }
            level = BluetoothGattSecurityLevel.getBluetoothGattSecurityLevel((String)this.securityLevel);
        }
        return level;
    }

    public void setSecurityLevel(BluetoothGattSecurityLevel level) {
        if (this.isConnected && this.proc != null) {
            this.bufferedWriter = this.proc.getWriter();
            logger.debug("Set security level to {}", (Object)level.toString());
            String command = "sec-level " + level.toString().toLowerCase() + "\n";
            this.sendCmd(command);
        }
    }

    private void sendCmd(String command) {
        try {
            logger.debug("send command = {}", (Object)command);
            this.bufferedWriter.write(command);
            this.bufferedWriter.flush();
        }
        catch (IOException e) {
            logger.error("Error writing command: {}", (Object)command, (Object)e);
        }
    }

    private void processLine(String line) {
        logger.debug("Processing line : {}", (Object)line);
        if (this.checkString(line.toLowerCase(), NOT_CONNECTED)) {
            this.isConnected = false;
            this.ready = false;
        } else if (this.checkString(line.toLowerCase(), CONNECTED)) {
            this.isConnected = true;
            this.ready = true;
        } else if (line.matches(REGEX_READ_CHAR_UUID)) {
            logger.debug("Characteristic value by UUID received: {}", (Object)line);
            String[] attr = line.split(":");
            this.charValueUuid = attr[2].trim();
            logger.info("m_charValueUuid: {}", (Object)this.charValueUuid);
        } else if (line.toLowerCase().startsWith(SERVICES)) {
            logger.debug("Service : {}", (Object)line);
            String[] attr = line.split("\\s");
            String startHandle = attr[2].substring(0, attr[2].length() - 1);
            String endHandle = attr[6];
            String uuid = attr[8];
            if (this.bluetoothServices != null && this.isNewService(uuid)) {
                logger.debug("Adding new GATT service: {} : {} : {}", new Object[]{uuid, startHandle, endHandle});
                this.bluetoothServices.add(new BluetoothGattServiceImpl(uuid, startHandle, endHandle));
            }
        } else if (line.toLowerCase().startsWith(CHARACTERISTICS)) {
            logger.debug("Characteristic : {}", (Object)line);
            String[] attr = line.split(" ");
            String handle = attr[1].substring(0, attr[1].length() - 1);
            String properties = attr[4].substring(0, attr[4].length() - 1);
            String valueHandle = attr[8].substring(0, attr[8].length() - 1);
            String uuid = attr[10].substring(0, attr[10].length() - 1);
            if (this.bluetoothGattCharacteristics != null && this.isNewGattCharacteristic(uuid)) {
                logger.debug("Adding new GATT characteristic: {}", (Object)uuid);
                logger.debug("{} {} {}", new Object[]{handle, properties, valueHandle});
                this.bluetoothGattCharacteristics.add(new BluetoothGattCharacteristicImpl(uuid, handle, properties, valueHandle));
            }
        } else if (line.toLowerCase().contains(READ_CHAR)) {
            logger.debug("Characteristic value by handle received: {}", (Object)line);
            String[] attr = line.split(":");
            this.charValue = attr[1].trim();
        } else if (line.toLowerCase().contains(NOTIFICATION)) {
            logger.debug("Receiving notification: {}", (Object)line);
            String sub = line.substring(line.toLowerCase().indexOf(NOTIFICATION) + NOTIFICATION.length() + 3).trim();
            String[] attr = sub.split(":");
            String handle = attr[0].split("\\s")[0];
            String value = attr[1].trim();
            this.listener.onDataReceived(handle, value);
        } else if (line.toLowerCase().contains(ERROR_HANDLE)) {
            logger.info("ERROR_HANDLE");
            this.charValue = "ERROR: Invalid handle!";
        } else if (this.checkString(line.toLowerCase(), ERROR_UUID)) {
            logger.info("ERROR_UUID");
            this.charValueUuid = "ERROR: Invalid UUID!";
        } else if (line.toLowerCase().startsWith("sec-level:")) {
            logger.debug("Received security level : {}", (Object)line.toLowerCase().substring("sec-level: ".length(), line.toLowerCase().length()));
            this.securityLevel = line.toLowerCase().substring("sec-level: ".length(), line.toLowerCase().length()).replace("\n", "").replace("\r", "");
        }
    }

    private boolean checkString(String line, String[] lines) {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (line.contains(item)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isNewService(String uuid) {
        for (BluetoothGattService service : this.bluetoothServices) {
            if (!service.getUuid().toString().equals(uuid)) continue;
            return false;
        }
        return true;
    }

    private boolean isNewGattCharacteristic(String uuid) {
        for (BluetoothGattCharacteristic characteristic : this.bluetoothGattCharacteristics) {
            if (!characteristic.getUuid().toString().equals(uuid)) continue;
            return false;
        }
        return true;
    }
}

