/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.camel.internal.cloud;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.camel.internal.cloud.CloudClientCache;
import org.eclipse.kura.cloud.CloudClient;
import org.eclipse.kura.cloud.CloudService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudClientCacheImpl
implements CloudClientCache {
    private static final Logger logger = LoggerFactory.getLogger(CloudClientCacheImpl.class);
    private final CloudService cloudService;
    private final Map<String, Set<CloudClientCache.CloudClientHandle>> cache = new HashMap<String, Set<CloudClientCache.CloudClientHandle>>();

    public CloudClientCacheImpl(CloudService cloudService) {
        this.cloudService = cloudService;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized CloudClientCache.CloudClientHandle getOrCreate(String applicationId) {
        try {
            Set<CloudClientCache.CloudClientHandle> set = this.cache.get(applicationId);
            if (set == null) {
                logger.debug("CloudClient for application ID {} not found. Creating new one.", (Object)applicationId);
                set = new HashSet<CloudClientCache.CloudClientHandle>();
                this.cache.put(applicationId, set);
            } else {
                logger.debug("CloudClient for application ID {} ... cache hit.", (Object)applicationId);
            }
            boolean created = false;
            CloudClient client = null;
            try {
                if (set.isEmpty()) {
                    logger.debug("Creating new cloud client for: {}", (Object)applicationId);
                    created = true;
                    client = this.cloudService.newCloudClient(applicationId);
                } else {
                    client = set.iterator().next().getClient();
                    logger.debug("Re-using cloud client: {} -> {}", (Object)applicationId, (Object)client);
                }
                try {
                    CloudClientHandleImplementation handle = new CloudClientHandleImplementation(applicationId, client);
                    set.add(handle);
                    CloudClientHandleImplementation cloudClientHandleImplementation = handle;
                    client = null;
                    return cloudClientHandleImplementation;
                }
                catch (Throwable throwable) {
                    client = null;
                    throw throwable;
                }
            }
            finally {
                if (created && client != null) {
                    client.release();
                }
            }
        }
        catch (KuraException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHandle(CloudClientCache.CloudClientHandle handle, String applicationId, CloudClient client) {
        Set<CloudClientCache.CloudClientHandle> set;
        logger.debug("Remove handle: {}", (Object)handle);
        CloudClientCacheImpl cloudClientCacheImpl = this;
        synchronized (cloudClientCacheImpl) {
            set = this.cache.get(applicationId);
            if (set == null) {
                return;
            }
            set.remove(handle);
            if (set.isEmpty()) {
                logger.debug("Removing last handle for: {}", (Object)applicationId);
                this.cache.remove(applicationId);
            }
        }
        if (set.isEmpty()) {
            logger.debug("Releasing client: {} / {}", (Object)applicationId, (Object)client);
            client.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<CloudClientCache.CloudClientHandle> handles = new ArrayList<CloudClientCache.CloudClientHandle>();
        CloudClientCacheImpl cloudClientCacheImpl = this;
        synchronized (cloudClientCacheImpl) {
            for (Set<CloudClientCache.CloudClientHandle> set : this.cache.values()) {
                handles.addAll(set);
            }
            this.cache.clear();
        }
        HashSet<CloudClient> clients = new HashSet<CloudClient>();
        for (CloudClientCache.CloudClientHandle handle : handles) {
            CloudClient client = handle.getClient();
            if (!clients.add(client)) continue;
            client.release();
            logger.info("Closing client: {}", (Object)client);
        }
    }

    private final class CloudClientHandleImplementation
    implements CloudClientCache.CloudClientHandle {
        private final String applicationId;
        private final CloudClient client;

        public CloudClientHandleImplementation(String applicationId, CloudClient client) {
            this.applicationId = applicationId;
            this.client = client;
        }

        @Override
        public void close() throws Exception {
            CloudClientCacheImpl.this.removeHandle(this, this.applicationId, this.client);
        }

        @Override
        public CloudClient getClient() {
            return this.client;
        }
    }
}

