/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker.subscriptions;

import io.moquette.broker.subscriptions.CNode;
import io.moquette.broker.subscriptions.CTrie;
import io.moquette.broker.subscriptions.Subscription;
import io.moquette.broker.subscriptions.TNode;

class DumpTreeVisitor
implements CTrie.IVisitor<String> {
    String s = "";

    DumpTreeVisitor() {
    }

    @Override
    public void visit(CNode node, int deep) {
        String indentTabs = this.indentTabs(deep);
        this.s = this.s + indentTabs + (node.getToken() == null ? "''" : node.getToken().toString()) + this.prettySubscriptions(node) + "\n";
    }

    private String prettySubscriptions(CNode node) {
        if (node instanceof TNode) {
            return "TNode";
        }
        if (node.subscriptions.isEmpty()) {
            return "";
        }
        StringBuilder subScriptionsStr = new StringBuilder(" ~~[");
        int counter = 0;
        for (Subscription couple : node.subscriptions) {
            subScriptionsStr.append("{filter=").append(couple.topicFilter).append(", ").append("qos=").append((Object)couple.getRequestedQos()).append(", ").append("client='").append(couple.clientId).append("'}");
            if (++counter >= node.subscriptions.size()) continue;
            subScriptionsStr.append(";");
        }
        return subScriptionsStr.append("]").toString();
    }

    private String indentTabs(int deep) {
        StringBuilder s = new StringBuilder();
        if (deep > 0) {
            s.append("    ");
            for (int i = 0; i < deep - 1; ++i) {
                s.append("| ");
            }
            s.append("|-");
        }
        return s.toString();
    }

    @Override
    public String getResult() {
        return this.s;
    }
}

