/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.ssl;

import org.eclipse.kura.ssl.SslServiceListener;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SslServiceListeners
implements SslServiceListener {
    private static final Logger s_logger = LoggerFactory.getLogger(SslServiceListeners.class);
    private final ServiceTracker<SslServiceListener, SslServiceListener> m_listenersTracker;

    public SslServiceListeners(ServiceTracker<SslServiceListener, SslServiceListener> listenersTracker) {
        this.m_listenersTracker = listenersTracker;
    }

    public void onConfigurationUpdated() {
        this.openOnce();
        Object[] listeners = this.m_listenersTracker.getServices();
        if (listeners != null && listeners.length != 0) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                try {
                    ((SslServiceListener)listener).onConfigurationUpdated();
                }
                catch (Throwable t) {
                    s_logger.error("Unexpected Throwable", t);
                }
                ++n2;
            }
        }
    }

    public synchronized void close() {
        if (this.m_listenersTracker.getTrackingCount() != -1) {
            this.m_listenersTracker.close();
        }
    }

    private synchronized void openOnce() {
        if (this.m_listenersTracker.getTrackingCount() == -1) {
            this.m_listenersTracker.open();
        }
    }
}

