/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.wire.camel;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.camel.CamelContext;
import org.eclipse.kura.camel.component.Configuration;
import org.eclipse.kura.util.osgi.FilterUtil;
import org.eclipse.kura.util.osgi.SingleServiceTracker;
import org.eclipse.kura.wire.camel.AbstractWireComponent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCamelWireComponent
extends AbstractWireComponent {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCamelWireComponent.class);
    protected final BundleContext context = FrameworkUtil.getBundle(AbstractCamelWireComponent.class).getBundleContext();
    private SingleServiceTracker<CamelContext> tracker;
    private String contextId;

    protected void closeContextTracker() {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
    }

    protected void openContextTracker(String contextId) throws InvalidSyntaxException {
        this.closeContextTracker();
        if (contextId == null || contextId.isEmpty()) {
            return;
        }
        Filter filter = this.context.createFilter(FilterUtil.simpleFilter(CamelContext.class, (String)"camel.context.id", (String)contextId));
        this.tracker = new SingleServiceTracker(this.context, filter, this::bindContext);
        this.tracker.open();
    }

    protected void bindContext(CamelContext context) {
    }

    @Override
    protected void activate(ComponentContext componentContext, Map<String, ?> properties) throws Exception {
        super.activate(componentContext, properties);
        this.contextId = Configuration.asString(properties, (String)"id");
        this.openContextTracker(this.contextId);
    }

    @Override
    protected void modified(ComponentContext componentContext, Map<String, ?> properties) throws Exception {
        this.deactivate();
        this.activate(componentContext, properties);
    }

    @Override
    protected void deactivate() {
        this.closeContextTracker();
        super.deactivate();
    }

    protected void withContext(Consumer<CamelContext> consumer) {
        CamelContext camelContext = (CamelContext)this.tracker.getService();
        if (camelContext != null) {
            consumer.accept(camelContext);
        } else {
            logger.warn("Missing Camel context: {}", (Object)this.contextId);
        }
    }
}

