/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.server.config;

import io.moquette.server.config.ConfigurationParser;
import io.moquette.server.config.IConfig;
import java.io.File;
import java.text.ParseException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemConfig
implements IConfig {
    private static final Logger LOG = LoggerFactory.getLogger(FilesystemConfig.class);
    private final Properties m_properties;

    public FilesystemConfig(File file) {
        ConfigurationParser confParser = new ConfigurationParser();
        try {
            confParser.parse(file);
        }
        catch (ParseException pex) {
            LOG.warn("An error occurred in parsing configuration, fallback on default configuration", pex);
        }
        this.m_properties = confParser.getProperties();
    }

    public FilesystemConfig() {
        this(FilesystemConfig.defaultConfigFile());
    }

    private static File defaultConfigFile() {
        String configPath = System.getProperty("moquette.path", null);
        return new File(configPath, "config/moquette.conf");
    }

    @Override
    public void setProperty(String name, String value) {
        this.m_properties.setProperty(name, value);
    }

    @Override
    public String getProperty(String name) {
        return this.m_properties.getProperty(name);
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        return this.m_properties.getProperty(name, defaultValue);
    }
}

