/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.deployment.agent.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraRuntimeException;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.deployment.agent.DeploymentAgentService;
import org.eclipse.kura.ssl.SslManagerService;
import org.eclipse.kura.system.SystemService;
import org.osgi.framework.Version;
import org.osgi.service.component.ComponentException;
import org.osgi.service.deploymentadmin.DeploymentAdmin;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.DeploymentPackage;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentAgent
implements DeploymentAgentService,
ConfigurableComponent {
    private static Logger logger = LoggerFactory.getLogger(DeploymentAgent.class);
    private static final String DPA_CONF_PATH_PROPNAME = "dpa.configuration";
    private static final String PACKAGES_PATH_PROPNAME = "kura.packages";
    private static final String CONN_TIMEOUT_PROPNAME = "dpa.connection.timeout";
    private static final String READ_TIMEOUT_PROPNAME = "dpa.read.timeout";
    private static final long THREAD_TERMINATION_TOUT = 1L;
    private DeploymentAdmin deploymentAdmin;
    private EventAdmin eventAdmin;
    private SystemService systemService;
    private Set<String> instPackageUrls = new HashSet<String>();
    private Set<String> uninstPackageNames = new HashSet<String>();
    private ExecutorService executor = Executors.newSingleThreadExecutor(r -> {
        Thread result = Executors.defaultThreadFactory().newThread(r);
        result.setName("DeploymentAgent");
        return result;
    });
    private String dpaConfPath;
    private String packagesPath;
    private int connTimeout;
    private int readTimeout;
    private SslManagerService sslManagerService;

    public void setSslManagerService(SslManagerService sslManagerService) {
        this.sslManagerService = sslManagerService;
    }

    public void unsetSslManagerService(SslManagerService sslManagerService) {
        if (sslManagerService == this.sslManagerService) {
            this.sslManagerService = null;
        }
    }

    protected void activate() {
        File dpaConfFile;
        String sReadTimeout;
        String sConnTimeout;
        this.dpaConfPath = System.getProperty(DPA_CONF_PATH_PROPNAME);
        if (this.dpaConfPath == null || this.dpaConfPath.isEmpty()) {
            throw new ComponentException("The value of 'dpa.configuration' is not defined");
        }
        Properties kuraProperties = this.systemService.getProperties();
        this.packagesPath = kuraProperties.getProperty(PACKAGES_PATH_PROPNAME);
        if (this.packagesPath == null || this.packagesPath.isEmpty()) {
            throw new ComponentException("The value of 'kura.packages' is not defined");
        }
        if (kuraProperties.getProperty(PACKAGES_PATH_PROPNAME) != null && kuraProperties.getProperty(PACKAGES_PATH_PROPNAME).trim().equals("kura/packages")) {
            kuraProperties.setProperty(PACKAGES_PATH_PROPNAME, "/opt/eclipse/kura/kura/packages");
            this.packagesPath = kuraProperties.getProperty(PACKAGES_PATH_PROPNAME);
            logger.warn("Overridding invalid kura.packages location");
        }
        if ((sConnTimeout = kuraProperties.getProperty(CONN_TIMEOUT_PROPNAME)) != null) {
            this.connTimeout = Integer.valueOf(sConnTimeout);
        }
        if ((sReadTimeout = kuraProperties.getProperty(READ_TIMEOUT_PROPNAME)) != null) {
            this.readTimeout = Integer.valueOf(sReadTimeout);
        }
        if ((dpaConfFile = new File(this.dpaConfPath)).getParentFile() != null && !dpaConfFile.getParentFile().exists()) {
            dpaConfFile.getParentFile().mkdirs();
        }
        try {
            if (!dpaConfFile.createNewFile()) {
                logger.debug("DPA configuration file already available");
            }
        }
        catch (IOException e) {
            throw new ComponentException("Cannot create empty DPA configuration file", (Throwable)e);
        }
        File packagesDir = new File(this.packagesPath);
        if (!packagesDir.exists() && !packagesDir.mkdirs()) {
            throw new ComponentException("Cannot create packages directory");
        }
        this.installPackagesFromConfFile();
    }

    protected void deactivate() {
        logger.debug("Terminating DeploymentAgent Thread ...");
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("Interrupted", (Throwable)e);
        }
        logger.info("DeploymentAgent Thread terminated? - {}", (Object)this.executor.isTerminated());
    }

    public void updated() {
        logger.debug("Updating DeploymentAgent...");
        logger.debug("DeploymentAgent updated");
    }

    public void setDeploymentAdmin(DeploymentAdmin deploymentAdmin) {
        this.deploymentAdmin = deploymentAdmin;
    }

    protected void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void installDeploymentPackageAsync(String url) throws Exception {
        Set<String> set = this.instPackageUrls;
        synchronized (set) {
            if (this.instPackageUrls.contains(url)) {
                throw new Exception("Element already exists");
            }
            this.instPackageUrls.add(url);
        }
        this.executor.submit(() -> {
            try {
                logger.info("About to install package at URL {}", (Object)url);
                this.execInstall(url);
            }
            catch (Exception e) {
                logger.error("Unexpected exception installing {}", (Object)url, (Object)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstallDeploymentPackageAsync(String name) throws Exception {
        Set<String> set = this.uninstPackageNames;
        synchronized (set) {
            if (this.uninstPackageNames.contains(name)) {
                throw new Exception("Element already exists");
            }
            this.uninstPackageNames.add(name);
        }
        this.executor.submit(() -> {
            try {
                logger.info("About to uninstall package {}", (Object)name);
                this.execUninstall(name);
            }
            catch (Exception e) {
                logger.error("Unexpected exception uninstalling {}", (Object)name, (Object)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInstallingDeploymentPackage(String url) {
        Set<String> set = this.instPackageUrls;
        synchronized (set) {
            return this.instPackageUrls.contains(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUninstallingDeploymentPackage(String name) {
        Set<String> set = this.uninstPackageNames;
        synchronized (set) {
            return this.uninstPackageNames.contains(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execInstall(String url) {
        block14: {
            DeploymentPackage dp = null;
            Exception ex = null;
            try {
                try {
                    dp = this.installDeploymentPackageInternal(url);
                }
                catch (Exception e) {
                    ex = e;
                    logger.error("Exception installing package at URL {}", (Object)url, (Object)e);
                    boolean successful = dp != null;
                    logger.info("Posting INSTALLED event for package at URL {}: {}", (Object)url, (Object)(successful ? "successful" : "unsuccessful"));
                    Set<String> set = this.instPackageUrls;
                    synchronized (set) {
                        this.instPackageUrls.remove(url);
                    }
                    this.postInstalledEvent(dp, url, successful, ex);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                boolean successful = dp != null;
                logger.info("Posting INSTALLED event for package at URL {}: {}", (Object)url, (Object)(successful ? "successful" : "unsuccessful"));
                Set<String> set = this.instPackageUrls;
                synchronized (set) {
                    this.instPackageUrls.remove(url);
                }
                this.postInstalledEvent(dp, url, successful, ex);
                throw throwable;
            }
            boolean successful = dp != null;
            logger.info("Posting INSTALLED event for package at URL {}: {}", (Object)url, (Object)(successful ? "successful" : "unsuccessful"));
            Set<String> set = this.instPackageUrls;
            synchronized (set) {
                this.instPackageUrls.remove(url);
            }
            this.postInstalledEvent(dp, url, successful, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execUninstall(String name) {
        block16: {
            DeploymentPackage dp = null;
            boolean successful = false;
            Exception ex = null;
            try {
                try {
                    dp = this.deploymentAdmin.getDeploymentPackage(name);
                    if (dp != null) {
                        dp.uninstall();
                        Properties deployedPackages = this.readDeployedPackages();
                        String sUrl = deployedPackages.getProperty(name);
                        File dpFile = new File(new URL(sUrl).getPath());
                        if (!Files.deleteIfExists(dpFile.toPath())) {
                            logger.warn("Cannot delete file at URL: {}", (Object)sUrl);
                        }
                        successful = true;
                        this.removePackageFromConfFile(name);
                    }
                }
                catch (Exception e) {
                    ex = e;
                    logger.error("Exception uninstalling package {}", (Object)name, (Object)e);
                    logger.info("Posting UNINSTALLED event for package {}: {}", (Object)name, (Object)(successful ? "successful" : "unsuccessful"));
                    Set<String> set = this.uninstPackageNames;
                    synchronized (set) {
                        this.uninstPackageNames.remove(name);
                    }
                    this.postUninstalledEvent(name, successful, ex);
                    break block16;
                }
            }
            catch (Throwable throwable) {
                logger.info("Posting UNINSTALLED event for package {}: {}", (Object)name, (Object)(successful ? "successful" : "unsuccessful"));
                Set<String> set = this.uninstPackageNames;
                synchronized (set) {
                    this.uninstPackageNames.remove(name);
                }
                this.postUninstalledEvent(name, successful, ex);
                throw throwable;
            }
            logger.info("Posting UNINSTALLED event for package {}: {}", (Object)name, (Object)(successful ? "successful" : "unsuccessful"));
            Set<String> set = this.uninstPackageNames;
            synchronized (set) {
                this.uninstPackageNames.remove(name);
            }
            this.postUninstalledEvent(name, successful, ex);
        }
    }

    private void postInstalledEvent(DeploymentPackage dp, String url, boolean successful, Exception e) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (dp != null) {
            props.put("deploymentpackage.name", dp.getName());
            Version version = dp.getVersion();
            props.put("deploymentpackage.version", version.toString());
        } else {
            props.put("deploymentpackage.name", "UNKNOWN");
            props.put("deploymentpackage.version", "UNKNOWN");
        }
        props.put("deploymentpackage.url", url);
        props.put("successful", successful);
        props.put("exception", e);
        EventProperties eventProps = new EventProperties(props);
        this.eventAdmin.postEvent(new Event(EVENT_INSTALLED_TOPIC, (Map)eventProps));
    }

    private void postUninstalledEvent(String name, boolean successful, Exception e) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("deploymentpackage.name", name);
        props.put("successful", successful);
        props.put("exception", e);
        EventProperties eventProps = new EventProperties(props);
        this.eventAdmin.postEvent(new Event(EVENT_UNINSTALLED_TOPIC, (Map)eventProps));
    }

    private void installPackagesFromConfFile() {
        Properties deployedPackages = this.readDeployedPackages();
        Set<Object> packageNames = deployedPackages.keySet();
        for (Object packageName : packageNames) {
            String packageUrl = (String)deployedPackages.get(packageName);
            logger.info("Deploying package name {} at URL {}", packageName, (Object)packageUrl);
            try {
                this.installDeploymentPackageAsync(packageUrl);
            }
            catch (Exception e) {
                logger.error("Error installing package {}", packageName, (Object)e);
            }
        }
    }

    protected Properties readDeployedPackages() {
        Properties deployedPackages = new Properties();
        if (this.dpaConfPath != null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileReader fr = new FileReader(this.dpaConfPath);){
                    deployedPackages.load(fr);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                logger.error("Exception loading deployment packages configuration file", (Throwable)e);
            }
        }
        return deployedPackages;
    }

    private DeploymentPackage installDeploymentPackageInternal(String urlSpec) throws DeploymentException, IOException, GeneralSecurityException {
        URL url = new URL(urlSpec);
        File dpFile = null;
        dpFile = !"file".equals(url.getProtocol()) ? this.getFileFromRemote(url) : this.getFileFromFilesystem(url);
        DeploymentPackage dp = null;
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (FileInputStream dpInputStream = new FileInputStream(dpFile);){
                dp = this.deploymentAdmin.installDeploymentPackage((InputStream)dpInputStream);
                String dpFsName = String.valueOf(dp.getName()) + "_" + dp.getVersion() + ".dp";
                String dpPersistentFilePath = String.valueOf(this.packagesPath) + File.separator + dpFsName;
                File dpPersistentFile = new File(dpPersistentFilePath);
                if (!dpFile.getCanonicalPath().equals(dpPersistentFile.getCanonicalPath())) {
                    logger.debug("dpFile.getCanonicalPath(): {}", (Object)dpFile.getCanonicalPath());
                    logger.debug("dpPersistentFile.getCanonicalPath(): {}", (Object)dpPersistentFile.getCanonicalPath());
                    FileUtils.copyFile((File)dpFile, (File)dpPersistentFile);
                    this.addPackageToConfFile(dp.getName(), "file:" + dpPersistentFilePath);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            File packagesFolder = new File(this.packagesPath);
            if (!dpFile.getCanonicalPath().startsWith(packagesFolder.getCanonicalPath())) {
                Files.delete(dpFile.toPath());
                logger.debug("Deleted file: {}", (Object)dpFile.getName());
            }
        }
        return dp;
    }

    private File getFileFromRemote(URL url) throws GeneralSecurityException, IOException {
        int responseCode;
        File dpFile = File.createTempFile("dpa", null);
        dpFile.deleteOnExit();
        HttpURLConnection.setFollowRedirects(false);
        URLConnection urlConnection = url.openConnection();
        urlConnection.setConnectTimeout(this.connTimeout);
        urlConnection.setReadTimeout(this.readTimeout);
        if (urlConnection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(this.sslManagerService.getSSLSocketFactory());
        }
        if ((responseCode = ((HttpURLConnection)urlConnection).getResponseCode()) == 302 || responseCode == 301 || responseCode == 303) {
            String newLocation = urlConnection.getHeaderField("Location");
            if (StringUtils.isNotEmpty((CharSequence)newLocation)) {
                return this.getFileFromRemote(new URL(newLocation));
            }
            throw new KuraRuntimeException(KuraErrorCode.INVALID_PARAMETER);
        }
        Throwable throwable = null;
        Object var6_8 = null;
        try (InputStream is = urlConnection.getInputStream();){
            FileUtils.copyInputStreamToFile((InputStream)is, (File)dpFile);
            return dpFile;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private File getFileFromFilesystem(URL url) {
        return new File(url.getPath());
    }

    private void addPackageToConfFile(String packageName, String packageUrl) {
        Properties deployedPackages = this.readDeployedPackages();
        deployedPackages.setProperty(packageName, packageUrl);
        if (this.dpaConfPath == null) {
            logger.warn("Configuration file not specified");
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream fos = new FileOutputStream(this.dpaConfPath);){
                deployedPackages.store(fos, null);
                fos.flush();
                fos.getFD().sync();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error("Error writing package configuration file", (Throwable)e);
        }
    }

    private void removePackageFromConfFile(String packageName) {
        Properties deployedPackages = this.readDeployedPackages();
        deployedPackages.remove(packageName);
        if (this.dpaConfPath == null) {
            logger.warn("Configuration file not specified");
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream fos = new FileOutputStream(this.dpaConfPath);){
                deployedPackages.store(fos, null);
                fos.flush();
                fos.getFD().sync();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error("Error writing package configuration file", (Throwable)e);
        }
    }
}

