/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.h2db.store;

import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.db.H2DbService;
import org.eclipse.kura.internal.wire.h2db.common.H2DbServiceHelper;
import org.eclipse.kura.internal.wire.h2db.store.H2DbDataTypeMapper;
import org.eclipse.kura.internal.wire.h2db.store.H2DbWireRecordStoreOptions;
import org.eclipse.kura.type.BooleanValue;
import org.eclipse.kura.type.ByteArrayValue;
import org.eclipse.kura.type.DataType;
import org.eclipse.kura.type.DoubleValue;
import org.eclipse.kura.type.FloatValue;
import org.eclipse.kura.type.IntegerValue;
import org.eclipse.kura.type.LongValue;
import org.eclipse.kura.type.StringValue;
import org.eclipse.kura.type.TypedValue;
import org.eclipse.kura.util.collection.CollectionUtil;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEmitter;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.WireReceiver;
import org.eclipse.kura.wire.WireRecord;
import org.eclipse.kura.wire.WireSupport;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.wireadmin.Wire;

public class H2DbWireRecordStore
implements WireEmitter,
WireReceiver,
ConfigurableComponent {
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String DATA_TYPE = "DATA_TYPE";
    private static final Logger logger = LogManager.getLogger(H2DbWireRecordStore.class);
    private static final String SQL_ADD_COLUMN = "ALTER TABLE {0} ADD COLUMN {1} {2};";
    private static final String SQL_CREATE_TABLE = "CREATE TABLE IF NOT EXISTS {0} (ID BIGINT GENERATED BY DEFAULT AS IDENTITY(START WITH 1 INCREMENT BY 1) PRIMARY KEY, TIMESTAMP BIGINT);";
    private static final String SQL_CREATE_TABLE_INDEX = "CREATE INDEX IF NOT EXISTS {0} ON {1} {2};";
    private static final String SQL_ROW_COUNT_TABLE = "SELECT COUNT(*) FROM {0};";
    private static final String SQL_DELETE_RANGE_TABLE = "DELETE FROM {0} WHERE ID IN (SELECT ID FROM {0} ORDER BY ID ASC LIMIT {1});";
    private static final String SQL_DROP_COLUMN = "ALTER TABLE {0} DROP COLUMN {1};";
    private static final String SQL_INSERT_RECORD = "INSERT INTO {0} ({1}) VALUES ({2});";
    private static final String SQL_TRUNCATE_TABLE = "TRUNCATE TABLE {0};";
    private static final String[] TABLE_TYPE = new String[]{"TABLE"};
    private H2DbServiceHelper dbHelper;
    private H2DbService dbService;
    private H2DbWireRecordStoreOptions wireRecordStoreOptions;
    private volatile WireHelperService wireHelperService;
    private WireSupport wireSupport;

    public synchronized void bindDbService(H2DbService dbService) {
        this.dbService = dbService;
        this.dbHelper = H2DbServiceHelper.of(dbService);
        if (Objects.nonNull(this.dbService) && Objects.nonNull(this.wireRecordStoreOptions)) {
            this.reconcileDB(this.wireRecordStoreOptions.getTableName());
        }
    }

    public synchronized void unbindDbService(H2DbService dbService) {
        if (this.dbService == dbService) {
            this.dbHelper = null;
            this.dbService = null;
            this.wireRecordStoreOptions = null;
        }
    }

    public void bindWireHelperService(WireHelperService wireHelperService) {
        if (Objects.isNull(this.wireHelperService)) {
            this.wireHelperService = wireHelperService;
        }
    }

    public void unbindWireHelperService(WireHelperService wireHelperService) {
        if (this.wireHelperService == wireHelperService) {
            this.wireHelperService = null;
        }
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        logger.debug("Activating DB Wire Record Store...");
        this.wireRecordStoreOptions = new H2DbWireRecordStoreOptions(properties);
        this.wireSupport = this.wireHelperService.newWireSupport((WireComponent)this, componentContext.getServiceReference());
        if (Objects.nonNull(this.dbService)) {
            this.reconcileDB(this.wireRecordStoreOptions.getTableName());
        }
        logger.debug("Activating DB Wire Record Store... Done");
    }

    public synchronized void updated(Map<String, Object> properties) {
        logger.debug("Updating DB Wire Record Store...");
        this.wireRecordStoreOptions = new H2DbWireRecordStoreOptions(properties);
        this.reconcileDB(this.wireRecordStoreOptions.getTableName());
        logger.debug("Updating DB Wire Record Store... Done");
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.debug("Deactivating DB Wire Record Store...");
        this.dbHelper = null;
        this.dbService = null;
        this.wireRecordStoreOptions = null;
        logger.debug("Deactivating DB Wire Record Store... Done");
    }

    private void truncate() {
        int noOfRecordsToKeep = this.wireRecordStoreOptions.getNoOfRecordsToKeep();
        this.truncate(noOfRecordsToKeep);
    }

    private void truncate(int noOfRecordsToKeep) {
        String tableName = this.wireRecordStoreOptions.getTableName();
        String sqlTableName = this.dbHelper.sanitizeSqlTableAndColumnName(tableName);
        int tableSize = this.wireRecordStoreOptions.getMaximumTableSize();
        try {
            this.dbHelper.withConnection(c -> {
                String catalog = c.getCatalog();
                DatabaseMetaData dbMetaData = c.getMetaData();
                Throwable throwable = null;
                Object var9_10 = null;
                try (ResultSet rsTbls = dbMetaData.getTables(catalog, null, tableName, TABLE_TYPE);){
                    if (rsTbls.next()) {
                        if (noOfRecordsToKeep == 0) {
                            logger.info("Truncating table {}...", (Object)sqlTableName);
                            this.dbHelper.execute(c, MessageFormat.format(SQL_TRUNCATE_TABLE, sqlTableName), new Integer[0]);
                        } else {
                            logger.info("Partially emptying table {}", (Object)sqlTableName);
                            this.dbHelper.execute(c, MessageFormat.format(SQL_DELETE_RANGE_TABLE, sqlTableName, Integer.toString(tableSize - noOfRecordsToKeep)), new Integer[0]);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                return null;
            });
        }
        catch (SQLException sqlException) {
            logger.error("Error in truncating the table {}...", (Object)sqlTableName, (Object)sqlException);
        }
    }

    private int getTableSize() throws SQLException {
        String tableName = this.wireRecordStoreOptions.getTableName();
        String sqlTableName = this.dbHelper.sanitizeSqlTableAndColumnName(tableName);
        return (Integer)this.dbHelper.withConnection(c -> {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                Integer n;
                ResultSet rset;
                Statement stmt;
                block16: {
                    block15: {
                        stmt = c.createStatement();
                        rset = stmt.executeQuery(MessageFormat.format(SQL_ROW_COUNT_TABLE, sqlTableName));
                        rset.next();
                        n = rset.getInt(1);
                        if (rset == null) break block15;
                        rset.close();
                    }
                    if (stmt == null) break block16;
                    stmt.close();
                }
                return n;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (rset != null) {
                                rset.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (stmt != null) {
                                stmt.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        });
    }

    public void consumersConnected(Wire[] wires) {
        this.wireSupport.consumersConnected(wires);
    }

    public synchronized void onWireReceive(WireEnvelope wireEvelope) {
        Objects.requireNonNull(wireEvelope, "Wire Envelope cannot be null");
        List records = wireEvelope.getRecords();
        if (this.dbHelper == null) {
            logger.warn("H2DbService instance not attached");
            return;
        }
        try {
            if (this.getTableSize() >= this.wireRecordStoreOptions.getMaximumTableSize()) {
                this.truncate();
            }
        }
        catch (SQLException sQLException) {
            logger.warn("Exception while trying to clean db");
        }
        for (WireRecord wireRecord : records) {
            this.store(wireRecord);
        }
        this.wireSupport.emit(records);
    }

    private void store(WireRecord wireRecord) {
        Objects.requireNonNull(wireRecord, "Wire Record cannot be null");
        int retryCount = 0;
        String tableName = this.wireRecordStoreOptions.getTableName();
        while (true) {
            try {
                this.insertDataRecord(tableName, wireRecord);
            }
            catch (SQLException e) {
                logger.error("Insertion failed. Reconciling Table and Columns...", (Throwable)e);
                this.reconcileDB(wireRecord, tableName);
                if (++retryCount < 2) continue;
            }
            break;
        }
    }

    private void reconcileDB(WireRecord wireRecord, String tableName) {
        try {
            if (Objects.nonNull(tableName) && !tableName.isEmpty()) {
                this.reconcileTable(tableName);
                this.reconcileColumns(tableName, wireRecord);
            }
        }
        catch (SQLException ee) {
            logger.error("Error while storing Wire Records...", (Throwable)ee);
        }
    }

    private synchronized void reconcileDB(String tableName) {
        try {
            if (Objects.nonNull(this.dbHelper) && Objects.nonNull(tableName) && !tableName.isEmpty()) {
                this.reconcileTable(tableName);
            }
        }
        catch (SQLException ee) {
            logger.error("Error while storing Wire Records...", (Throwable)ee);
        }
    }

    private void reconcileTable(String tableName) throws SQLException {
        Objects.requireNonNull(tableName, "Table name cannot be null");
        String sqlTableName = this.dbHelper.sanitizeSqlTableAndColumnName(tableName);
        this.dbHelper.withConnection(c -> {
            String catalog = c.getCatalog();
            DatabaseMetaData dbMetaData = c.getMetaData();
            Throwable throwable = null;
            Object var7_8 = null;
            try (ResultSet rsTbls = dbMetaData.getTables(catalog, null, this.wireRecordStoreOptions.getTableName(), TABLE_TYPE);){
                if (!rsTbls.next()) {
                    logger.info("Creating table {}...", (Object)sqlTableName);
                    this.dbHelper.execute(c, MessageFormat.format(SQL_CREATE_TABLE, sqlTableName), new Integer[0]);
                    this.createIndex(this.dbHelper.sanitizeSqlTableAndColumnName(String.valueOf(tableName) + "_TIMESTAMP"), sqlTableName, "(TIMESTAMP DESC)");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return null;
        });
    }

    private void createIndex(String indexname, String table, String order) throws SQLException {
        this.dbHelper.withConnection(c -> {
            this.dbHelper.execute(c, MessageFormat.format(SQL_CREATE_TABLE_INDEX, indexname, table, order), new Integer[0]);
            return null;
        });
        logger.info("Index {} created, order is {}", (Object)indexname, (Object)order);
    }

    private void reconcileColumns(String tableName, WireRecord wireRecord) throws SQLException {
        Objects.requireNonNull(tableName, "Table name cannot be null");
        Objects.requireNonNull(wireRecord, "Wire Record cannot be null");
        Map columns = CollectionUtil.newHashMap();
        this.dbHelper.withConnection(c -> {
            String catalog = c.getCatalog();
            DatabaseMetaData dbMetaData = c.getMetaData();
            Throwable throwable = null;
            Iterator iterator = null;
            try (ResultSet rsColumns = dbMetaData.getColumns(catalog, null, tableName, null);){
                while (rsColumns.next()) {
                    String colName = rsColumns.getString(COLUMN_NAME);
                    String sqlColName = this.dbHelper.sanitizeSqlTableAndColumnName(colName);
                    int colType = rsColumns.getInt(DATA_TYPE);
                    columns.put(sqlColName, colType);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            for (Map.Entry entry : wireRecord.getProperties().entrySet()) {
                String sqlColName = this.dbHelper.sanitizeSqlTableAndColumnName((String)entry.getKey());
                Integer sqlColType = (Integer)columns.get(sqlColName);
                H2DbDataTypeMapper.JdbcType jdbcType = H2DbDataTypeMapper.getJdbcType(((TypedValue)entry.getValue()).getType());
                String sqlTableName = this.dbHelper.sanitizeSqlTableAndColumnName(tableName);
                if (Objects.isNull(sqlColType)) {
                    this.dbHelper.execute(c, MessageFormat.format(SQL_ADD_COLUMN, sqlTableName, sqlColName, jdbcType.getTypeString()), new Integer[0]);
                    continue;
                }
                if (sqlColType.intValue() == jdbcType.getType()) continue;
                this.dbHelper.execute(c, MessageFormat.format(SQL_DROP_COLUMN, sqlTableName, sqlColName), new Integer[0]);
                this.dbHelper.execute(c, MessageFormat.format(SQL_ADD_COLUMN, sqlTableName, sqlColName, jdbcType.getTypeString()), new Integer[0]);
            }
            return null;
        });
    }

    private void insertDataRecord(String tableName, WireRecord wireRecord) throws SQLException {
        Objects.requireNonNull(tableName, "Table name cannot be null");
        Objects.requireNonNull(wireRecord, "Wire Record cannot be null");
        Map wireRecordProperties = wireRecord.getProperties();
        this.dbHelper.withConnection(c -> {
            Throwable throwable = null;
            Object var5_6 = null;
            try (PreparedStatement stmt = this.prepareStatement(c, tableName, wireRecordProperties, new Date().getTime());){
                stmt.execute();
                c.commit();
                return null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
        logger.debug("Stored typed value");
    }

    private PreparedStatement prepareStatement(Connection connection, String tableName, Map<String, TypedValue<?>> properties, long timestamp) throws SQLException {
        String sqlTableName = this.dbHelper.sanitizeSqlTableAndColumnName(tableName);
        StringBuilder sbCols = new StringBuilder();
        StringBuilder sbVals = new StringBuilder();
        sbCols.append("TIMESTAMP");
        sbVals.append("?");
        int i = 2;
        for (Map.Entry<String, TypedValue<?>> entry : properties.entrySet()) {
            String sqlColName = this.dbHelper.sanitizeSqlTableAndColumnName(entry.getKey());
            sbCols.append(", ").append(sqlColName);
            sbVals.append(", ?");
        }
        logger.debug("Storing data into table {}...", (Object)sqlTableName);
        String sqlInsert = MessageFormat.format(SQL_INSERT_RECORD, sqlTableName, sbCols.toString(), sbVals.toString());
        PreparedStatement stmt = connection.prepareStatement(sqlInsert);
        stmt.setLong(1, timestamp);
        for (Map.Entry<String, TypedValue<?>> entry : properties.entrySet()) {
            DataType dataType = entry.getValue().getType();
            TypedValue<?> value = entry.getValue();
            switch (dataType) {
                case BOOLEAN: {
                    stmt.setBoolean(i, ((BooleanValue)value).getValue());
                    break;
                }
                case FLOAT: {
                    stmt.setFloat(i, ((FloatValue)value).getValue().floatValue());
                    break;
                }
                case DOUBLE: {
                    stmt.setDouble(i, ((DoubleValue)value).getValue());
                    break;
                }
                case INTEGER: {
                    stmt.setInt(i, ((IntegerValue)value).getValue());
                    break;
                }
                case LONG: {
                    stmt.setLong(i, ((LongValue)value).getValue());
                    break;
                }
                case BYTE_ARRAY: {
                    byte[] byteArrayValue = ((ByteArrayValue)value).getValue();
                    ByteArrayInputStream is = new ByteArrayInputStream(byteArrayValue);
                    stmt.setBlob(i, is);
                    break;
                }
                case STRING: {
                    stmt.setString(i, ((StringValue)value).getValue());
                    break;
                }
            }
            ++i;
        }
        return stmt;
    }

    public Object polled(Wire wire) {
        return this.wireSupport.polled(wire);
    }

    public void producersConnected(Wire[] wires) {
        this.wireSupport.producersConnected(wires);
    }

    public void updated(Wire wire, Object value) {
        this.wireSupport.updated(wire, value);
    }
}

