/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.useradmin.store;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.felix.useradmin.RoleFactory;
import org.apache.felix.useradmin.RoleRepositoryStore;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.internal.useradmin.store.DeserializationException;
import org.eclipse.kura.internal.useradmin.store.RoleRepositoryStoreOptions;
import org.eclipse.kura.internal.useradmin.store.RoleSerializer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.useradmin.Group;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;
import org.osgi.service.useradmin.UserAdmin;
import org.osgi.service.useradmin.UserAdminEvent;
import org.osgi.service.useradmin.UserAdminListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleRepositoryStoreImpl
implements RoleRepositoryStore,
UserAdminListener,
ConfigurableComponent {
    private static final String INTERNAL_UPDATE_ID_PROP_NAME = "internal.update.id";
    private static final Logger logger = LoggerFactory.getLogger(RoleRepositoryStoreImpl.class);
    private Map<String, Role> roles = new TreeMap<String, Role>();
    private RoleRepositoryStoreOptions options;
    long nextUpdateId = 0L;
    private final Set<Long> updateIds = new HashSet<Long>();
    private ConfigurationService configurationService;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private Optional<ScheduledFuture<?>> storeTask = Optional.empty();

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void activate(Map<String, Object> properties) {
        logger.info("activating...");
        this.doUpdate(properties, RoleFactory::createRole);
        logger.info("activating...done");
    }

    public synchronized void update(Map<String, Object> properties) {
        RoleSerializer.RoleBuilder roleBuilder;
        if (this.isSelfUpdate(properties)) {
            logger.info("Ignoring self update");
            return;
        }
        if (this.storeTask.isPresent() || !this.updateIds.isEmpty()) {
            logger.info("Ignoring update since there are uncommitted changes");
            return;
        }
        logger.info("updating...");
        BundleContext bundleContext = FrameworkUtil.getBundle(RoleRepositoryStoreImpl.class).getBundleContext();
        ServiceReference userAdminRef = bundleContext.getServiceReference(UserAdmin.class);
        UserAdmin userAdmin = userAdminRef != null ? (UserAdmin)bundleContext.getService(userAdminRef) : null;
        if (userAdmin != null) {
            roleBuilder = (type, name) -> userAdmin.createRole(name, type);
            HashSet<String> roleNames = new HashSet<String>(this.roles.keySet());
            for (String name2 : roleNames) {
                userAdmin.removeRole(name2);
            }
        } else {
            roleBuilder = RoleFactory::createRole;
        }
        try {
            this.doUpdate(properties, roleBuilder);
        }
        finally {
            if (userAdmin != null) {
                bundleContext.ungetService(userAdminRef);
            }
        }
        logger.info("updating...done");
    }

    public void deactivate() {
        logger.info("deactivating...");
        this.executorService.shutdown();
        logger.info("deactivating...done");
    }

    public synchronized Role addRole(String name, int type) throws Exception {
        if (this.roles.containsKey(name)) {
            return null;
        }
        Role role = RoleFactory.createRole((int)type, (String)name);
        this.roles.put(name, role);
        return role;
    }

    public synchronized Role getRoleByName(String name) throws Exception {
        return this.roles.get(name);
    }

    public synchronized Role[] getRoles(String filterString) throws Exception {
        Optional<Object> filter = filterString != null ? Optional.of(FrameworkUtil.createFilter((String)filterString)) : Optional.empty();
        ArrayList<Role> result = new ArrayList<Role>();
        for (Role role : this.roles.values()) {
            if (filter.isPresent() && !((Filter)filter.get()).match(role.getProperties())) continue;
            result.add(role);
        }
        return result.toArray(new Role[result.size()]);
    }

    public synchronized Role removeRole(String role) throws Exception {
        return Optional.ofNullable(this.roles.remove(role)).orElse(null);
    }

    private boolean isSelfUpdate(Map<String, Object> properties) {
        long updateId;
        Object id = properties.get(INTERNAL_UPDATE_ID_PROP_NAME);
        if (id instanceof Long && this.updateIds.contains(updateId = ((Long)id).longValue())) {
            this.updateIds.remove(updateId);
            return true;
        }
        return false;
    }

    public long getNextUpdateId() {
        long updateId = this.nextUpdateId++;
        this.updateIds.add(updateId);
        return updateId;
    }

    private void doUpdate(Map<String, Object> properties, RoleSerializer.RoleBuilder roleBuilder) {
        this.options = new RoleRepositoryStoreOptions(properties);
        try {
            this.roles = this.decode(this.options, roleBuilder);
        }
        catch (Exception e) {
            logger.warn("failed to deserialize roles", (Throwable)e);
        }
    }

    private synchronized void scheduleStore() {
        if (this.storeTask.isPresent()) {
            this.storeTask.get().cancel(false);
            this.storeTask = Optional.empty();
        }
        this.storeTask = Optional.of(this.executorService.schedule(this::storeNow, this.options.getWriteDelayMs(), TimeUnit.MILLISECONDS));
    }

    private synchronized void storeNow() {
        try {
            JsonArray rolesArray = new JsonArray();
            JsonArray usersArray = new JsonArray();
            JsonArray groupsArray = new JsonArray();
            for (Role role : this.roles.values()) {
                int type = role.getType();
                if (type == 0) {
                    rolesArray.add((JsonValue)RoleSerializer.serializeRole(role));
                    continue;
                }
                if (type == 1) {
                    usersArray.add((JsonValue)RoleSerializer.serializeRole(role));
                    continue;
                }
                if (type != 2) continue;
                groupsArray.add((JsonValue)RoleSerializer.serializeRole(role));
            }
            RoleRepositoryStoreOptions newOptions = new RoleRepositoryStoreOptions(rolesArray.toString(), usersArray.toString(), groupsArray.toString(), this.options.getWriteDelayMs());
            if (newOptions.equals(this.options)) {
                logger.info("update would not change current configuration, skipping");
                return;
            }
            try {
                Map<String, Object> properties = newOptions.toProperties();
                properties.put(INTERNAL_UPDATE_ID_PROP_NAME, this.getNextUpdateId());
                this.configurationService.updateConfiguration(RoleRepositoryStoreImpl.class.getName(), properties);
            }
            catch (Exception e) {
                logger.warn("Failed to store configuration", (Throwable)e);
            }
        }
        finally {
            this.storeTask = Optional.empty();
        }
    }

    private final Map<String, Role> decode(RoleRepositoryStoreOptions options, RoleSerializer.RoleBuilder roleBuilder) throws DeserializationException {
        try {
            TreeMap<String, Role> result = new TreeMap<String, Role>();
            this.decode(Json.parse((String)options.getRolesConfig()).asArray(), Role.class, result, roleBuilder);
            this.decode(Json.parse((String)options.getUsersConfig()).asArray(), User.class, result, roleBuilder);
            JsonArray groups = Json.parse((String)options.getGroupsConfig()).asArray();
            this.decode(groups, Group.class, result, roleBuilder);
            for (JsonValue member : groups) {
                RoleSerializer.assignMembers(member.asObject(), result);
            }
            return result;
        }
        catch (DeserializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeserializationException("failed to deserialize role repository", e);
        }
    }

    private void decode(JsonArray array, Class<? extends Role> classz, Map<String, Role> target, RoleSerializer.RoleBuilder roleBuilder) throws DeserializationException {
        for (JsonValue member : array) {
            Role role = RoleSerializer.deserializeRole(classz, member.asObject(), roleBuilder);
            target.put(role.getName(), role);
        }
    }

    public void roleChanged(UserAdminEvent arg0) {
        logger.debug("received event");
        this.scheduleStore();
    }
}

