/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Stream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.audit.AuditConstants;
import org.eclipse.kura.audit.AuditContext;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.SelfConfiguringComponent;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.system.SystemService;
import org.eclipse.kura.web.ConsoleOptions;
import org.eclipse.kura.web.UserManager;
import org.eclipse.kura.web.api.ClientExtensionBundle;
import org.eclipse.kura.web.server.GwtCertificatesServiceImpl;
import org.eclipse.kura.web.server.GwtCloudConnectionServiceImpl;
import org.eclipse.kura.web.server.GwtComponentServiceImpl;
import org.eclipse.kura.web.server.GwtDeviceServiceImpl;
import org.eclipse.kura.web.server.GwtDriverAndAssetServiceImpl;
import org.eclipse.kura.web.server.GwtEventServiceImpl;
import org.eclipse.kura.web.server.GwtExtensionServiceImpl;
import org.eclipse.kura.web.server.GwtKeystoreServiceImpl;
import org.eclipse.kura.web.server.GwtLoginInfoServiceImpl;
import org.eclipse.kura.web.server.GwtNetworkServiceImpl;
import org.eclipse.kura.web.server.GwtPackageServiceImpl;
import org.eclipse.kura.web.server.GwtPasswordAuthenticationServiceImpl;
import org.eclipse.kura.web.server.GwtSecurityServiceImpl;
import org.eclipse.kura.web.server.GwtSecurityTokenServiceImpl;
import org.eclipse.kura.web.server.GwtSessionServiceImpl;
import org.eclipse.kura.web.server.GwtSnapshotServiceImpl;
import org.eclipse.kura.web.server.GwtSslManagerServiceImpl;
import org.eclipse.kura.web.server.GwtStatusServiceImpl;
import org.eclipse.kura.web.server.GwtUserServiceImpl;
import org.eclipse.kura.web.server.GwtWireGraphServiceImpl;
import org.eclipse.kura.web.server.KuraRemoteServiceServlet;
import org.eclipse.kura.web.server.servlet.ChannelServlet;
import org.eclipse.kura.web.server.servlet.DeviceSnapshotsServlet;
import org.eclipse.kura.web.server.servlet.FileServlet;
import org.eclipse.kura.web.server.servlet.LogServlet;
import org.eclipse.kura.web.server.servlet.RedirectServlet;
import org.eclipse.kura.web.server.servlet.SendStatusServlet;
import org.eclipse.kura.web.server.servlet.SkinServlet;
import org.eclipse.kura.web.server.servlet.SslAuthenticationServlet;
import org.eclipse.kura.web.server.servlet.WiresBlinkServlet;
import org.eclipse.kura.web.server.servlet.WiresSnapshotServlet;
import org.eclipse.kura.web.session.Attributes;
import org.eclipse.kura.web.session.BaseSecurityHandler;
import org.eclipse.kura.web.session.CreateSessionSecurityHandler;
import org.eclipse.kura.web.session.HttpContextImpl;
import org.eclipse.kura.web.session.RoutingSecurityHandler;
import org.eclipse.kura.web.session.SecurityHandler;
import org.eclipse.kura.web.session.SessionAutorizationSecurityHandler;
import org.eclipse.kura.web.session.SessionExpirationSecurityHandler;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventProperties;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.service.useradmin.UserAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Console
implements SelfConfiguringComponent,
org.eclipse.kura.web.api.Console {
    private static final String EVENT_PATH = "/event";
    public static final String ADMIN_ROOT = "/admin";
    private static final String LOGIN_MODULE_PATH = "/admin/login";
    private static final String DENALI_MODULE_PATH = "/admin/denali";
    private static final String AUTH_RESOURCE_PATH = "/admin/auth.html";
    private static final String CONSOLE_RESOURCE_PATH = "/admin/denali.html";
    private static final String AUTH_PATH = "/admin/auth";
    private static final String CONSOLE_PATH = "/admin/console";
    private static final String PASSWORD_AUTH_PATH = "/admin/login/password";
    private static final String CERT_AUTH_PATH = "/admin/login/cert";
    private static final Logger logger = LoggerFactory.getLogger(Console.class);
    private String appRoot;
    private int sessionMaxInactiveInterval;
    private ComponentContext componentContext;
    private HttpService httpService;
    private SystemService systemService;
    private CryptoService cryptoService;
    private UserAdmin userAdmin;
    private EventAdmin eventAdmin;
    private UserManager userManager;
    private GwtEventServiceImpl eventService;
    private WiresBlinkServlet wiresBlinkService;
    private HttpContext sessionContext;
    private final Set<ServletRegistration> securedServlets = new CopyOnWriteArraySet<ServletRegistration>();
    private final Set<ServletRegistration> loginServlets = new CopyOnWriteArraySet<ServletRegistration>();
    private final Set<ClientExtensionBundle> consoleExtensions = new CopyOnWriteArraySet<ClientExtensionBundle>();
    private final Set<ClientExtensionBundle> loginExtensions = new CopyOnWriteArraySet<ClientExtensionBundle>();
    private static Console instance;
    private static ConsoleOptions consoleOptions;
    final Set<String> authenticationPaths = new HashSet<String>(Arrays.asList("/admin/auth", "/admin/login/password", "/admin/login/cert"));

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    public void setEventAdminService(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void setUserAdmin(UserAdmin userAdmin) {
        this.userAdmin = userAdmin;
    }

    protected void activate(ComponentContext context, Map<String, Object> properties) {
        Console.setInstance(this);
        try {
            Console.setConsoleOptions(properties == null ? ConsoleOptions.defaultConfiguration() : ConsoleOptions.fromProperties(properties));
        }
        catch (Exception e) {
            logger.warn("failed to build console options", (Throwable)e);
            return;
        }
        boolean webEnabled = Boolean.parseBoolean(this.systemService.getKuraWebEnabled());
        if (!webEnabled) {
            logger.info("Web interface disabled in Kura properties file.");
            return;
        }
        logger.info("activate...");
        this.setComponentContext(context);
        this.userManager = new UserManager(this.userAdmin, this.cryptoService);
        this.doUpdate(properties);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("kura.version", this.systemService.getKuraVersion());
        EventProperties eventProps = new EventProperties(props);
        try {
            logger.info("initializing useradmin...");
            this.userManager.update(consoleOptions);
            logger.info("initializing useradmin...done");
        }
        catch (Exception e) {
            logger.warn("failed to update UserAdmin", (Throwable)e);
        }
        logger.info("postInstalledEvent() :: posting KuraConfigReadyEvent");
        this.eventAdmin.postEvent(new Event("org/eclipse/kura/configuration/ConfigEvent/READY", (Map)eventProps));
    }

    private void setAppRoot(String propertiesAppRoot) {
        this.appRoot = propertiesAppRoot;
    }

    private void setSessionMaxInactiveInterval(int sessionMaxInactiveInterval) {
        this.sessionMaxInactiveInterval = sessionMaxInactiveInterval;
    }

    private void setComponentContext(ComponentContext context) {
        this.componentContext = context;
    }

    protected void updated(Map<String, Object> properties) {
        boolean webEnabled = Boolean.parseBoolean(this.systemService.getKuraWebEnabled());
        if (!webEnabled) {
            return;
        }
        this.unregisterServlet();
        this.doUpdate(properties);
    }

    private void doUpdate(Map<String, Object> properties) {
        ConsoleOptions options;
        try {
            options = properties == null ? ConsoleOptions.defaultConfiguration() : ConsoleOptions.fromProperties(properties);
        }
        catch (Exception e) {
            logger.warn("failed to build console options", (Throwable)e);
            return;
        }
        Console.setConsoleOptions(options);
        try {
            this.userManager.update(consoleOptions);
        }
        catch (Exception e) {
            logger.warn("Error Updating Web properties", (Throwable)e);
        }
        this.setAppRoot(options.getAppRoot());
        this.setSessionMaxInactiveInterval(options.getSessionMaxInactivityInterval());
        try {
            this.initHTTPService();
        }
        catch (ServletException | NamespaceException e) {
            logger.warn("Error Registering Web Resources", e);
        }
    }

    protected void deactivate(BundleContext context) {
        logger.info("deactivate...");
        this.unregisterServlet();
    }

    private synchronized void unregisterServlet() {
        this.httpService.unregister("/");
        this.httpService.unregister(ADMIN_ROOT);
        this.httpService.unregister(CONSOLE_PATH);
        this.httpService.unregister(AUTH_PATH);
        this.httpService.unregister(AUTH_RESOURCE_PATH);
        this.httpService.unregister(CONSOLE_RESOURCE_PATH);
        this.httpService.unregister(PASSWORD_AUTH_PATH);
        this.httpService.unregister(CERT_AUTH_PATH);
        this.httpService.unregister("/admin/login/loginInfo");
        this.httpService.unregister("/admin/denali/session");
        this.httpService.unregister("/admin/denali/xsrf");
        this.httpService.unregister("/admin/denali/status");
        this.httpService.unregister("/admin/denali/device");
        this.httpService.unregister("/admin/denali/network");
        this.httpService.unregister("/admin/denali/component");
        this.httpService.unregister("/admin/denali/package");
        this.httpService.unregister("/admin/denali/snapshot");
        this.httpService.unregister("/admin/denali/certificate");
        this.httpService.unregister("/admin/denali/security");
        this.httpService.unregister("/admin/denali/users");
        this.httpService.unregister("/admin/denali/file");
        this.httpService.unregister("/admin/denali/device_snapshots");
        this.httpService.unregister("/admin/denali/assetsUpDownload");
        this.httpService.unregister("/admin/denali/log");
        this.httpService.unregister("/admin/denali/skin");
        this.httpService.unregister("/admin/denali/cloudservices");
        this.httpService.unregister("/admin/denali/wires");
        this.httpService.unregister("/admin/denali/wiresSnapshot");
        this.httpService.unregister("/admin/denali/assetservices");
        this.httpService.unregister("/admin/denali/extension");
        this.httpService.unregister("/admin/denali/ssl");
        this.httpService.unregister("/admin/denali/keystore");
        this.httpService.unregister("/admin/login/extension");
        this.wiresBlinkService.stop();
        this.httpService.unregister("/admin/sse");
        this.eventService.stop();
        this.httpService.unregister("/admin/denali/event");
        for (ServletRegistration reg : this.securedServlets) {
            this.httpService.unregister(reg.path);
        }
        for (ServletRegistration reg : this.loginServlets) {
            this.httpService.unregister(reg.path);
        }
    }

    public static Console instance() {
        return instance;
    }

    private static void setInstance(Console instance) {
        Console.instance = instance;
    }

    public static ConsoleOptions getConsoleOptions() {
        return consoleOptions;
    }

    private static void setConsoleOptions(ConsoleOptions options) {
        consoleOptions = options;
    }

    public BundleContext getBundleContext() {
        return this.componentContext.getBundleContext();
    }

    public String getApplicationRoot() {
        return this.appRoot;
    }

    public EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    public HttpSession createSession(HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.setMaxInactiveInterval(this.sessionMaxInactiveInterval * 60);
        session.setAttribute(Attributes.LAST_ACTIVITY.getValue(), (Object)System.currentTimeMillis());
        return session;
    }

    private HttpContext initSessionContext(HttpContext defaultContext) {
        HashSet<String> eventPaths = new HashSet<String>(Arrays.asList("/admin/denali/event", "/sse"));
        SecurityHandler baseHandler = SecurityHandler.chain(new BaseSecurityHandler());
        SessionAutorizationSecurityHandler sessionAuthHandler = new SessionAutorizationSecurityHandler();
        SessionExpirationSecurityHandler sessionExpirationHandler = new SessionExpirationSecurityHandler();
        SecurityHandler defaultHandler = SecurityHandler.chain(baseHandler, sessionAuthHandler, sessionExpirationHandler);
        RoutingSecurityHandler routingHandler = new RoutingSecurityHandler(defaultHandler.sendErrorOnFailure(401));
        routingHandler.addRouteHandler(p -> this.authenticationPaths.contains(p) || this.loginServlets.stream().anyMatch(r -> ((ServletRegistration)r).path.contentEquals((CharSequence)p)), SecurityHandler.chain(baseHandler, new CreateSessionSecurityHandler()));
        routingHandler.addRouteHandler(eventPaths::contains, SecurityHandler.chain(baseHandler, sessionAuthHandler).sendErrorOnFailure(401));
        routingHandler.addRouteHandler(CONSOLE_PATH::equals, defaultHandler.redirectOnFailure(AUTH_PATH));
        return new HttpContextImpl(routingHandler, defaultContext);
    }

    private HttpContext initResourceContext(HttpContext defaultContext) {
        return new HttpContextImpl(new BaseSecurityHandler(), defaultContext);
    }

    private synchronized void initHTTPService() throws NamespaceException, ServletException {
        this.eventService = new GwtEventServiceImpl();
        this.wiresBlinkService = new WiresBlinkServlet();
        HttpContext defaultContext = this.httpService.createDefaultHttpContext();
        HttpContext resourceContext = this.initResourceContext(defaultContext);
        this.sessionContext = this.initSessionContext(defaultContext);
        this.httpService.registerResources(ADMIN_ROOT, "www", resourceContext);
        this.httpService.registerResources(AUTH_PATH, "www/auth.html", this.sessionContext);
        this.httpService.registerResources(CONSOLE_PATH, "www/denali.html", this.sessionContext);
        this.httpService.registerServlet("/admin/login/loginInfo", (Servlet)new GwtLoginInfoServiceImpl(), null, resourceContext);
        this.httpService.registerServlet("/", (Servlet)new RedirectServlet("/"::equals, this.appRoot), null, resourceContext);
        this.httpService.registerServlet(AUTH_RESOURCE_PATH, (Servlet)new SendStatusServlet(404), null, resourceContext);
        this.httpService.registerServlet(CONSOLE_RESOURCE_PATH, (Servlet)new SendStatusServlet(404), null, resourceContext);
        this.httpService.registerServlet(PASSWORD_AUTH_PATH, (Servlet)new GwtPasswordAuthenticationServiceImpl(this.userManager, CONSOLE_PATH), null, this.sessionContext);
        this.httpService.registerServlet(CERT_AUTH_PATH, (Servlet)new SslAuthenticationServlet(CONSOLE_PATH, this.userManager), null, this.sessionContext);
        this.httpService.registerServlet("/admin/denali/keystore", (Servlet)new GwtKeystoreServiceImpl(), null, this.sessionContext);
        this.httpService.registerServlet("/admin/denali/ssl", (Servlet)new GwtSslManagerServiceImpl(), null, this.sessionContext);
        this.httpService.registerServlet("/admin/denali/extension", (Servlet)new GwtExtensionServiceImpl(), null, resourceContext);
        this.httpService.registerServlet("/admin/login/extension", (Servlet)new GwtExtensionServiceImpl(), null, resourceContext);
        this.httpService.registerServlet("/admin/denali/session", (Servlet)new GwtSessionServiceImpl(this.userManager), null, this.sessionContext);
        this.httpService.registerServlet("/admin/denali/xsrf", (Servlet)new GwtSecurityTokenServiceImpl(), null, this.sessionContext);
        this.httpService.registerServlet("/admin/denali/status", (Servlet)new GwtStatusServiceImpl(), null, this.sessionContext);
        this.httpService.registerServlet("/admin/denali/device", (Servlet)new GwtDeviceServiceImpl(), null, this.sessionContext);
        this.httpService.registerServlet("/admin/denali/network", (Servlet)new GwtNetworkServiceImpl(), null, this.sessionContext);
        this.httpService.registerServlet("/admin/denali/component", (Servlet)new GwtComponentServiceImpl(), null, this.sessionContext);
        this.httpService.registerServlet("/admin/denali/package", (Servlet)new GwtPackageServiceImpl(), null, this.sessionContext);
        this.httpService.registerServlet("/admin/denali/snapshot", (Servlet)new GwtSnapshotServiceImpl(), null, this.sessionContext);
        this.httpService.registerServlet("/admin/denali/certificate", (Servlet)new GwtCertificatesServiceImpl(), null, this.sessionContext);
        this.httpService.registerServlet("/admin/denali/security", (Servlet)new GwtSecurityServiceImpl(), null, this.sessionContext);
        this.httpService.registerServlet("/admin/denali/users", (Servlet)new GwtUserServiceImpl(this.userManager), null, this.sessionContext);
        this.httpService.registerServlet("/admin/denali/file", (Servlet)new FileServlet(), null, this.sessionContext);
        this.httpService.registerServlet("/admin/denali/device_snapshots", (Servlet)new DeviceSnapshotsServlet(), null, this.sessionContext);
        this.httpService.registerServlet("/admin/denali/assetsUpDownload", (Servlet)new ChannelServlet(), null, this.sessionContext);
        this.httpService.registerServlet("/admin/denali/log", (Servlet)new LogServlet(), null, resourceContext);
        this.httpService.registerServlet("/admin/denali/skin", (Servlet)new SkinServlet(), null, resourceContext);
        this.httpService.registerServlet("/admin/denali/cloudservices", (Servlet)new GwtCloudConnectionServiceImpl(), null, this.sessionContext);
        this.httpService.registerServlet("/admin/denali/wires", (Servlet)new GwtWireGraphServiceImpl(), null, this.sessionContext);
        this.httpService.registerServlet("/admin/denali/wiresSnapshot", (Servlet)new WiresSnapshotServlet(), null, this.sessionContext);
        this.httpService.registerServlet("/admin/denali/assetservices", (Servlet)new GwtDriverAndAssetServiceImpl(), null, this.sessionContext);
        this.httpService.registerServlet("/admin/sse", (Servlet)this.wiresBlinkService, null, this.sessionContext);
        this.httpService.registerServlet("/admin/denali/event", (Servlet)this.eventService, null, this.sessionContext);
        for (ServletRegistration reg : this.securedServlets) {
            this.httpService.registerServlet(reg.path, reg.servlet, null, this.sessionContext);
        }
        for (ServletRegistration reg : this.loginServlets) {
            this.httpService.registerServlet(reg.path, reg.servlet, null, this.sessionContext);
        }
        this.eventService.start();
    }

    public Set<ClientExtensionBundle> getConsoleExtensions() {
        return this.consoleExtensions;
    }

    public Set<ClientExtensionBundle> getLoginExtensions() {
        return this.loginExtensions;
    }

    public Set<String> getBuiltinAuthenticationMethods() {
        return new HashSet<String>(Arrays.asList("Certificate", "Password"));
    }

    public Set<String> getAuthenticationMethods() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.add("Password");
        result.add("Certificate");
        Stream.concat(this.loginExtensions.stream(), this.consoleExtensions.stream()).forEach(b -> {
            for (ClientExtensionBundle bundle : this.loginExtensions) {
                Set<String> providedMethods = bundle.getProvidedAuthenticationMethods();
                if (providedMethods == null) continue;
                result.addAll(providedMethods);
            }
        });
        return result;
    }

    private void refreshOptions() {
        try {
            Console.setConsoleOptions(ConsoleOptions.fromProperties(Console.getConsoleOptions().getConfiguration().getConfigurationProperties()));
        }
        catch (Exception e) {
            logger.warn("Failed to update options", (Throwable)e);
        }
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    @Override
    public void registerConsoleExtensionBundle(ClientExtensionBundle extension) {
        this.consoleExtensions.add(extension);
        this.refreshOptions();
    }

    @Override
    public void unregisterConsoleExtensionBundle(ClientExtensionBundle extension) {
        this.consoleExtensions.remove(extension);
        this.refreshOptions();
    }

    @Override
    public void registerLoginExtensionBundle(ClientExtensionBundle extension) {
        this.loginExtensions.add(extension);
        this.refreshOptions();
    }

    @Override
    public void unregisterLoginExtensionBundle(ClientExtensionBundle extension) {
        this.loginExtensions.remove(extension);
        this.refreshOptions();
    }

    @Override
    public synchronized void registerSecuredServlet(String path, Servlet servlet) throws NamespaceException, ServletException {
        this.securedServlets.add(new ServletRegistration(path, servlet));
        this.httpService.registerServlet(path, servlet, null, this.sessionContext);
    }

    @Override
    public synchronized void registerLoginServlet(String path, Servlet servlet) throws NamespaceException, ServletException {
        this.loginServlets.add(new ServletRegistration(path, servlet));
        this.httpService.registerServlet(path, servlet, null, this.sessionContext);
        this.authenticationPaths.add(path);
    }

    @Override
    public synchronized void unregisterServlet(String path) throws NamespaceException, ServletException {
        this.securedServlets.removeIf(r -> ((ServletRegistration)r).path.contentEquals(path));
        this.loginServlets.removeIf(r -> ((ServletRegistration)r).path.contentEquals(path));
        this.httpService.unregister(path);
        this.authenticationPaths.remove(path);
    }

    @Override
    public String setAuthenticated(HttpSession session, String user, AuditContext context) {
        session.setAttribute(Attributes.AUTORIZED_USER.getValue(), (Object)user);
        context.getProperties().put(AuditConstants.KEY_IDENTITY.getValue(), user);
        session.setAttribute(Attributes.AUDIT_CONTEXT.getValue(), (Object)context);
        session.setAttribute(Attributes.CREDENTIALS_HASH.getValue(), this.userManager.getCredentialsHash(user));
        return CONSOLE_PATH;
    }

    @Override
    public AuditContext initAuditContext(HttpServletRequest req) {
        AuditContext auditContext;
        Object rawAuditContext;
        HttpSession session = req.getSession(false);
        String requestIp = req.getHeader("X-FORWARDED-FOR");
        if (Objects.isNull(requestIp)) {
            requestIp = req.getRemoteAddr();
        }
        Object object = rawAuditContext = session != null ? session.getAttribute(Attributes.AUDIT_CONTEXT.getValue()) : null;
        if (rawAuditContext instanceof AuditContext) {
            auditContext = ((AuditContext)rawAuditContext).copy();
            auditContext.getProperties().remove("rpc.method");
            auditContext.getProperties().put(AuditConstants.KEY_IP.getValue(), requestIp);
        } else {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(AuditConstants.KEY_IP.getValue(), requestIp);
            properties.put(AuditConstants.KEY_ENTRY_POINT.getValue(), "WebConsole");
            auditContext = new AuditContext(properties);
        }
        auditContext.getProperties().put("web.path", req.getRequestURI());
        return auditContext;
    }

    @Override
    public void checkXSRFToken(HttpServletRequest req, String token) throws KuraException {
        if (!KuraRemoteServiceServlet.isValidXSRFToken(req, token)) {
            throw new KuraException(KuraErrorCode.SECURITY_EXCEPTION);
        }
    }

    @Override
    public Optional<String> getUsername(HttpSession session) {
        return Optional.ofNullable(session.getAttribute(Attributes.AUTORIZED_USER.getValue())).map(String.class::cast);
    }

    public ComponentConfiguration getConfiguration() throws KuraException {
        return consoleOptions.getConfiguration();
    }

    private static final class ServletRegistration {
        private final String path;
        private final Servlet servlet;

        public ServletRegistration(String path, Servlet servlet) {
            this.path = path;
            this.servlet = servlet;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            result = 31 * result + (this.servlet == null ? 0 : this.servlet.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServletRegistration other = (ServletRegistration)obj;
            if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
                return false;
            }
            return this.servlet == other.servlet;
        }
    }
}

