/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.ai.triton.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraRuntimeException;

public class TritonServerServiceOptions {
    private static final String PROPERTY_ADDRESS = "server.address";
    private static final String PROPERTY_PORTS = "server.ports";
    private static final String PROPERTY_LOCAL_MODEL_REPOSITORY_PATH = "local.model.repository.path";
    private static final String PROPERTY_LOCAL_BACKENDS_PATH = "local.backends.path";
    private static final String PROPERTY_LOCAL_BACKENDS_CONFIG = "local.backends.config";
    private static final String PROPERTY_MODELS = "models";
    private static final String PROPERTY_LOCAL = "enable.local";
    private final Map<String, Object> properties;
    private final int httpPort;
    private final int grpcPort;
    private final int metricsPort;
    private final boolean isLocal;

    public TritonServerServiceOptions(Map<String, Object> properties) {
        Objects.requireNonNull(properties, "Properties cannot be null");
        this.properties = Collections.unmodifiableMap(new HashMap<String, Object>(properties));
        Object propertyPorts = this.properties.get(PROPERTY_PORTS);
        if (propertyPorts instanceof Integer[]) {
            Integer[] ports = (Integer[])propertyPorts;
            if (ports.length < 3) {
                throw new KuraRuntimeException(KuraErrorCode.INVALID_PARAMETER, new Object[]{PROPERTY_PORTS});
            }
            Integer[] integerArray = ports;
            int n = ports.length;
            int n2 = 0;
            while (n2 < n) {
                Integer port = integerArray[n2];
                Objects.requireNonNull(port, "port cannot be null");
                ++n2;
            }
            this.httpPort = ports[0];
            this.grpcPort = ports[1];
            this.metricsPort = ports[2];
        } else {
            this.httpPort = 5000;
            this.grpcPort = 5001;
            this.metricsPort = 5002;
        }
        Object propertyLocal = this.properties.get(PROPERTY_LOCAL);
        this.isLocal = propertyLocal instanceof Boolean ? (Boolean)propertyLocal : false;
    }

    public String getAddress() {
        String address = "";
        if (this.isLocal) {
            address = "localhost";
        } else {
            Object propertyAddress = this.properties.get(PROPERTY_ADDRESS);
            if (propertyAddress instanceof String) {
                address = ((String)propertyAddress).trim();
            }
        }
        return address;
    }

    public boolean isLocalEnabled() {
        return this.isLocal;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getGrpcPort() {
        return this.grpcPort;
    }

    public int getMetricsPort() {
        return this.metricsPort;
    }

    public String getModelRepositoryPath() {
        return this.getPath(PROPERTY_LOCAL_MODEL_REPOSITORY_PATH);
    }

    public String getBackendsPath() {
        return this.getPath(PROPERTY_LOCAL_BACKENDS_PATH);
    }

    public List<String> getBackendsConfigs() {
        List<String> backendsConfigs = new ArrayList<String>();
        Object propertyBackendsConfig = this.properties.get(PROPERTY_LOCAL_BACKENDS_CONFIG);
        if (propertyBackendsConfig instanceof String && !((String)propertyBackendsConfig).isEmpty()) {
            backendsConfigs = Arrays.asList(((String)propertyBackendsConfig).trim().split(";"));
        }
        return backendsConfigs;
    }

    public List<String> getModels() {
        List<String> models = new ArrayList<String>();
        Object propertyModels = this.properties.get(PROPERTY_MODELS);
        if (propertyModels instanceof String && !((String)propertyModels).isEmpty()) {
            models = Arrays.asList(((String)propertyModels).replace(" ", "").split(","));
        }
        return models;
    }

    private String getPath(String propertyName) {
        String path = "";
        Object propertyPath = this.properties.get(propertyName);
        if (propertyPath instanceof String) {
            path = (String)propertyPath;
        }
        return path;
    }
}

