/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.persistence;

import io.moquette.spi.ClientSession;
import io.moquette.spi.IMessagesStore;
import io.moquette.spi.ISessionsStore;
import io.moquette.spi.impl.Utils;
import io.moquette.spi.impl.subscriptions.Subscription;
import io.moquette.spi.persistence.MapDBPersistentStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.mapdb.DB;
import org.mapdb.HTreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MapDBSessionsStore
implements ISessionsStore {
    private static final Logger LOG = LoggerFactory.getLogger(MapDBSessionsStore.class);
    private ConcurrentMap<String, Map<Integer, String>> m_inflightStore;
    private Map<String, Set<Integer>> m_inFlightIds;
    private ConcurrentMap<String, MapDBPersistentStore.PersistentSession> m_persistentSessions;
    private ConcurrentMap<String, List<String>> m_enqueuedStore;
    private ConcurrentMap<String, Set<Integer>> m_secondPhaseStore;
    private final DB m_db;
    private final IMessagesStore m_messagesStore;

    MapDBSessionsStore(DB db, IMessagesStore messagesStore) {
        this.m_db = db;
        this.m_messagesStore = messagesStore;
    }

    @Override
    public void initStore() {
        this.m_inflightStore = this.m_db.getHashMap("inflight");
        this.m_inFlightIds = this.m_db.getHashMap("inflightPacketIDs");
        this.m_persistentSessions = this.m_db.getHashMap("sessions");
        this.m_enqueuedStore = this.m_db.getHashMap("sessionQueue");
        this.m_secondPhaseStore = this.m_db.getHashMap("secondPhase");
    }

    @Override
    public void addNewSubscription(Subscription newSubscription) {
        LOG.debug("addNewSubscription invoked with subscription {}", (Object)newSubscription);
        String clientID = newSubscription.getClientId();
        this.m_db.getHashMap("subscriptions_" + clientID).put(newSubscription.getTopicFilter(), newSubscription);
        if (LOG.isTraceEnabled()) {
            LOG.trace("subscriptions_{}: {}", (Object)clientID, (Object)this.m_db.getHashMap("subscriptions_" + clientID));
        }
    }

    @Override
    public void removeSubscription(String topicFilter, String clientID) {
        LOG.debug("removeSubscription topic filter: {} for clientID: {}", (Object)topicFilter, (Object)clientID);
        if (!this.m_db.exists("subscriptions_" + clientID)) {
            return;
        }
        this.m_db.getHashMap("subscriptions_" + clientID).remove(topicFilter);
    }

    @Override
    public void wipeSubscriptions(String clientID) {
        LOG.debug("wipeSubscriptions");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Subscription pre wipe: subscriptions_{}: {}", (Object)clientID, (Object)this.m_db.getHashMap("subscriptions_" + clientID));
        }
        this.m_db.delete("subscriptions_" + clientID);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Subscription post wipe: subscriptions_{}: {}", (Object)clientID, (Object)this.m_db.getHashMap("subscriptions_" + clientID));
        }
    }

    @Override
    public List<ISessionsStore.ClientTopicCouple> listAllSubscriptions() {
        ArrayList<ISessionsStore.ClientTopicCouple> allSubscriptions = new ArrayList<ISessionsStore.ClientTopicCouple>();
        for (String clientID : this.m_persistentSessions.keySet()) {
            HTreeMap clientSubscriptions = this.m_db.getHashMap("subscriptions_" + clientID);
            for (String topicFilter : clientSubscriptions.keySet()) {
                allSubscriptions.add(new ISessionsStore.ClientTopicCouple(clientID, topicFilter));
            }
        }
        LOG.debug("retrieveAllSubscriptions returning subs {}", (Object)allSubscriptions);
        return allSubscriptions;
    }

    @Override
    public Subscription getSubscription(ISessionsStore.ClientTopicCouple couple) {
        HTreeMap clientSubscriptions = this.m_db.getHashMap("subscriptions_" + couple.clientID);
        LOG.debug("subscriptions_{}: {}", (Object)couple.clientID, (Object)clientSubscriptions);
        return (Subscription)clientSubscriptions.get(couple.topicFilter);
    }

    @Override
    public boolean contains(String clientID) {
        return this.m_db.exists("subscriptions_" + clientID);
    }

    @Override
    public ClientSession createNewSession(String clientID, boolean cleanSession) {
        LOG.debug("createNewSession for client <{}> with clean flag <{}>", (Object)clientID, (Object)cleanSession);
        if (this.m_persistentSessions.containsKey(clientID)) {
            LOG.error("already exists a session for client <{}>, bad condition", (Object)clientID);
            throw new IllegalArgumentException("Can't create a session with the ID of an already existing" + clientID);
        }
        LOG.debug("clientID {} is a newcome, creating it's empty subscriptions set", (Object)clientID);
        this.m_persistentSessions.putIfAbsent(clientID, new MapDBPersistentStore.PersistentSession(cleanSession));
        return new ClientSession(clientID, this.m_messagesStore, this, cleanSession);
    }

    @Override
    public ClientSession sessionForClient(String clientID) {
        if (!this.m_persistentSessions.containsKey(clientID)) {
            return null;
        }
        MapDBPersistentStore.PersistentSession storedSession = (MapDBPersistentStore.PersistentSession)this.m_persistentSessions.get(clientID);
        return new ClientSession(clientID, this.m_messagesStore, this, storedSession.cleanSession);
    }

    @Override
    public void updateCleanStatus(String clientID, boolean cleanSession) {
        this.m_persistentSessions.put(clientID, new MapDBPersistentStore.PersistentSession(cleanSession));
    }

    @Override
    public int nextPacketID(String clientID) {
        Set<Integer> inFlightForClient = this.m_inFlightIds.get(clientID);
        if (inFlightForClient == null) {
            int nextPacketId = 1;
            inFlightForClient = new HashSet<Integer>();
            inFlightForClient.add(nextPacketId);
            this.m_inFlightIds.put(clientID, inFlightForClient);
            return nextPacketId;
        }
        int maxId = inFlightForClient.isEmpty() ? 0 : Collections.max(inFlightForClient);
        int nextPacketId = (maxId + 1) % 65535;
        inFlightForClient.add(nextPacketId);
        return nextPacketId;
    }

    @Override
    public void inFlightAck(String clientID, int messageID) {
        Map m = (Map)this.m_inflightStore.get(clientID);
        if (m == null) {
            LOG.error("Can't find the inFlight record for client <{}>", (Object)clientID);
            return;
        }
        m.remove(messageID);
        Set<Integer> inFlightForClient = this.m_inFlightIds.get(clientID);
        if (inFlightForClient != null) {
            inFlightForClient.remove(messageID);
        }
    }

    @Override
    public void inFlight(String clientID, int messageID, String guid) {
        HashMap<Integer, String> m = (HashMap<Integer, String>)this.m_inflightStore.get(clientID);
        if (m == null) {
            m = new HashMap<Integer, String>();
        }
        m.put(messageID, guid);
        this.m_inflightStore.put(clientID, m);
    }

    @Override
    public void bindToDeliver(String guid, String clientID) {
        List guids = Utils.defaultGet(this.m_enqueuedStore, clientID, new ArrayList());
        guids.add(guid);
        this.m_enqueuedStore.put(clientID, guids);
    }

    @Override
    public Collection<String> enqueued(String clientID) {
        return Utils.defaultGet(this.m_enqueuedStore, clientID, new ArrayList());
    }

    @Override
    public void removeEnqueued(String clientID, String guid) {
        List guids = Utils.defaultGet(this.m_enqueuedStore, clientID, new ArrayList());
        guids.remove(guid);
        this.m_enqueuedStore.put(clientID, guids);
    }

    @Override
    public void secondPhaseAcknowledged(String clientID, int messageID) {
        Set messageIDs = Utils.defaultGet(this.m_secondPhaseStore, clientID, new HashSet());
        messageIDs.remove(messageID);
        this.m_secondPhaseStore.put(clientID, messageIDs);
    }

    @Override
    public void secondPhaseAckWaiting(String clientID, int messageID) {
        Set messageIDs = Utils.defaultGet(this.m_secondPhaseStore, clientID, new HashSet());
        messageIDs.add(messageID);
        this.m_secondPhaseStore.put(clientID, messageIDs);
    }

    @Override
    public String mapToGuid(String clientID, int messageID) {
        HTreeMap messageIdToGuid = this.m_db.getHashMap(MapDBSessionsStore.messageId2GuidsMapName(clientID));
        return (String)messageIdToGuid.get(messageID);
    }

    static String messageId2GuidsMapName(String clientID) {
        return "guidsMapping_" + clientID;
    }
}

