/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.keystore;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.crypto.CryptoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeystoreServiceOptions {
    private static final Logger logger = LoggerFactory.getLogger(KeystoreServiceOptions.class);
    private static final String KEY_SERVICE_PID = "kura.service.pid";
    static final String KEY_KEYSTORE_PATH = "keystore.path";
    static final String KEY_KEYSTORE_PASSWORD = "keystore.password";
    static final String KEY_RANDOMIZE_PASSWORD = "randomize.password";
    private static final String DEFAULT_KEYSTORE_PATH = "/tmp";
    private static final boolean DEFAULT_RANDOMIZE_PASSWORD = false;
    static final String DEFAULT_KEYSTORE_PASSWORD = "changeit";
    private final Map<String, Object> properties;
    private final String pid;
    private final String keystorePath;
    private final Password keystorePassword;
    private final boolean randomPassword;

    public KeystoreServiceOptions(Map<String, Object> properties, CryptoService cryptoService) {
        if (Objects.isNull(properties) || Objects.isNull(cryptoService)) {
            throw new IllegalArgumentException("Input parameters cannot be null!");
        }
        this.properties = properties;
        this.pid = (String)properties.get(KEY_SERVICE_PID);
        this.keystorePath = (String)properties.getOrDefault(KEY_KEYSTORE_PATH, DEFAULT_KEYSTORE_PATH);
        this.keystorePassword = KeystoreServiceOptions.extractPassword(properties, cryptoService);
        this.randomPassword = (Boolean)properties.getOrDefault(KEY_RANDOMIZE_PASSWORD, false);
    }

    private static Password extractPassword(Map<String, Object> properties, CryptoService cryptoService) {
        Object optionsPassword = properties.get(KEY_KEYSTORE_PASSWORD);
        if (optionsPassword instanceof String) {
            return new Password((String)optionsPassword);
        }
        try {
            return new Password(cryptoService.encryptAes(DEFAULT_KEYSTORE_PASSWORD.toCharArray()));
        }
        catch (Exception e) {
            logger.warn("failed to encrypt default keystore password", (Throwable)e);
            return new Password(DEFAULT_KEYSTORE_PASSWORD);
        }
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getPid() {
        return this.pid;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public char[] getKeystorePassword(CryptoService cryptoService) {
        try {
            return cryptoService.decryptAes(this.keystorePassword.getPassword());
        }
        catch (Exception exception) {
            return this.keystorePassword.getPassword();
        }
    }

    public boolean needsRandomPassword() {
        return this.randomPassword;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.keystorePassword == null ? 0 : this.keystorePassword.hashCode());
        result = 31 * result + (this.keystorePath == null ? 0 : this.keystorePath.hashCode());
        result = 31 * result + (this.pid == null ? 0 : this.pid.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.randomPassword ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeystoreServiceOptions other = (KeystoreServiceOptions)obj;
        if (this.keystorePassword == null ? other.keystorePassword != null : !Arrays.equals(this.keystorePassword.getPassword(), other.keystorePassword.getPassword())) {
            return false;
        }
        if (this.keystorePath == null ? other.keystorePath != null : !this.keystorePath.equals(other.keystorePath)) {
            return false;
        }
        if (this.pid == null ? other.pid != null : !this.pid.equals(other.pid)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        boolean result = true;
        if (this.randomPassword != other.randomPassword) {
            result = false;
        }
        return result;
    }
}

