/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.linux.bluetooth.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.bluetooth.BluetoothBeaconData;
import org.eclipse.kura.bluetooth.listener.AdvertisingReportRecord;
import org.eclipse.kura.bluetooth.listener.BluetoothAdvertisementData;
import org.eclipse.kura.core.linux.executor.LinuxSignal;
import org.eclipse.kura.executor.Command;
import org.eclipse.kura.executor.CommandExecutorService;
import org.eclipse.kura.executor.CommandStatus;
import org.eclipse.kura.executor.Pid;
import org.eclipse.kura.executor.Signal;
import org.eclipse.kura.linux.bluetooth.util.BTSnoopListener;
import org.eclipse.kura.linux.bluetooth.util.BluetoothProcess;
import org.eclipse.kura.linux.bluetooth.util.BluetoothProcessListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BluetoothUtil {
    private static final String ERROR_EXECUTING_COMMAND_MESSAGE = "Error executing command: {}";
    private static final Logger logger = LoggerFactory.getLogger(BluetoothUtil.class);
    private static final ExecutorService PROCESS_EXECUTOR = Executors.newSingleThreadExecutor();
    public static final String HCITOOL = "hcitool";
    public static final String BTDUMP = "/tmp/BluetoothUtil.btsnoopdump.sh";
    private static final String BD_ADDRESS = "BD Address:";
    private static final String HCI_VERSION = "HCI Version:";
    private static final String HCICONFIG = "hciconfig";
    private static final String GATTTOOL = "gatttool";
    private static final String DEFAULT_COMPANY_CODE = "004c";

    static {
        try {
            File f = new File(BTDUMP);
            FileUtils.writeStringToFile((File)f, (String)"#!/bin/bash\nset -e\nADAPTER=$1\n{ hcidump -i $ADAPTER -R -w /dev/fd/3 >/dev/null; } 3>&1", (boolean)false);
            if (!f.setExecutable(true)) {
                logger.warn("Unable to set as executable");
            }
        }
        catch (IOException e) {
            logger.info("Unable to update", (Throwable)e);
        }
    }

    private BluetoothUtil() {
    }

    public static Map<String, String> getConfig(String name, CommandExecutorService executorService) throws KuraException {
        HashMap<String, String> props = new HashMap<String, String>();
        String[] commandLine = new String[]{HCICONFIG, name, "version"};
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        Command command = new Command(commandLine);
        command.setTimeout(60);
        command.setOutputStream((OutputStream)outputStream);
        command.setErrorStream((OutputStream)errorStream);
        CommandStatus status = executorService.execute(command);
        if (status.getExitStatus().isSuccessful()) {
            String[] outputLines = new String(outputStream.toByteArray(), Charsets.UTF_8).split("\n");
            props.put("leReady", "false");
            String[] stringArray = outputLines;
            int n = outputLines.length;
            int n2 = 0;
            while (n2 < n) {
                String result = stringArray[n2];
                BluetoothUtil.parseCommandResult(props, result);
                ++n2;
            }
        } else {
            String[] errorLines;
            String[] stringArray = errorLines = new String(errorStream.toByteArray(), Charsets.UTF_8).split("\n");
            int n = errorLines.length;
            int n3 = 0;
            while (n3 < n) {
                String line = stringArray[n3];
                if (line.toLowerCase().contains("command not found")) {
                    throw new KuraException(KuraErrorCode.OPERATION_NOT_SUPPORTED, new Object[]{HCICONFIG});
                }
                if (line.toLowerCase().contains("no such device")) {
                    throw new KuraException(KuraErrorCode.INTERNAL_ERROR);
                }
                ++n3;
            }
        }
        return props;
    }

    private static void parseCommandResult(Map<String, String> props, String result) {
        if (result.indexOf(BD_ADDRESS) >= 0) {
            String[] ss = result.split(" ");
            String address = "";
            String[] stringArray = ss;
            int n = ss.length;
            int n2 = 0;
            while (n2 < n) {
                String sss = stringArray[n2];
                if (sss.matches("^([0-9a-fA-F][0-9a-fA-F]:){5}([0-9a-fA-F][0-9a-fA-F])$")) {
                    address = sss;
                    break;
                }
                ++n2;
            }
            props.put("address", address);
            logger.trace("Bluetooth adapter address set to: {}", (Object)address);
        }
        if (result.indexOf(HCI_VERSION) >= 0 && (result.indexOf("0x6") >= 0 || result.indexOf("0x7") >= 0)) {
            props.put("leReady", "true");
            logger.trace("Bluetooth adapter is LE ready");
        }
    }

    public static boolean isEnabled(String name, CommandExecutorService executorService) {
        boolean isEnabled = false;
        CharSequence[] commandLine = new String[]{HCICONFIG, name};
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        Command command = new Command((String[])commandLine);
        command.setTimeout(60);
        command.setOutputStream((OutputStream)outputStream);
        command.setErrorStream((OutputStream)errorStream);
        CommandStatus status = executorService.execute(command);
        if (status.getExitStatus().isSuccessful()) {
            String[] outputLines;
            String[] stringArray = outputLines = new String(outputStream.toByteArray(), Charsets.UTF_8).split("\n");
            int n = outputLines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line.contains("UP")) {
                    isEnabled = true;
                    break;
                }
                ++n2;
            }
        } else if (logger.isErrorEnabled()) {
            logger.error(ERROR_EXECUTING_COMMAND_MESSAGE, (Object)String.join((CharSequence)" ", commandLine));
        }
        return isEnabled;
    }

    public static String hciconfigCmd(String name, String cmd, CommandExecutorService executorService) {
        String outputString = "";
        CharSequence[] commandLine = new String[]{HCICONFIG, name, cmd};
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        Command command = new Command((String[])commandLine);
        command.setTimeout(60);
        command.setOutputStream((OutputStream)outputStream);
        command.setErrorStream((OutputStream)errorStream);
        CommandStatus status = executorService.execute(command);
        if (status.getExitStatus().isSuccessful()) {
            outputString = new String(outputStream.toByteArray(), Charsets.UTF_8);
        } else if (logger.isErrorEnabled()) {
            logger.error(ERROR_EXECUTING_COMMAND_MESSAGE, (Object)String.join((CharSequence)" ", commandLine));
        }
        return outputString;
    }

    public static void killCmd(String[] cmd, Signal signal, CommandExecutorService executorService) {
        Map<String, Pid> pids = executorService.getPids(cmd).entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(String.join((CharSequence)" ", cmd))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Pid pid : pids.values()) {
            if (executorService.stop(pid, signal)) continue;
            logger.warn("Failed to stop command with pid {}", (Object)pid.getPid());
        }
    }

    public static BluetoothProcess btdumpCmd(String name, BTSnoopListener listener, CommandExecutorService executorService) throws IOException {
        String[] command = new String[]{BTDUMP, name};
        return BluetoothUtil.execSnoop(command, listener, executorService);
    }

    public static BluetoothProcess hcitoolCmd(String name, String cmd, BluetoothProcessListener listener, CommandExecutorService executorService) throws IOException {
        String[] command = new String[]{HCITOOL, "-i", name, cmd};
        return BluetoothUtil.exec(command, listener, executorService);
    }

    public static BluetoothProcess hcitoolCmd(String name, String[] cmd, BluetoothProcessListener listener, CommandExecutorService executorService) throws IOException {
        String[] command = new String[3 + cmd.length];
        command[0] = HCITOOL;
        command[1] = "-i";
        command[2] = name;
        int i = 0;
        while (i < cmd.length) {
            command[i + 3] = cmd[i];
            ++i;
        }
        return BluetoothUtil.exec(command, listener, executorService);
    }

    public static BluetoothProcess startSession(String adapterName, String address, BluetoothProcessListener listener, CommandExecutorService executorService) throws IOException {
        String[] command = new String[]{GATTTOOL, "-i", adapterName, "-b", address, "-I"};
        return BluetoothUtil.exec(command, listener, executorService);
    }

    private static BluetoothProcess exec(String[] cmdArray, BluetoothProcessListener listener, CommandExecutorService executorService) throws IOException {
        Future<BluetoothProcess> futureSafeProcess = PROCESS_EXECUTOR.submit(() -> {
            Thread.currentThread().setName("BluetoothProcessExecutor");
            BluetoothProcess bluetoothProcess = new BluetoothProcess(executorService);
            bluetoothProcess.exec(cmdArray, listener);
            return bluetoothProcess;
        });
        try {
            return futureSafeProcess.get();
        }
        catch (Exception e) {
            logger.error("Error waiting from SafeProcess output", (Throwable)e);
            throw new IOException(e);
        }
    }

    private static BluetoothProcess execSnoop(String[] cmdArray, BTSnoopListener listener, CommandExecutorService executorService) throws IOException {
        Future<BluetoothProcess> futureSafeProcess = PROCESS_EXECUTOR.submit(() -> {
            Thread.currentThread().setName("BTSnoopProcessExecutor");
            BluetoothProcess bluetoothProcess = new BluetoothProcess(executorService);
            bluetoothProcess.execSnoop(cmdArray, listener);
            return bluetoothProcess;
        });
        try {
            return futureSafeProcess.get();
        }
        catch (Exception e) {
            logger.error("Error waiting from SafeProcess output", (Throwable)e);
            throw new IOException(e);
        }
    }

    private static BluetoothBeaconData parseEIRData(byte[] b, int payloadPtr, int len, String companyName) {
        int ptr = payloadPtr;
        while (ptr < payloadPtr + len) {
            byte structSize = b[ptr];
            if (structSize == 0) break;
            byte dataType = b[ptr + 1];
            if (dataType == -1) {
                int prefixPtr = ptr + 2;
                byte[] prefix = new byte[4];
                companyName = BluetoothUtil.inSetHex(BluetoothUtil.inSetRange(companyName, 4, DEFAULT_COMPANY_CODE), DEFAULT_COMPANY_CODE);
                prefix[0] = (byte)Integer.parseInt(companyName.substring(2, 4), 16);
                prefix[1] = (byte)Integer.parseInt(companyName.substring(0, 2), 16);
                prefix[2] = 2;
                prefix[3] = 21;
                if (Arrays.equals(prefix, Arrays.copyOfRange(b, prefixPtr, prefixPtr + prefix.length))) {
                    BluetoothBeaconData bi = new BluetoothBeaconData();
                    int uuidPtr = ptr + 2 + prefix.length;
                    int majorPtr = uuidPtr + 16;
                    int minorPtr = uuidPtr + 18;
                    bi.uuid = "";
                    byte[] byArray = Arrays.copyOfRange(b, uuidPtr, majorPtr);
                    int n = byArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte ub = byArray[n2];
                        bi.uuid = String.valueOf(bi.uuid) + String.format("%02X", ub);
                        ++n2;
                    }
                    int majorl = b[majorPtr + 1] & 0xFF;
                    int majorh = b[majorPtr] & 0xFF;
                    int minorl = b[minorPtr + 1] & 0xFF;
                    int minorh = b[minorPtr] & 0xFF;
                    bi.major = majorh << 8 | majorl;
                    bi.minor = minorh << 8 | minorl;
                    bi.txpower = b[minorPtr + 2];
                    bi.address = "";
                    return bi;
                }
            }
            ptr += structSize + 1;
        }
        return null;
    }

    private static String inSetRange(String value, int range, String defaultValue) {
        if (value.length() != range) {
            return defaultValue;
        }
        return value;
    }

    private static String inSetHex(String value, String defaultValue) {
        if (!value.matches("^[0-9a-fA-F]+$")) {
            return defaultValue;
        }
        return value;
    }

    public static BluetoothAdvertisementData parseLEAdvertisement(byte[] b) {
        BluetoothAdvertisementData btAdData = null;
        if (b[0] != 4 || b[1] != 62) {
            return btAdData;
        }
        if (b[3] != 2) {
            return btAdData;
        }
        btAdData = new BluetoothAdvertisementData();
        btAdData.setRawData(b);
        btAdData.setPacketType(b[0]);
        btAdData.setEventType(b[1]);
        btAdData.setParameterLength((int)b[2]);
        btAdData.setSubEventCode(b[3]);
        btAdData.setNumberOfReports((int)b[4]);
        int ptr = 5;
        int nr = 0;
        while (nr < btAdData.getNumberOfReports()) {
            AdvertisingReportRecord arr = new AdvertisingReportRecord();
            arr.setEventType((int)b[ptr++]);
            arr.setAddressType((int)b[ptr++]);
            String address = String.format("%02X:%02X:%02X:%02X:%02X:%02X", b[ptr + 5], b[ptr + 4], b[ptr + 3], b[ptr + 2], b[ptr + 1], b[ptr + 0]);
            arr.setAddress(address);
            ptr += 6;
            byte arrDataLength = b[ptr++];
            arr.setLength((int)b[ptr++]);
            byte[] arrData = new byte[arrDataLength];
            System.arraycopy(b, ptr, arrData, 0, arrDataLength);
            arr.setReportData(arrData);
            btAdData.addReportRecord(arr);
            ptr += arrDataLength;
            ++nr;
        }
        return btAdData;
    }

    public static List<BluetoothBeaconData> parseLEAdvertisingReport(byte[] b, String companyName) {
        LinkedList<BluetoothBeaconData> results = new LinkedList<BluetoothBeaconData>();
        if (b[0] != 4 || b[1] != 62) {
            return results;
        }
        if (b[3] != 2) {
            return results;
        }
        int numReports = b[4];
        int ptr = 5;
        int i = 0;
        while (i < numReports) {
            byte len;
            BluetoothBeaconData bi;
            ++ptr;
            String address = String.format("%02X:%02X:%02X:%02X:%02X:%02X", b[++ptr + 5], b[ptr + 4], b[ptr + 3], b[ptr + 2], b[ptr + 1], b[ptr + 0]);
            ptr += 6;
            if ((bi = BluetoothUtil.parseEIRData(b, ptr, len = b[ptr++], companyName)) != null) {
                bi.address = address;
                bi.rssi = b[ptr + len];
                results.add(bi);
            }
            ptr += len;
            ++i;
        }
        return results;
    }

    public static boolean stopHcitool(String interfaceName, CommandExecutorService executorService, String ... params) {
        ArrayList<String> killCommand = new ArrayList<String>();
        killCommand.add(HCITOOL);
        killCommand.add("-i");
        killCommand.add(interfaceName);
        Arrays.asList(params).stream().forEach(killCommand::add);
        return executorService.kill(killCommand.toArray(new String[0]), (Signal)LinuxSignal.SIGINT);
    }

    public static boolean stopBtdump(String interfaceName, CommandExecutorService executorService) {
        String[] killCommand = new String[]{BTDUMP, interfaceName};
        return executorService.kill(killCommand, null);
    }
}

