/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.util.osgi;

import org.eclipse.kura.util.base.StringUtil;

public final class FilterUtil {
    private FilterUtil() {
    }

    public static String equal(String property, String value) {
        if (property == null || property.isEmpty()) {
            return "";
        }
        return "(" + FilterUtil.quote(property) + "=" + FilterUtil.quote(value) + ")";
    }

    public static String objectClass(Class<?> clazz) {
        return FilterUtil.equal("objectClass", clazz.getName());
    }

    public static String expressions(String operation, String ... expressions) {
        if (StringUtil.isNullOrEmpty(operation)) {
            throw new IllegalArgumentException("'operation' must not be null or empty");
        }
        if (expressions == null || expressions.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int remaining = 0;
        String[] stringArray = expressions;
        int n = expressions.length;
        int n2 = 0;
        while (n2 < n) {
            String expression = stringArray[n2];
            if (expression != null && !expression.isEmpty()) {
                builder.append(expression);
                ++remaining;
            }
            ++n2;
        }
        if (remaining > 1) {
            return "(" + operation + builder.toString() + ")";
        }
        return builder.toString();
    }

    public static String and(String ... expressions) {
        return FilterUtil.expressions("&", expressions);
    }

    public static String or(String ... expressions) {
        return FilterUtil.expressions("|", expressions);
    }

    public static String not(String expression) {
        if (expression == null || expression.isEmpty()) {
            return "";
        }
        return "(!" + expression + ")";
    }

    public static String simpleFilter(Class<?> objectClass, String property, String value) {
        return FilterUtil.and(FilterUtil.objectClass(objectClass), FilterUtil.equal(property, value));
    }

    public static String quote(String value) {
        if (value == null) {
            return null;
        }
        int len = value.length();
        StringBuilder sb = new StringBuilder(value.length());
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            switch (c) {
                case '(': 
                case ')': 
                case '*': {
                    sb.append('\\');
                    break;
                }
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }
}

