/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.timer;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

final class TimerOptions {
    private static final String PROP_CRON_INTERVAL = "cron.interval";
    private static final String PROP_SIMPLE_INTERVAL = "simple.interval";
    private static final String PROP_SIMPLE_TIME_UNIT = "simple.time.unit";
    private static final String PROP_SIMPLE_TICK_POLICY = "simple.first.tick.policy";
    private static final String PROP_SIMPLE_TICK_POLICY_DEFAULT_VALUE = "DEFAULT";
    private static final String PROP_SIMPLE_TICK_CUSTOM_INTERVAL = "simple.custom.first.tick.interval";
    private static final String PROP_INTERVAL_TYPE = "type";
    private final Map<String, Object> properties;

    TimerOptions(Map<String, Object> properties) {
        Objects.requireNonNull(properties, "Properties cannot be null");
        this.properties = properties;
    }

    String getCronExpression() {
        String expression = null;
        Object interval = this.properties.get(PROP_CRON_INTERVAL);
        if (Objects.nonNull(interval) && interval instanceof String) {
            expression = (String)interval;
        }
        return expression;
    }

    int getSimpleInterval() {
        int interval = 0;
        Object simpleInterval = this.properties.get(PROP_SIMPLE_INTERVAL);
        if (Objects.nonNull(simpleInterval) && simpleInterval instanceof Integer) {
            interval = (Integer)simpleInterval;
        }
        return interval;
    }

    boolean isDefaultFirstTickBehavior() {
        String behavior = PROP_SIMPLE_TICK_POLICY_DEFAULT_VALUE;
        Object selectedBehavior = this.properties.get(PROP_SIMPLE_TICK_POLICY);
        if (Objects.nonNull(selectedBehavior) && selectedBehavior instanceof String) {
            behavior = (String)selectedBehavior;
        }
        boolean result = false;
        if (PROP_SIMPLE_TICK_POLICY_DEFAULT_VALUE.equalsIgnoreCase(behavior)) {
            result = true;
        }
        return result;
    }

    int firstTickInterval() {
        int interval = 0;
        Object firstTickInterval = this.properties.get(PROP_SIMPLE_TICK_CUSTOM_INTERVAL);
        if (Objects.nonNull(firstTickInterval) && firstTickInterval instanceof Integer) {
            interval = (Integer)firstTickInterval;
        }
        return interval;
    }

    String getType() {
        String type = null;
        Object timerType = this.properties.get(PROP_INTERVAL_TYPE);
        if (Objects.nonNull(timerType) && timerType instanceof String) {
            type = (String)timerType;
        }
        return type;
    }

    String getOwnPid() {
        return (String)this.properties.get("kura.service.pid");
    }

    long getSimpleTimeUnitMultiplier() {
        TimeUnit timeUnit;
        String timeUnitString = (String)this.properties.getOrDefault(PROP_SIMPLE_TIME_UNIT, "SECONDS");
        if (TimeUnit.MILLISECONDS.name().equals(timeUnitString)) {
            timeUnit = TimeUnit.MILLISECONDS;
        } else if (TimeUnit.SECONDS.name().equals(timeUnitString)) {
            timeUnit = TimeUnit.SECONDS;
        } else if (TimeUnit.MINUTES.name().equals(timeUnitString)) {
            timeUnit = TimeUnit.MINUTES;
        } else if (TimeUnit.HOURS.name().equals(timeUnitString)) {
            timeUnit = TimeUnit.HOURS;
        } else if (TimeUnit.DAYS.name().equals(timeUnitString)) {
            timeUnit = TimeUnit.DAYS;
        } else {
            throw new IllegalArgumentException("Invalid time unit");
        }
        return timeUnit.toMillis(1L);
    }
}

