/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.jetty.customizer;

import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.CertPathValidator;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.X509CertSelector;
import java.util.Collection;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import javax.net.ssl.KeyManager;
import javax.servlet.SessionCookieConfig;
import org.eclipse.equinox.http.jetty.JettyCustomizer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.kura.jetty.customizer.KuraErrorHandler;

public class KuraJettyCustomizer
extends JettyCustomizer {
    public Object customizeContext(Object context, Dictionary<String, ?> settings) {
        if (!(context instanceof ServletContextHandler)) {
            return context;
        }
        ServletContextHandler servletContextHandler = (ServletContextHandler)context;
        servletContextHandler.getServer().setErrorHandler((ErrorHandler)new KuraErrorHandler());
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setCompressionLevel(9);
        servletContextHandler.setGzipHandler(gzipHandler);
        servletContextHandler.setErrorHandler((ErrorHandler)new KuraErrorHandler());
        SessionCookieConfig cookieConfig = servletContextHandler.getSessionHandler().getSessionCookieConfig();
        cookieConfig.setHttpOnly(true);
        return context;
    }

    public Object customizeHttpConnector(Object connector, Dictionary<String, ?> settings) {
        if (!(connector instanceof ServerConnector)) {
            return connector;
        }
        ServerConnector serverConnector = (ServerConnector)connector;
        Set ports = (Set)settings.get("org.eclipse.kura.http.ports");
        if (ports == null) {
            return null;
        }
        Iterator iterator = ports.iterator();
        while (iterator.hasNext()) {
            int port = (Integer)iterator.next();
            ServerConnector newConnector = new ServerConnector(serverConnector.getServer(), new ConnectionFactory[]{new HttpConnectionFactory(new HttpConfiguration())});
            this.customizeConnector(newConnector, port);
            serverConnector.getServer().addConnector((Connector)newConnector);
        }
        return null;
    }

    public Object customizeHttpsConnector(Object connector, Dictionary<String, ?> settings) {
        Optional<ServerConnector> newConnector;
        Iterator iterator;
        if (!(connector instanceof ServerConnector)) {
            return connector;
        }
        ServerConnector serverConnector = (ServerConnector)connector;
        Set httpsPorts = (Set)settings.get("org.eclipse.kura.https.ports");
        Set httpsClientAuthPorts = (Set)settings.get("org.eclipse.kura.https.client.auth.ports");
        if (httpsPorts != null) {
            iterator = httpsPorts.iterator();
            while (iterator.hasNext()) {
                int httpsPort = (Integer)iterator.next();
                newConnector = this.createSslConnector(serverConnector.getServer(), settings, httpsPort, false);
                newConnector.ifPresent(c -> serverConnector.getServer().addConnector((Connector)c));
            }
        }
        if (httpsClientAuthPorts != null) {
            iterator = httpsClientAuthPorts.iterator();
            while (iterator.hasNext()) {
                int clientAuthPort = (Integer)iterator.next();
                newConnector = this.createSslConnector(serverConnector.getServer(), settings, clientAuthPort, true);
                newConnector.ifPresent(c -> serverConnector.getServer().addConnector((Connector)c));
            }
        }
        return null;
    }

    private Optional<ServerConnector> createSslConnector(Server server, Dictionary<String, ?> settings, int port, boolean enableClientAuth) {
        BaseSslContextFactory sslContextFactory = enableClientAuth ? new ClientAuthSslContextFactoryImpl(settings) : new BaseSslContextFactory();
        Object keystoreProvider = settings.get("org.eclipse.kura.keystore.provider");
        Object keyManagerProvider = settings.get("org.eclipse.kura.keymanager.provider");
        Object crlStore = settings.get("org.eclipse.kura.crl.store");
        Optional<String> keyStorePath = KuraJettyCustomizer.getOptional(settings, "ssl.keystore", String.class);
        Optional<String> keyStorePassword = KuraJettyCustomizer.getOptional(settings, "ssl.password", String.class);
        if (keystoreProvider instanceof Callable && keyManagerProvider instanceof Function) {
            try {
                KeyStore keystore = (KeyStore)((Callable)keystoreProvider).call();
                sslContextFactory.setKeyStore(keystore);
                sslContextFactory.setTrustStore(keystore);
            }
            catch (Exception e) {
                return Optional.empty();
            }
            sslContextFactory.setKeyManagersProvider((Function)keyManagerProvider);
            if (crlStore instanceof CertStore) {
                sslContextFactory.setCRLStore((CertStore)crlStore);
            }
        } else if (keyStorePath.isPresent() && keyStorePassword.isPresent()) {
            sslContextFactory.setKeyStorePath(keyStorePath.get());
            sslContextFactory.setKeyStorePassword(keyStorePassword.get());
            sslContextFactory.setKeyStoreType("JKS");
        } else {
            return Optional.empty();
        }
        sslContextFactory.setProtocol("TLS");
        sslContextFactory.setTrustManagerFactoryAlgorithm("PKIX");
        sslContextFactory.setWantClientAuth(enableClientAuth);
        sslContextFactory.setNeedClientAuth(enableClientAuth);
        HttpConfiguration httpsConfig = new HttpConfiguration();
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)sslContextFactory, "http/1.1"), new HttpConnectionFactory(httpsConfig)});
        this.customizeConnector(connector, port);
        return Optional.of(connector);
    }

    private void customizeConnector(ServerConnector serverConnector, int port) {
        serverConnector.setPort(port);
        for (ConnectionFactory factory : serverConnector.getConnectionFactories()) {
            if (!(factory instanceof HttpConnectionFactory)) continue;
            ((HttpConnectionFactory)factory).getHttpConfiguration().setSendServerVersion(false);
        }
        this.addCustomizer(serverConnector, (HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
    }

    private void addCustomizer(ServerConnector connector, HttpConfiguration.Customizer customizer) {
        for (ConnectionFactory factory : connector.getConnectionFactories()) {
            if (!(factory instanceof HttpConnectionFactory)) continue;
            HttpConnectionFactory httpConnectionFactory = (HttpConnectionFactory)factory;
            httpConnectionFactory.getHttpConfiguration().setSendServerVersion(false);
            LinkedList<HttpConfiguration.Customizer> customizers = httpConnectionFactory.getHttpConfiguration().getCustomizers();
            if (customizers == null) {
                customizers = new LinkedList<HttpConfiguration.Customizer>();
                httpConnectionFactory.getHttpConfiguration().setCustomizers(customizers);
            }
            customizers.add(customizer);
        }
    }

    private static <T> T getOrDefault(Dictionary<String, ?> properties, String key, T defaultValue) {
        Object raw = properties.get(key);
        if (defaultValue.getClass().isInstance(raw)) {
            return (T)raw;
        }
        return defaultValue;
    }

    private static <T> Optional<T> getOptional(Dictionary<String, ?> properties, String key, Class<T> classz) {
        Object raw = properties.get(key);
        if (classz.isInstance(raw)) {
            return Optional.of(raw);
        }
        return Optional.empty();
    }

    private static final class ClientAuthSslContextFactoryImpl
    extends BaseSslContextFactory {
        private final Dictionary<String, ?> settings;

        private ClientAuthSslContextFactoryImpl(Dictionary<String, ?> settings) {
            this.settings = settings;
            boolean isRevocationEnabled = (Boolean)KuraJettyCustomizer.getOrDefault(settings, "org.eclipse.kura.revocation.check.enabled", true);
            this.setValidatePeerCerts(isRevocationEnabled);
        }

        protected PKIXBuilderParameters newPKIXBuilderParameters(KeyStore trustStore, Collection<? extends CRL> crls) throws Exception {
            Optional<CertStore> crlStore;
            PKIXBuilderParameters pbParams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
            boolean isRevocationEnabled = (Boolean)KuraJettyCustomizer.getOrDefault(this.settings, "org.eclipse.kura.revocation.check.enabled", true);
            pbParams.setMaxPathLength(this.getMaxCertPathLength());
            pbParams.setRevocationEnabled(isRevocationEnabled);
            PKIXRevocationChecker revocationChecker = (PKIXRevocationChecker)CertPathValidator.getInstance("PKIX").getRevocationChecker();
            EnumSet revocationOptions = (EnumSet)KuraJettyCustomizer.getOrDefault(this.settings, "org.eclipse.kura.revocation.checker.options", EnumSet.noneOf(PKIXRevocationChecker.Option.class));
            revocationChecker.setOptions(revocationOptions);
            pbParams.addCertPathChecker(revocationChecker);
            if (this.getPkixCertPathChecker() != null) {
                pbParams.addCertPathChecker(this.getPkixCertPathChecker());
            }
            if ((crlStore = this.getCRLStore()).isPresent()) {
                pbParams.addCertStore(crlStore.get());
            } else if (crls != null && !crls.isEmpty()) {
                pbParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(crls)));
            }
            return pbParams;
        }
    }

    private static class BaseSslContextFactory
    extends SslContextFactory.Server {
        private Optional<Function<String, List<KeyManager>>> keyManagersProvider = Optional.empty();
        private Optional<CertStore> crlStore = Optional.empty();

        private BaseSslContextFactory() {
        }

        public void setCRLStore(CertStore crlStore) {
            this.crlStore = Optional.of(crlStore);
        }

        public Optional<CertStore> getCRLStore() {
            return this.crlStore;
        }

        public void setKeyManagersProvider(Function<String, List<KeyManager>> keyManagersProvider) {
            this.keyManagersProvider = Optional.of(keyManagersProvider);
        }

        protected KeyManager[] getKeyManagers(KeyStore keyStore) throws Exception {
            if (this.keyManagersProvider.isPresent()) {
                return this.keyManagersProvider.get().apply(this.getKeyManagerFactoryAlgorithm()).toArray(new KeyManager[0]);
            }
            return super.getKeyManagers(keyStore);
        }
    }
}

