/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import javax.servlet.http.HttpSession;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.audit.AuditConstants;
import org.eclipse.kura.audit.AuditContext;
import org.eclipse.kura.web.Console;
import org.eclipse.kura.web.UserManager;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.session.Attributes;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtPasswordAuthenticationResult;
import org.eclipse.kura.web.shared.service.GwtPasswordAuthenticationService;

public class GwtPasswordAuthenticationServiceImpl
extends OsgiRemoteServiceServlet
implements GwtPasswordAuthenticationService {
    private static final long serialVersionUID = 1L;
    private final UserManager userManager;
    private final String redirectPath;

    public GwtPasswordAuthenticationServiceImpl(UserManager userManager, String redirectPath) {
        this.userManager = userManager;
        this.redirectPath = redirectPath;
    }

    @Override
    public GwtPasswordAuthenticationResult authenticate(String username, String password) throws GwtKuraException {
        HttpSession session = Console.instance().createNewSession(this.getThreadLocalRequest());
        AuditContext context = AuditContext.currentOrInternal();
        context.getProperties().put(AuditConstants.KEY_IDENTITY.getValue(), username);
        try {
            if (!Console.getConsoleOptions().isAuthenticationMethodEnabled("Password")) {
                throw new KuraException(KuraErrorCode.SECURITY_EXCEPTION);
            }
            this.userManager.authenticateWithPassword(username, password);
            context.getProperties().put("session.id", session.getId());
            Console.instance().setAuthenticated(session, username, context.copy());
            boolean needsPasswordChange = this.userManager.isPasswordChangeRequired(username);
            if (needsPasswordChange) {
                session.setAttribute(Attributes.LOCKED.getValue(), (Object)true);
            }
            return new GwtPasswordAuthenticationResult(needsPasswordChange, this.redirectPath);
        }
        catch (Exception exception) {
            session.invalidate();
            throw new GwtKuraException("unauthorized");
        }
    }
}

