/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.shared.model;

import org.eclipse.kura.web.shared.model.GwtBaseModel;

public class GwtWifiChannelModel
extends GwtBaseModel {
    private static final long serialVersionUID = -1471520645150788770L;
    private static final String BAND2400MHZ = "2.4 GHz";
    private static final String BAND5000MHZ = "5.0 GHz";
    private static final int FIRST_2400MHZ_CHANNEL = 1;
    private static final int LAST_2400MHZ_CHANNEL = 14;
    private static final int FIRST_5000MHZ_CHANNEL = 32;

    public GwtWifiChannelModel() {
    }

    public GwtWifiChannelModel(int channel, int frequency) {
        this.set("name", GwtWifiChannelModel.formChannelName(channel));
        this.set("channel", channel);
        this.set("frequency", frequency);
        String band = null;
        if (channel >= 1 && channel <= 14) {
            band = BAND2400MHZ;
        } else if (channel >= 32) {
            band = BAND5000MHZ;
        }
        this.set("band", band);
    }

    public String getName() {
        return (String)this.get("name");
    }

    public int getChannel() {
        Integer iChannel = (Integer)this.get("channel");
        return iChannel;
    }

    public int getFrequency() {
        Integer iFrequency = (Integer)this.get("frequency");
        return iFrequency;
    }

    public String getBand() {
        return (String)this.get("band");
    }

    public void setBand(String band) {
        this.set("band", band);
    }

    public String toString() {
        return this.getName();
    }

    private static String formChannelName(int channel) {
        StringBuilder sb = new StringBuilder();
        sb.append("Channel ");
        sb.append(channel);
        return sb.toString();
    }
}

