/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.eclipse.kura.net.IP4Address;
import org.eclipse.kura.net.IP6Address;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class IPAddress {
    private final byte[] address;
    protected InetAddress javaNetAddress;

    IPAddress(byte[] address, InetAddress jnAddress) {
        this.address = address;
        this.javaNetAddress = jnAddress;
    }

    public static IPAddress getByAddress(byte[] addr) throws UnknownHostException {
        IPAddress result = null;
        InetAddress jnetAddr = InetAddress.getByAddress(addr);
        if (jnetAddr instanceof Inet4Address) {
            result = new IP4Address(addr, jnetAddr);
        } else if (jnetAddr instanceof Inet6Address) {
            result = new IP6Address(addr, jnetAddr);
        }
        return result;
    }

    public static IPAddress getByAddress(int addr) throws UnknownHostException {
        StringBuffer sb = new StringBuffer();
        int shift = 24;
        while (shift > 0) {
            sb.append(Integer.toString(addr >>> shift & 0xFF));
            sb.append('.');
            shift -= 8;
        }
        sb.append(Integer.toString(addr & 0xFF));
        InetAddress jnetAddr = InetAddress.getByName(sb.toString());
        return IPAddress.getByAddress(jnetAddr.getAddress());
    }

    public static IPAddress parseHostAddress(String hostAddress) throws UnknownHostException {
        InetAddress jnetAddr = InetAddress.getByName(hostAddress);
        return IPAddress.getByAddress(jnetAddr.getAddress());
    }

    public byte[] getAddress() {
        return this.address;
    }

    public String getHostAddress() {
        return this.javaNetAddress.getHostAddress();
    }

    public boolean isAnyLocalAddress() {
        return this.javaNetAddress.isAnyLocalAddress();
    }

    public boolean isLinkLocalAddress() {
        return this.javaNetAddress.isLinkLocalAddress();
    }

    public boolean isLoopbackAddress() {
        return this.javaNetAddress.isLoopbackAddress();
    }

    public boolean isMCGlobal() {
        return this.javaNetAddress.isMCGlobal();
    }

    public boolean isMCLinkLocal() {
        return this.javaNetAddress.isMCLinkLocal();
    }

    public boolean isMCNodeLocal() {
        return this.javaNetAddress.isMCNodeLocal();
    }

    public boolean isMCOrgLocal() {
        return this.javaNetAddress.isMCOrgLocal();
    }

    public boolean isMCSiteLocal() {
        return this.javaNetAddress.isMCSiteLocal();
    }

    public boolean isMulticastAddress() {
        return this.javaNetAddress.isMulticastAddress();
    }

    public boolean isSiteLocalAddress() {
        return this.javaNetAddress.isSiteLocalAddress();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.address);
        result = 31 * result + (this.javaNetAddress == null ? 0 : this.javaNetAddress.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IPAddress other = (IPAddress)obj;
        if (!Arrays.equals(this.address, other.address)) {
            return false;
        }
        return !(this.javaNetAddress == null ? other.javaNetAddress != null : !this.javaNetAddress.equals(other.javaNetAddress));
    }
}

